/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.io;

import com.easyinnova.tiff.io.OutputBuffer;
import com.easyinnova.tiff.io.TiffInputStream;
import com.easyinnova.tiff.model.ByteOrder;
import com.easyinnova.tiff.model.types.Long;
import com.easyinnova.tiff.model.types.Rational;
import com.easyinnova.tiff.model.types.SLong;
import com.easyinnova.tiff.model.types.SRational;
import com.easyinnova.tiff.model.types.SShort;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TiffOutputStream {
    TiffInputStream originalFile;
    String filename;
    ByteOrder byteOrder;
    OutputBuffer output;

    public TiffOutputStream(TiffInputStream in) {
        this.originalFile = in;
        this.byteOrder = ByteOrder.BIG_ENDIAN;
        this.output = new OutputBuffer(this.byteOrder);
    }

    public RandomAccessFile getOutputStream() {
        return this.output.getStream();
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void create(String filename) throws IOException {
        this.filename = filename;
        this.output.Create(filename);
    }

    public void close() {
        this.output.close();
    }

    public void seek(int offset) throws IOException {
        this.output.seek(offset);
    }

    public void put(byte val) throws IOException {
        this.writeByteCurrentPosition(val);
    }

    public byte get(int offset) throws IOException {
        return this.originalFile.readByte(offset).toByte();
    }

    public void putShort(short val) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.writeIntCurrentPosition(val >>> 8 & 0xFF);
            this.writeIntCurrentPosition(val >>> 0 & 0xFF);
        } else {
            this.writeIntCurrentPosition(val >>> 0 & 0xFF);
            this.writeIntCurrentPosition(val >>> 8 & 0xFF);
        }
    }

    public void putSShort(SShort val) throws IOException {
        this.putShort(val.getValue());
    }

    public void putInt(int val) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.writeIntCurrentPosition(val >>> 24 & 0xFF);
            this.writeIntCurrentPosition(val >>> 16 & 0xFF);
            this.writeIntCurrentPosition(val >>> 8 & 0xFF);
            this.writeIntCurrentPosition(val >>> 0 & 0xFF);
        } else {
            this.writeIntCurrentPosition(val >>> 0 & 0xFF);
            this.writeIntCurrentPosition(val >>> 8 & 0xFF);
            this.writeIntCurrentPosition(val >>> 16 & 0xFF);
            this.writeIntCurrentPosition(val >>> 24 & 0xFF);
        }
    }

    public void putLong(Long val) throws IOException {
        this.putInt(val.getInternalValue());
    }

    public void putSLong(SLong val) throws IOException {
        this.putInt(val.getValue());
    }

    public void putRational(Rational val) throws IOException {
        this.putInt(val.getNumerator());
        this.putInt(val.getDenominator());
    }

    public void putSRational(SRational val) throws IOException {
        this.putInt(val.getNumerator());
        this.putInt(val.getDenominator());
    }

    public void putFloat(com.easyinnova.tiff.model.types.Float val) throws IOException {
        this.putInt(Float.floatToIntBits(val.getValue()));
    }

    public void putDouble(com.easyinnova.tiff.model.types.Double val) throws IOException {
        long v = Double.doubleToLongBits(val.getValue());
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.writeIntCurrentPosition((int)(v >>> 56) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 48) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 40) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 32) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 24) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 16) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 8) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 0) & 0xFF);
        } else {
            this.writeIntCurrentPosition((int)(v >>> 0) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 8) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 16) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 24) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 32) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 40) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 48) & 0xFF);
            this.writeIntCurrentPosition((int)(v >>> 56) & 0xFF);
        }
    }

    public void writeByteCurrentPosition(byte v) throws IOException {
        this.output.writeByteCurrentPosition(v);
    }

    public void writeIntCurrentPosition(int v) throws IOException {
        this.output.writeIntCurrentPosition(v);
    }

    public long position() throws IOException {
        return this.output.position();
    }
}

