/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.model;

import com.easyinnova.tiff.model.IccProfileCreator;
import com.easyinnova.tiff.model.ReadIccConfigIOException;
import com.easyinnova.tiff.model.TiffTags;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class IccProfileCreators {
    private static IccProfileCreators instance = null;
    public static HashMap<Integer, IccProfileCreator> creatorsMap = new HashMap();

    protected IccProfileCreators() throws ReadIccConfigIOException {
        block11: {
            try {
                Path path = Paths.get("./src/main/resources/iccprofile", new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    FileReader fr = new FileReader("./src/main/resources/iccprofile/creators.txt");
                    BufferedReader br = new BufferedReader(fr);
                    String line = br.readLine();
                    while (line != null) {
                        String[] fields = line.split("\t");
                        if (fields.length == 3) {
                            int signature = Integer.parseInt(fields[1], 16);
                            IccProfileCreator icp = new IccProfileCreator(signature, fields[0], fields[2]);
                            creatorsMap.put(icp.getSignature(), icp);
                        }
                        line = br.readLine();
                    }
                    br.close();
                    fr.close();
                    break block11;
                }
                CodeSource src = TiffTags.class.getProtectionDomain().getCodeSource();
                if (src != null) {
                    ZipEntry zipFile;
                    URL jar = src.getLocation();
                    ZipInputStream zip = new ZipInputStream(jar.openStream());
                    while ((zipFile = zip.getNextEntry()) != null) {
                        String name = zipFile.getName();
                        if (!name.equals("iccprofile/creators.txt")) continue;
                        try {
                            BufferedReader br = new BufferedReader(new InputStreamReader(zip));
                            String line = br.readLine();
                            while (line != null) {
                                String[] fields = line.split("\t");
                                if (fields.length == 3) {
                                    int signature = Integer.parseInt(fields[1], 16);
                                    IccProfileCreator icp = new IccProfileCreator(signature, fields[0], fields[2]);
                                    creatorsMap.put(icp.getSignature(), icp);
                                }
                                line = br.readLine();
                            }
                        }
                        catch (Exception ex) {
                            throw new ReadIccConfigIOException();
                        }
                    }
                    break block11;
                }
                throw new ReadIccConfigIOException();
            }
            catch (Exception ex) {
                throw new ReadIccConfigIOException();
            }
        }
    }

    public static synchronized IccProfileCreators getIccProfileCreators() throws ReadIccConfigIOException {
        if (instance == null) {
            instance = new IccProfileCreators();
        }
        return instance;
    }

    public static IccProfileCreator getIccProfile(int identifier) {
        IccProfileCreator icc = null;
        try {
            if (instance == null) {
                IccProfileCreators.getIccProfileCreators();
            }
            if (creatorsMap.containsKey(identifier)) {
                icc = creatorsMap.get(identifier);
            }
        }
        catch (ReadIccConfigIOException readIccConfigIOException) {
            // empty catch block
        }
        return icc;
    }

    public static boolean hasIccCreator(int id) {
        return creatorsMap.containsKey(id);
    }
}

