/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.model;

import com.easyinnova.tiff.model.Tag;
import com.easyinnova.tiff.model.TagValue;
import com.easyinnova.tiff.model.TiffTags;
import com.easyinnova.tiff.model.types.Ascii;
import com.easyinnova.tiff.model.types.Short;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class IfdTags
implements Serializable {
    private static final long serialVersionUID = 2946L;
    private ArrayList<TagValue> tags = new ArrayList();
    private HashMap<Integer, TagValue> hashTagsId = new HashMap();
    private HashMap<String, TagValue> hashTagsName = new HashMap();

    public void addTag(TagValue tag) {
        Tag t;
        this.tags.add(tag);
        if (!this.hashTagsId.containsKey(tag.getId())) {
            this.hashTagsId.put(tag.getId(), tag);
        }
        if ((t = TiffTags.getTag(tag.getId())) != null && this.hashTagsName.containsKey(t.getName())) {
            this.hashTagsName.put(t.getName(), tag);
        }
    }

    public void addTag(String tagName, int[] tagValue) {
        int id = TiffTags.getTagId(tagName);
        TagValue tag = new TagValue(id, 3);
        for (int i = 0; i < tagValue.length; ++i) {
            Short val = new Short(tagValue[i]);
            tag.add(val);
        }
        this.addTag(tag);
    }

    public void addTag(String tagName, String tagValue) {
        int id = TiffTags.getTagId(tagName);
        TagValue tag = new TagValue(id, 2);
        for (int i = 0; i < tagValue.length(); ++i) {
            char val = tagValue.charAt(i);
            if (val > '\u007f') {
                val = '\u0000';
            }
            Ascii cha = new Ascii(val);
            tag.add(cha);
        }
        Ascii chaf = new Ascii(0);
        tag.add(chaf);
        this.addTag(tag);
    }

    public void removeTag(String tagName) {
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!this.tags.get(i).getName().equals(tagName)) continue;
            this.tags.remove(i);
            if (this.hashTagsName.containsKey(tagName)) {
                this.hashTagsName.remove(tagName);
            }
            if (this.hashTagsId.containsKey(TiffTags.getTagId(tagName))) {
                this.hashTagsId.remove(TiffTags.getTagId(tagName));
            }
            --i;
        }
    }

    public boolean containsTagId(int id) {
        return this.hashTagsId.containsKey(id);
    }

    public TagValue get(int id) {
        return this.hashTagsId.get(id);
    }

    public TagValue get(String tagName) {
        return this.hashTagsId.get(TiffTags.getTagId(tagName));
    }

    public ArrayList<TagValue> getTags() {
        return this.tags;
    }

    public String toString() {
        String s = "";
        for (TagValue t : this.tags) {
            s = s + "[" + t.getName() + ":";
            String st = t.toString();
            s = st.length() < 100 ? s + st : s + st.substring(0, 50) + "...";
            s = s + "]\r\n";
        }
        return s;
    }
}

