/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.model;

import com.easyinnova.tiff.Constants;
import com.easyinnova.tiff.model.Tag;
import com.easyinnova.tiff.model.TiffObject;
import com.easyinnova.tiff.model.TiffTags;
import com.easyinnova.tiff.model.types.Text;
import com.easyinnova.tiff.model.types.abstractTiffType;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TagValue
extends TiffObject
implements Serializable {
    private static final long serialVersionUID = 2946L;
    private int id;
    private int type;
    private List<abstractTiffType> value;
    private transient List<abstractTiffType> valueBackup;
    private List<abstractTiffType> readValue;
    private int offset;
    private int readOffset;
    private int readLength;
    private int tagOffset;

    public TagValue(int id, int type) {
        this.id = id;
        this.type = type;
        this.value = new ArrayList<abstractTiffType>();
        this.readValue = new ArrayList<abstractTiffType>();
        this.valueBackup = new ArrayList<abstractTiffType>();
    }

    public void setReadOffset(int offset) {
        this.readOffset = offset;
    }

    public int getReadOffset() {
        return this.readOffset;
    }

    public int getTagOffset() {
        return this.tagOffset;
    }

    public void setTagOffset(int offset) {
        this.tagOffset = offset;
    }

    public List<abstractTiffType> getDescriptiveValueObject() {
        Tag tag = TiffTags.getTag(this.id);
        if (tag != null) {
            if (tag.hasReadableDescription()) {
                String desc = this.toString();
                String tagDescription = tag.getTextDescription(this.toString());
                if (tagDescription != null) {
                    desc = tagDescription;
                }
                return Arrays.asList(new Text(desc));
            }
            return this.getValue();
        }
        return null;
    }

    public void setReadLength(int length) {
        this.readLength = length;
    }

    public int getReadlength() {
        return this.readLength;
    }

    public List<abstractTiffType> getValue() {
        return this.value;
    }

    public List<abstractTiffType> getValueBackup() {
        return this.valueBackup;
    }

    public void setValue(List<abstractTiffType> value) {
        this.value = value;
    }

    public void setValueBackup(List<abstractTiffType> valueBackup) {
        this.valueBackup = valueBackup;
    }

    public List<abstractTiffType> getReadValue() {
        return this.readValue;
    }

    public String getFirstTextReadValue() {
        if (this.readValue == null) {
            return "";
        }
        for (abstractTiffType rVal : this.readValue) {
            if (!(rVal instanceof Text)) continue;
            return rVal.toString();
        }
        return "";
    }

    public void setReadValue() {
        this.readValue = this.getDescriptiveValueObject();
    }

    public void add(abstractTiffType value) {
        this.value.add(value);
    }

    public int getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public int getCardinality() {
        return this.value != null ? this.value.size() : this.readValue.size();
    }

    public long getFirstNumericValue() {
        String val;
        String string = val = this.value != null ? this.value.get(0).toString() : this.readValue.get(0).toString();
        if (this.isInteger(val)) {
            return Long.parseLong(val);
        }
        return 0L;
    }

    boolean isInteger(String s) {
        return this.isInteger(s, 10);
    }

    boolean isInteger(String s, int radix) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        String s = "";
        if (this.type == 2 || this.type == 7) {
            s = this.readString();
        } else {
            boolean defined = false;
            try {
                defined = TiffTags.hasTag(this.id) && TiffTags.getTag(this.id).hasTypedef();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (defined) {
                s = this.value.size() > 0 ? this.value.get(0).toString() : "";
            } else if (this.type != 1 || this.value.size() < 10) {
                int n = this.value.size();
                if (n > 1) {
                    s = s + "[";
                }
                for (int i = 0; i < n; ++i) {
                    s = s + this.value.get(i).toString();
                    if (n > 1 && i + 1 < n) {
                        s = s + ",";
                    }
                    if (s.length() > Constants.MaxStringSize) break;
                }
                if (n > 1) {
                    s = s + "]";
                }
            }
        }
        return s.replaceAll("\\p{C}", "?");
    }

    public String readString() {
        int size = this.value.size();
        if (size > Constants.MaxStringSize) {
            size = Constants.MaxStringSize;
        }
        if (this.value == null || size == 0) {
            return "";
        }
        byte[] bbs = new byte[size - 1];
        for (int i = 0; i < size - 1; ++i) {
            abstractTiffType att = this.value.get(i);
            bbs[i] = att.toByte();
        }
        try {
            return new String(bbs, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public String getName() {
        String name = "" + this.id;
        if (TiffTags.hasTag(this.id)) {
            name = TiffTags.getTag(this.id).getName();
        }
        return name;
    }

    public int getBytesBigEndian(int i, int j) {
        int result = 0;
        for (int k = i; k < i + j; ++k) {
            result += this.value.get(k).toUint();
            if (k + 1 >= i + j) continue;
            result <<= 8;
        }
        return result;
    }

    public void clear() {
        this.value.clear();
    }

    public void reset() {
        this.value = new ArrayList<abstractTiffType>();
        this.readValue = new ArrayList<abstractTiffType>();
    }
}

