/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.model;

import com.easyinnova.tiff.model.ReadTagsIOException;
import com.easyinnova.tiff.model.Tag;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class TiffTags {
    public static HashMap<Integer, Tag> tagMap = new HashMap();
    public static HashMap<Integer, String> tagTypes = new HashMap();
    protected static HashMap<String, Tag> tagNames = new HashMap();
    private static TiffTags instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Tag readTagFromBuffer(BufferedReader br, boolean close) {
        int id = 0;
        String name = "";
        String forceDescription = null;
        ArrayList<String> types = new ArrayList<String>();
        String cardinality = "";
        String defaultValue = "";
        String typedef = null;
        String description = null;
        String[] valueCodes = null;
        String[] valueDescriptions = null;
        try {
            String sCurrentLine;
            boolean readingTypes = false;
            while ((sCurrentLine = br.readLine()) != null) {
                String sval;
                if (sCurrentLine.contains("\"id\"")) {
                    String sid = sCurrentLine.substring(sCurrentLine.indexOf(":") + 1).replace(",", "").trim();
                    id = Integer.parseInt(sid);
                    continue;
                }
                if (sCurrentLine.contains("\"name\"")) {
                    name = sval = sCurrentLine.substring(sCurrentLine.indexOf(":") + 1).replace("\"", "").replace(",", "").trim();
                    continue;
                }
                if (sCurrentLine.contains("\"forceDescription\"")) {
                    forceDescription = sval = sCurrentLine.substring(sCurrentLine.indexOf(":") + 1).replace("\"", "").replace(",", "").trim();
                    continue;
                }
                if (sCurrentLine.contains("\"cardinality\"")) {
                    cardinality = sval = sCurrentLine.substring(sCurrentLine.indexOf(":") + 1).replace("\"", "").replace(",", "").trim();
                    continue;
                }
                if (sCurrentLine.contains("\"defaultValue\"")) {
                    defaultValue = sval = sCurrentLine.substring(sCurrentLine.indexOf(":") + 1).replace("\"", "").replace(",", "").trim();
                    continue;
                }
                if (sCurrentLine.contains("\"valueCodes\"")) {
                    sCurrentLine = br.readLine();
                    valueCodes = sCurrentLine.split(",");
                    continue;
                }
                if (sCurrentLine.contains("\"description\"")) {
                    description = sCurrentLine.substring(sCurrentLine.indexOf(":") + 1).replace("\"", "").replace(",", "").trim();
                    continue;
                }
                if (sCurrentLine.contains("\"valueDescriptions\"")) {
                    sCurrentLine = br.readLine();
                    valueDescriptions = sCurrentLine.split(",");
                    continue;
                }
                if (sCurrentLine.contains("\"typedef\"")) {
                    typedef = sval = sCurrentLine.substring(sCurrentLine.indexOf(":") + 1).replace("\"", "").replace(",", "").trim();
                    continue;
                }
                if (sCurrentLine.contains("\"type\"")) {
                    readingTypes = true;
                    continue;
                }
                if (sCurrentLine.contains("],")) {
                    readingTypes = false;
                    continue;
                }
                if (!readingTypes) continue;
                sval = sCurrentLine.replace("\"", "").replace(",", "").trim();
                types.add(sval);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null && close) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        Tag tag = new Tag(id, name, types, cardinality, defaultValue, typedef, forceDescription);
        tag.setDescription(description);
        tag.createValuesDictionary();
        if (valueCodes != null && valueDescriptions != null && valueCodes.length == valueDescriptions.length) {
            HashMap<String, String> values = new HashMap<String, String>();
            for (int i = 0; i < valueCodes.length; ++i) {
                values.put(valueCodes[i].trim(), valueDescriptions[i].trim().replace("\"", ""));
            }
            tag.setValues(values);
        }
        tagMap.put(tag.getId(), tag);
        tagNames.put(tag.getName(), tag);
        return tag;
    }

    protected TiffTags() throws ReadTagsIOException {
        try {
            Path path = Paths.get("./src/main/resources/tifftags", new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                File folder = new File("./src/main/resources/tifftags/");
                if (folder.exists() && folder.isDirectory()) {
                    for (File fileEntry : folder.listFiles()) {
                        try {
                            FileReader fr = new FileReader(fileEntry.toPath().toString());
                            BufferedReader br = new BufferedReader(fr);
                            TiffTags.readTagFromBuffer(br, true);
                        }
                        catch (FileNotFoundException e) {
                            throw new ReadTagsIOException();
                        }
                    }
                }
            } else {
                CodeSource src = TiffTags.class.getProtectionDomain().getCodeSource();
                if (src != null) {
                    ZipEntry zipFile;
                    URL jar = src.getLocation();
                    ZipInputStream zip = new ZipInputStream(jar.openStream());
                    while ((zipFile = zip.getNextEntry()) != null) {
                        String name = zipFile.getName();
                        if (!name.startsWith("tifftags/") || name.equals("tifftags/")) continue;
                        try {
                            BufferedReader in = new BufferedReader(new InputStreamReader(zip));
                            TiffTags.readTagFromBuffer(in, false);
                        }
                        catch (Exception ex) {
                            throw new ReadTagsIOException();
                        }
                    }
                } else {
                    throw new ReadTagsIOException();
                }
            }
            tagTypes.put(1, "BYTE");
            tagTypes.put(2, "ASCII");
            tagTypes.put(3, "SHORT");
            tagTypes.put(4, "LONG");
            tagTypes.put(5, "RATIONAL");
            tagTypes.put(6, "SBYTE");
            tagTypes.put(7, "UNDEFINED");
            tagTypes.put(8, "SSHORT");
            tagTypes.put(9, "SSHORT");
            tagTypes.put(10, "SRATIONAL");
            tagTypes.put(11, "FLOAT");
            tagTypes.put(12, "DOUBLE");
            tagTypes.put(13, "SUBIFD");
        }
        catch (Exception ex) {
            throw new ReadTagsIOException();
        }
    }

    protected void generateTagRules() throws ReadTagsIOException {
        try {
            Tag tag;
            PrintWriter writer = new PrintWriter("typecheck.xml", "UTF-8");
            for (int tagId : tagMap.keySet()) {
                tag = tagMap.get(tagId);
                writer.println("  <rule context=\"tag[id=" + tag.getId() + "]\">");
                String typeRule = "";
                for (String tagType : tag.getType()) {
                    if (typeRule.length() > 0) {
                        typeRule = typeRule + " || ";
                    }
                    typeRule = typeRule + "{type=='" + tagType + "'}";
                }
                writer.println("   <assert test=\"" + typeRule + "\">Tag type does not match</assert>");
                writer.println("  </rule>");
            }
            writer.close();
            writer = new PrintWriter("cardinalitycheck.xml", "UTF-8");
            for (int tagId : tagMap.keySet()) {
                tag = tagMap.get(tagId);
                if (tag.getCardinality().length() <= 0 || tag.getCardinality().equals("N")) continue;
                try {
                    int card = Integer.parseInt(tag.getCardinality());
                    writer.println("  <rule context=\"tag[id=" + tag.getId() + "]\">");
                    String typeRule = "{cardinality==" + card + "}";
                    writer.println("   <assert test=\"" + typeRule + "\">Tag cardinality does not match</assert>");
                    writer.println("  </rule>");
                }
                catch (Exception ex) {
                    System.err.println("Formula in tag " + tag.getName() + ": " + tag.getCardinality());
                }
            }
            writer.close();
        }
        catch (Exception ex) {
            throw new ReadTagsIOException();
        }
    }

    public static synchronized TiffTags getTiffTags() throws ReadTagsIOException {
        if (instance == null) {
            instance = new TiffTags();
        }
        return instance;
    }

    public static Tag getTag(int identifier) {
        Tag t = null;
        try {
            if (instance == null) {
                TiffTags.getTiffTags();
            }
        }
        catch (ReadTagsIOException readTagsIOException) {
            // empty catch block
        }
        if (tagMap.containsKey(identifier)) {
            t = tagMap.get(identifier);
        }
        return t;
    }

    public static int getTypeSize(int type) {
        int typeSize = 1;
        switch (type) {
            case 3: 
            case 8: {
                typeSize = 2;
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 13: {
                typeSize = 4;
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                typeSize = 8;
                break;
            }
            default: {
                typeSize = 1;
            }
        }
        return typeSize;
    }

    public static int getTagId(String name) {
        int id = -1;
        try {
            if (instance == null) {
                TiffTags.getTiffTags();
            }
        }
        catch (ReadTagsIOException readTagsIOException) {
            // empty catch block
        }
        if (tagNames.containsKey(name)) {
            id = tagNames.get(name).getId();
        }
        return id;
    }

    public static boolean hasTag(int id) {
        return tagMap.containsKey(id);
    }

    public static String getTagTypeName(int id) {
        return tagTypes.get(id);
    }
}

