/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.model;

import com.easyinnova.tiff.model.ValidationEvent;
import java.io.Serializable;
import java.util.ArrayList;

public class ValidationResult
implements Serializable {
    private static final long serialVersionUID = 2946L;
    public ArrayList<ValidationEvent> errors = new ArrayList();
    public ArrayList<ValidationEvent> warnings = new ArrayList();
    public boolean correct = true;
    private boolean validate;
    private boolean fatalError;
    private String fatalErrorMessage;

    public ValidationResult(boolean validate) {
        this.validate = validate;
        this.fatalError = false;
        this.fatalErrorMessage = "";
    }

    private void iaddError(String desc, String value, String loc) {
        if (!this.validate) {
            return;
        }
        ValidationEvent ve = new ValidationEvent(desc, value, loc);
        this.errors.add(ve);
        this.correct = false;
    }

    private void iaddWarning(String desc, String value, String loc) {
        if (!this.validate) {
            return;
        }
        ValidationEvent ve = new ValidationEvent(desc, value, loc);
        this.warnings.add(ve);
    }

    public void addError(String desc, String loc, long value) {
        this.iaddError(desc, "" + value, loc);
    }

    public void addError(String desc, String loc, String value) {
        this.iaddError(desc, "" + value, loc);
    }

    public void addError(String desc, String loc, float value) {
        this.iaddError(desc, "" + value, loc);
    }

    public void addErrorLoc(String desc, String loc) {
        this.iaddError(desc, null, loc);
    }

    public void setFatalError(boolean value, String message) {
        this.fatalError = value;
        if (this.fatalErrorMessage.length() > 0) {
            this.fatalErrorMessage = this.fatalErrorMessage + "\n";
        }
        this.fatalErrorMessage = this.fatalErrorMessage + message;
    }

    public boolean getFatalError() {
        return this.fatalError;
    }

    public String getFatalErrorMessage() {
        return this.fatalErrorMessage;
    }

    public void addWarning(String desc, String value, String loc) {
        this.iaddWarning(desc, value, loc);
    }

    public void add(ValidationResult validation) {
        this.correct &= validation.correct;
        if (!this.validate) {
            return;
        }
        this.errors.addAll(validation.errors);
        this.warnings.addAll(validation.warnings);
    }

    public void printErrors() {
        for (ValidationEvent ve : this.errors) {
            ve.printError();
        }
    }

    public void printWarnings() {
        for (ValidationEvent ve : this.warnings) {
            ve.printWarning();
        }
    }

    public boolean isCorrect() {
        return this.correct;
    }

    public ArrayList<ValidationEvent> getErrors() {
        return this.errors;
    }

    public ArrayList<ValidationEvent> getWarnings() {
        return this.warnings;
    }
}

