/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.model.types;

import com.easyinnova.tiff.model.IccProfileCreator;
import com.easyinnova.tiff.model.IccProfileCreators;
import com.easyinnova.tiff.model.TagValue;
import com.easyinnova.tiff.model.types.IccTags;
import com.easyinnova.tiff.model.types.abstractTiffType;
import java.io.IOException;

public class IccProfile
extends abstractTiffType {
    public IccTags tags;
    private String version = null;
    private String description;
    private IccProfileCreator creator = null;
    private ProfileClass profileClass;
    private boolean embedded;

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean getEmbedded() {
        return this.embedded;
    }

    public IccProfileCreator getCreator() {
        return this.creator;
    }

    public String toString() {
        if (this.description != null) {
            return this.description;
        }
        String s = "";
        String scr = "Unknown creator";
        if (this.creator != null) {
            scr = this.creator.getCreator();
        }
        s = "[" + scr + ", " + this.version + "]";
        return s;
    }

    private void readVersion(TagValue tv) {
        int maj = tv.getBytesBigEndian(8, 1);
        int min = (tv.getBytesBigEndian(9, 1) & 0xF0) >> 4;
        this.version = maj + "." + min;
    }

    private boolean readEmbedded(TagValue tv) {
        int val = tv.getBytesBigEndian(44, 4);
        this.embedded = val % 2 == 1;
        return this.embedded;
    }

    private void readClass(TagValue tv) {
        int profileClass = tv.getBytesBigEndian(12, 4);
        String hex = Integer.toHexString(profileClass);
        this.profileClass = hex.equals("73636e72") ? ProfileClass.Input : (hex.equals("6d6e7472") ? ProfileClass.Display : (hex.equals("70727472") ? ProfileClass.Output : (hex.equals("6C696e6b") ? ProfileClass.DeviceLink : (hex.equals("73706163") ? ProfileClass.ColorSpace : (hex.equals("61627374") ? ProfileClass.Abstract : (hex.equals("6e6d636c") ? ProfileClass.NamedColor : ProfileClass.Unknown))))));
    }

    public ProfileClass getProfileClass() {
        return this.profileClass;
    }

    private void readCreator(TagValue tv) {
        int creatorSignature = tv.getBytesBigEndian(4, 4);
        this.creator = IccProfileCreators.getIccProfile(creatorSignature);
    }

    private void readDescription(TagValue tv) throws NumberFormatException, IOException {
        int index = 128;
        int tagCount = tv.getBytesBigEndian(index, 4);
        index += 4;
        for (int i = 0; i < tagCount; ++i) {
            int signature = tv.getBytesBigEndian(index, 4);
            int tagOffset = tv.getBytesBigEndian(index + 4, 4);
            if (Integer.toHexString(signature).equals("64657363")) {
                String typedesc = Integer.toHexString(tv.getBytesBigEndian(tagOffset, 4));
                if (typedesc.equals("64657363")) {
                    int size = tv.getBytesBigEndian(tagOffset + 8, 4) - 1;
                    String s = "";
                    int j = 0;
                    int begin = tagOffset + 12;
                    while (begin + j < begin + size) {
                        int unicode_char = tv.getBytesBigEndian(begin + j, 1);
                        s = s + Character.toString((char)unicode_char);
                        ++j;
                    }
                    this.description = s;
                } else {
                    this.description = "";
                }
            }
            index += 12;
        }
    }

    @Override
    public void read(TagValue tv) {
        this.readClass(tv);
        this.readVersion(tv);
        this.readCreator(tv);
        this.readEmbedded(tv);
        try {
            this.readDescription(tv);
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
        }
        tv.clear();
        tv.add(this);
    }

    public static enum ProfileClass {
        Input,
        Display,
        Output,
        DeviceLink,
        ColorSpace,
        Abstract,
        NamedColor,
        Unknown;

    }
}

