/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.model.types;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPIterator;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.options.SerializeOptions;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.easyinnova.tiff.io.TiffOutputStream;
import com.easyinnova.tiff.model.Metadata;
import com.easyinnova.tiff.model.MetadataObject;
import com.easyinnova.tiff.model.TagValue;
import com.easyinnova.tiff.model.TiffObject;
import com.easyinnova.tiff.model.types.Text;
import com.easyinnova.tiff.model.types.XmlType;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMP
extends XmlType {
    private transient XMPMeta xmpMeta;
    private Metadata metadata = null;
    private List<Hashtable<String, String>> history;

    @Override
    public Metadata createMetadata() throws Exception {
        if (this.metadata == null) {
            this.reCreateMetadata();
        }
        return this.metadata;
    }

    void reCreateMetadata() throws ParserConfigurationException, TransformerException, SAXException, IOException, XMPException {
        this.metadata = new Metadata();
        if (this.xmpMeta != null) {
            String parentDNS = null;
            XMPIterator iterator = this.xmpMeta.iterator();
            while (iterator.hasNext()) {
                XMPPropertyInfo propInfo = (XMPPropertyInfo)iterator.next();
                String path = propInfo.getPath();
                String value = propInfo.getValue();
                if (path != null && value != null && path.length() > 0 && value.length() > 0) {
                    if (path.contains("xmpMM:History") && path.contains("stEvt")) {
                        if (this.history == null) {
                            this.history = new ArrayList<Hashtable<String, String>>();
                        }
                        Hashtable<String, String> action = new Hashtable<String, String>();
                        String name = path;
                        if (path.contains(":")) {
                            name = path.substring(path.lastIndexOf(":") + 1);
                        }
                        action.put(name, value);
                        this.history.add(action);
                        continue;
                    }
                    String name = path;
                    if (path.contains(":")) {
                        name = path.substring(path.indexOf(":") + 1);
                    }
                    if (name.contains("[")) {
                        name = name.substring(0, name.indexOf("[")).trim();
                    }
                    Text txt = new Text(value);
                    txt.setContainer("XMP");
                    this.metadata.add(name, (TiffObject)txt, path, propInfo.getNamespace());
                    if (!path.toLowerCase().startsWith("dc")) continue;
                    this.metadata.getMetadataObject(name).setIsDublinCore(true);
                    this.metadata.getMetadataObject(name).setSchema(parentDNS);
                    continue;
                }
                parentDNS = propInfo.getNamespace();
            }
        } else {
            this.oldSchool();
        }
    }

    public String getCreator() {
        return this.getTag("creator");
    }

    public String getCopyright() {
        return this.getTag("rights");
    }

    public String getDescription() {
        return this.getTag("description");
    }

    public String getDatetime() {
        return this.getTag("CreateDate");
    }

    public String getTag(String name) {
        if (this.metadata == null) {
            try {
                this.createMetadata();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (this.metadata.contains(name)) {
            return this.metadata.get(name).toString();
        }
        return null;
    }

    public void editCopyright(String value) {
        try {
            this.editTag("rights", value);
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void editCreator(String value) {
        try {
            this.editTag("creator", value);
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void editDescription(String value) {
        try {
            this.editTag("description", value);
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void editDatetime(String value) {
        try {
            this.editTag("CreateDate", value);
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void editTag(String tagName, String tagValue) throws Exception {
        MetadataObject mdo = this.metadata.getMetadataObject(tagName);
        String schema = mdo.getSchema();
        String name = tagName;
        if (mdo.isDublinCore()) {
            name = "dc:" + name + "[1]";
        }
        this.xmpMeta.setProperty(schema, name, tagValue);
        this.reCreateMetadata();
    }

    @Deprecated
    void oldSchool() throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        builder.setErrorHandler(null);
        Document doc = builder.parse(new InputSource(this.xmlReader));
        DocumentTraversal traversal = (DocumentTraversal)((Object)doc);
        NodeIterator iterator = traversal.createNodeIterator(doc.getDocumentElement(), 1, null, true);
        Node n = iterator.nextNode();
        while (n != null) {
            Element elem = (Element)n;
            String name = elem.getTagName();
            String content = elem.getTextContent();
            String nameWithoutPrefix = name;
            String prefix = "";
            if (name.contains(":")) {
                nameWithoutPrefix = name.substring(name.indexOf(":") + 1);
                prefix = name.substring(0, name.indexOf(":"));
            }
            if (!(prefix.equals("x") || prefix.equals("rdf") || prefix.toLowerCase().equals("stevt"))) {
                Text txt = new Text(content);
                txt.setContainer("XMP");
                this.metadata.add(nameWithoutPrefix, (TiffObject)txt, null, null);
                if (name.toLowerCase().startsWith("dc")) {
                    this.metadata.getMetadataObject(nameWithoutPrefix).setIsDublinCore(true);
                }
            }
            n = iterator.nextNode();
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        String sXml = writer.getBuffer().toString().replaceAll("\n|\r", "");
        this.history = null;
        try {
            if (sXml.contains("xmpMM:History")) {
                String sHistory = sXml.substring(sXml.indexOf("xmpMM:History"));
                sHistory = sHistory.substring(0, sHistory.indexOf("</xmpMM:History>"));
                this.history = new ArrayList<Hashtable<String, String>>();
                int index = sHistory.indexOf("xmpMM:History");
                while (sHistory.indexOf("<rdf:li", index) > 0) {
                    index = sHistory.indexOf("<rdf:li", index);
                    String subs = sHistory.substring(index);
                    int fi = subs.indexOf("</rdf:li");
                    if (subs.indexOf("/>") != -1 && (fi == -1 || subs.indexOf("/>") < fi)) {
                        fi = subs.indexOf("/>");
                    }
                    subs = subs.substring(0, fi);
                    Hashtable<String, String> action = new Hashtable<String, String>();
                    int index2 = 0;
                    while (subs.indexOf("stEvt:", index2) > 0) {
                        String stevt;
                        if (subs.indexOf("<stEvt:", index2) > -1) {
                            index2 = subs.indexOf("stEvt:", index2);
                            stevt = subs.substring(index2);
                            stevt = stevt.substring(0, stevt.indexOf("</stEvt") + 2);
                            String name = stevt.substring(stevt.indexOf(":") + 1);
                            name = name.substring(0, name.indexOf(">"));
                            String value = stevt.substring(stevt.indexOf(">") + 1);
                            value = value.substring(0, value.indexOf("</"));
                            action.put(name, value);
                            index2 = subs.indexOf("</stEvt:", index2) + 9;
                            continue;
                        }
                        index2 = subs.indexOf("stEvt:", index2);
                        stevt = subs.substring(index2);
                        int fin = stevt.indexOf("\"", stevt.indexOf("\"") + 1);
                        stevt = stevt.substring(0, fin);
                        String name = stevt.substring(stevt.indexOf(":") + 1);
                        name = name.substring(0, name.indexOf("="));
                        String value = stevt.substring(stevt.indexOf("\"") + 1);
                        action.put(name, value);
                        index2 += fin;
                    }
                    this.history.add(action);
                    index += fi;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean containsMetadata() {
        return true;
    }

    @Override
    public void read(TagValue tv) throws Exception {
        super.read(tv);
        this.xmpMeta = XMPMetaFactory.parseFromBuffer(this.getBytes());
        this.createMetadata();
    }

    public void write(TiffOutputStream data) throws IOException, XMPException {
        byte[] buffer;
        SerializeOptions options = new SerializeOptions();
        for (byte b : buffer = XMPMetaFactory.serializeToBuffer(this.xmpMeta, options)) {
            data.put(b);
        }
    }

    public int getLength() {
        SerializeOptions options = new SerializeOptions();
        try {
            byte[] buffer = XMPMetaFactory.serializeToBuffer(this.xmpMeta, options);
            return buffer.length;
        }
        catch (XMPException e) {
            e.printStackTrace();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public List<Hashtable<String, String>> getHistory() {
        return this.history;
    }
}

