/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.profiles;

import com.easyinnova.tiff.model.IfdTags;
import com.easyinnova.tiff.model.TiffDocument;
import com.easyinnova.tiff.model.TiffObject;
import com.easyinnova.tiff.model.TiffTags;
import com.easyinnova.tiff.model.types.IFD;
import com.easyinnova.tiff.profiles.GenericProfile;
import com.easyinnova.tiff.profiles.Profile;

public class TiffITProfile
extends GenericProfile
implements Profile {
    private int profile;
    private int currentIfd;

    public TiffITProfile(TiffDocument doc, int profile) {
        super(doc);
        this.profile = profile;
    }

    @Override
    public void validate() {
        try {
            this.currentIfd = 0;
            for (TiffObject o : this.model.getImageIfds()) {
                ++this.currentIfd;
                IFD ifd = (IFD)o;
                IfdTags metadata = ifd.getMetadata();
                int sft = -1;
                int photo = -1;
                int bps = -1;
                int planar = -1;
                int comp = -1;
                if (metadata.containsTagId(TiffTags.getTagId("SubfileType"))) {
                    sft = (int)metadata.get(TiffTags.getTagId("SubfileType")).getFirstNumericValue();
                }
                if (metadata.containsTagId(TiffTags.getTagId("Compression"))) {
                    comp = (int)metadata.get(TiffTags.getTagId("Compression")).getFirstNumericValue();
                }
                if (metadata.containsTagId(TiffTags.getTagId("PhotometricInterpretation"))) {
                    photo = (int)metadata.get(TiffTags.getTagId("PhotometricInterpretation")).getFirstNumericValue();
                }
                if (metadata.containsTagId(TiffTags.getTagId("BitsPerSample"))) {
                    bps = (int)metadata.get(TiffTags.getTagId("BitsPerSample")).getFirstNumericValue();
                }
                if (metadata.containsTagId(TiffTags.getTagId("PlanarConfiguration"))) {
                    planar = (int)metadata.get(TiffTags.getTagId("PlanarConfiguration")).getFirstNumericValue();
                }
                int p = this.profile;
                if (sft != 1 && sft != -1) continue;
                if (comp == 1 || comp == 32895) {
                    if (photo == 5) {
                        if (planar == 1) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (planar == 32768) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (planar != 2) continue;
                        if (bps > 1) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (bps != 1) continue;
                        this.validateIfdSD(ifd, p);
                        continue;
                    }
                    if (photo == 2) {
                        if (planar == 1) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (planar == 32768) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (planar != 2) continue;
                        this.validateIfdCT(ifd, p);
                        continue;
                    }
                    if (photo == 8) {
                        if (planar == 1) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (planar == 32768) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (planar != 2) continue;
                        this.validateIfdCT(ifd, p);
                        continue;
                    }
                    if (photo != 0 && photo != 1) continue;
                    if (bps == 1) {
                        this.validateIfdBP(ifd, p);
                        continue;
                    }
                    if (bps <= 1) continue;
                    this.validateIfdMP(ifd, p);
                    continue;
                }
                if (comp == 4) {
                    if (photo == 0 || photo == 1) {
                        this.validateIfdBP(ifd, p);
                        continue;
                    }
                    if (photo != 5) continue;
                    this.validateIfdSD(ifd, p);
                    continue;
                }
                if (comp == 7) {
                    if (photo == 5) {
                        if (planar != 1) continue;
                        this.validateIfdCT(ifd, p);
                        continue;
                    }
                    if (photo == 2) {
                        if (planar != 1) continue;
                        this.validateIfdCT(ifd, p);
                        continue;
                    }
                    if (photo == 6) {
                        if (planar != 1) continue;
                        this.validateIfdCT(ifd, p);
                        continue;
                    }
                    if (photo == 8) {
                        if (planar != 1) continue;
                        this.validateIfdCT(ifd, p);
                        continue;
                    }
                    if (photo != 0 && photo != 1 || bps <= 1) continue;
                    this.validateIfdMP(ifd, p);
                    continue;
                }
                if (comp == 8) {
                    if (photo == 5) {
                        if (planar == 1) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (planar == 32768) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (planar != 2) continue;
                        if (bps > 1) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (bps != 1) continue;
                        this.validateIfdSD(ifd, p);
                        continue;
                    }
                    if (photo == 2) {
                        if (planar == 1) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (planar == 32768) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (planar != 2) continue;
                        this.validateIfdCT(ifd, p);
                        continue;
                    }
                    if (photo == 8) {
                        if (planar == 1) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (planar == 32768) {
                            this.validateIfdCT(ifd, p);
                            continue;
                        }
                        if (planar != 2) continue;
                        this.validateIfdCT(ifd, p);
                        continue;
                    }
                    if (photo != 0 && photo != 1) continue;
                    if (bps == 1) {
                        this.validateIfdBP(ifd, p);
                        continue;
                    }
                    if (bps <= 1) continue;
                    this.validateIfdMP(ifd, p);
                    continue;
                }
                if (comp == 32896) {
                    this.validateIfdLW(ifd, p);
                    continue;
                }
                if (comp == 32897) {
                    this.validateIfdHC(ifd, p);
                    continue;
                }
                if (comp == 32898) {
                    this.validateIfdBL(ifd, p);
                    continue;
                }
                if ((sft >> 3 & 1) != 1) continue;
                this.validateIfdFP(ifd, p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateIfdCT(IFD ifd, int p) {
        IfdTags metadata = ifd.getMetadata();
        boolean rgb = metadata.containsTagId(TiffTags.getTagId("PhotometricInterpretation")) && metadata.get(TiffTags.getTagId("PhotometricInterpretation")).getFirstNumericValue() == 2L;
        boolean lab = metadata.containsTagId(TiffTags.getTagId("PhotometricInterpretation")) && metadata.get(TiffTags.getTagId("PhotometricInterpretation")).getFirstNumericValue() == 8L;
        int spp = -1;
        if (metadata.containsTagId(TiffTags.getTagId("SamplesPerPixel"))) {
            spp = (int)metadata.get(TiffTags.getTagId("SamplesPerPixel")).getFirstNumericValue();
        }
        int planar = 1;
        if (metadata.containsTagId(TiffTags.getTagId("PlanarConfiguration"))) {
            planar = (int)metadata.get(TiffTags.getTagId("PlanarConfiguration")).getFirstNumericValue();
        }
        int rps = -1;
        if (metadata.containsTagId(TiffTags.getTagId("RowsPerStrip"))) {
            rps = (int)metadata.get(TiffTags.getTagId("RowsPerStrip")).getFirstNumericValue();
        }
        int length = -1;
        if (metadata.containsTagId(TiffTags.getTagId("ImageLength"))) {
            length = (int)metadata.get(TiffTags.getTagId("ImageLength")).getFirstNumericValue();
        }
        int spi = Math.floorDiv(length + rps - 1, rps);
        if (!(lab || p != 1 && p != 2)) {
            this.checkRequiredTag(metadata, "NewSubfileType", 1, new long[]{0L});
        }
        this.checkRequiredTag(metadata, "ImageLength", 1);
        this.checkRequiredTag(metadata, "ImageWidth", 1);
        this.checkRequiredTag(metadata, "BitsPerSample", spp);
        if (rgb || lab) {
            this.checkRequiredTag(metadata, "BitsPerSample", 3, new long[]{8L, 16L});
        } else if (p == 0) {
            this.checkRequiredTag(metadata, "BitsPerSample", spp, new long[]{8L, 16L});
        } else {
            this.checkRequiredTag(metadata, "BitsPerSample", spp, new long[]{8L});
        }
        if (p == 2 || rgb || lab) {
            this.checkRequiredTag(metadata, "Compression", 1, new long[]{1L, 7L, 8L});
        } else if (p == 1) {
            this.checkRequiredTag(metadata, "Compression", 1, new long[]{1L});
        }
        if (p == 0) {
            this.checkRequiredTag(metadata, "PhotometricInterpretation", 1, new long[]{2L, 5L, 6L, 8L});
            if (metadata.containsTagId(TiffTags.getTagId("PhotometricInterpretation")) && metadata.get(TiffTags.getTagId("PhotometricInterpretation")).getFirstNumericValue() == 6L && metadata.get(TiffTags.getTagId("Compression")).getFirstNumericValue() != 7L) {
                this.validation.addErrorLoc("YCbCr shall be used only when compression has the value 7", "IFD" + this.currentIfd);
            }
        } else if (p == 1 || p == 2) {
            this.checkRequiredTag(metadata, "PhotometricInterpretation", 1, new long[]{5L});
        }
        if (planar == 1 || planar == 32768) {
            this.checkRequiredTag(metadata, "StripOffsets", spi);
        } else if (planar == 2) {
            this.checkRequiredTag(metadata, "StripOffsets", spp * spi);
        }
        if (!(rgb || lab || p != 1 && p != 2)) {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L});
        }
        if (rgb || lab) {
            this.checkRequiredTag(metadata, "SamplesPerPixel", 1, new long[]{3L});
        } else if (p == 0) {
            this.checkRequiredTag(metadata, "SamplesPerPixel", 1);
        } else if (p == 1 || p == 2) {
            this.checkRequiredTag(metadata, "SamplesPerPixel", 1, new long[]{4L});
        }
        if (p == 1 || p == 2 || rgb || lab) {
            if (planar == 1 || planar == 32768) {
                this.checkRequiredTag(metadata, "StripBYTECount", spi);
            } else if (planar == 2) {
                this.checkRequiredTag(metadata, "StripBYTECount", spp * spi);
            }
            this.checkRequiredTag(metadata, "XResolution", 1);
            this.checkRequiredTag(metadata, "YResolution", 1);
        }
        if (p == 0 || rgb || lab) {
            this.checkRequiredTag(metadata, "PlanarConfiguration", 1, new long[]{1L, 2L, 32768L});
        } else if (p == 1 || p == 2) {
            this.checkRequiredTag(metadata, "PlanarConfiguration", 1, new long[]{1L});
        }
        if (!(rgb || lab || p != 1 && p != 2)) {
            this.checkRequiredTag(metadata, "ResolutionUnit", 1, new long[]{2L, 3L});
            this.checkRequiredTag(metadata, "InkSet", 1, new long[]{1L});
            this.checkRequiredTag(metadata, "NumberOfInks", 1, new long[]{4L});
            this.checkRequiredTag(metadata, "DotRange", 2, new long[]{0L, 255L});
        }
    }

    private void validateIfdLW(IFD ifd, int p) {
        IfdTags metadata = ifd.getMetadata();
        if (p == 1) {
            this.checkRequiredTag(metadata, "NewSubfileType", 1, new long[]{0L});
        }
        this.checkRequiredTag(metadata, "ImageLength", 1);
        this.checkRequiredTag(metadata, "ImageWidth", 1);
        this.checkRequiredTag(metadata, "SamplesPerPixel", 1, new long[]{1L});
        if (p == 0) {
            this.checkRequiredTag(metadata, "BitsPerSample", 1, new long[]{4L});
        } else {
            this.checkRequiredTag(metadata, "BitsPerSample", 1, new long[]{8L});
        }
        this.checkRequiredTag(metadata, "Compression", 1, new long[]{32896L});
        this.checkRequiredTag(metadata, "PhotometricInterpretation", 1, new long[]{5L});
        this.checkRequiredTag(metadata, "StripOffsets", 1);
        if (p == 1 || p == 2) {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L});
        }
        this.checkRequiredTag(metadata, "StripBYTECount", 1);
        this.checkRequiredTag(metadata, "XResolution", 1);
        this.checkRequiredTag(metadata, "YResolution", 1);
        if (p == 1 || p == 2) {
            this.checkRequiredTag(metadata, "ResolutionUnit", 1, new long[]{2L, 3L});
            this.checkRequiredTag(metadata, "InkSet", 1, new long[]{1L});
            this.checkRequiredTag(metadata, "NumberOfInks", 1, new long[]{4L});
        }
        if (p == 1) {
            this.checkRequiredTag(metadata, "DotRange", 2, new long[]{0L, 255L});
        }
        this.checkRequiredTag(metadata, "ColorTable", -1);
    }

    private void validateIfdHC(IFD ifd, int p) {
        IfdTags metadata = ifd.getMetadata();
        int spp = -1;
        if (metadata.containsTagId(TiffTags.getTagId("SampesPerPixel"))) {
            spp = (int)metadata.get(TiffTags.getTagId("SampesPerPixel")).getFirstNumericValue();
        }
        if (p == 1) {
            this.checkRequiredTag(metadata, "NewSubfileType", 1, new long[]{0L});
        }
        this.checkRequiredTag(metadata, "ImageLength", 1);
        this.checkRequiredTag(metadata, "ImageWidth", 1);
        this.checkRequiredTag(metadata, "BitsPerSample", spp);
        if (p == 1) {
            this.checkRequiredTag(metadata, "BitsPerSample", 4, new long[]{8L});
        }
        this.checkRequiredTag(metadata, "Compression", 1, new long[]{32897L});
        this.checkRequiredTag(metadata, "PhotometricInterpretation", 1, new long[]{5L});
        this.checkRequiredTag(metadata, "StripOffsets", 1);
        if (p == 1 || p == 2) {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L});
        }
        if (p == 1) {
            this.checkRequiredTag(metadata, "SamplesPerPixel", 1, new long[]{4L});
        }
        this.checkRequiredTag(metadata, "StripBYTECount", 1);
        this.checkRequiredTag(metadata, "XResolution", 1);
        this.checkRequiredTag(metadata, "YResolution", 1);
        this.checkRequiredTag(metadata, "PlanarConfiguration", 1, new long[]{1L});
        if (p == 1 || p == 2) {
            this.checkRequiredTag(metadata, "ResolutionUnit", 1, new long[]{2L, 3L});
            this.checkRequiredTag(metadata, "InkSet", 1, new long[]{1L});
            this.checkRequiredTag(metadata, "NumberOfInks", 1, new long[]{4L});
            this.checkRequiredTag(metadata, "DotRange", 2, new long[]{0L, 255L});
        }
        this.checkRequiredTag(metadata, "TransparencyIndicator", 1, new long[]{0L, 1L});
    }

    private void validateIfdMP(IFD ifd, int p) {
        IfdTags metadata = ifd.getMetadata();
        if (p == 1 || p == 2) {
            this.checkRequiredTag(metadata, "NewSubfileType", 1, new long[]{0L});
        }
        this.checkRequiredTag(metadata, "ImageLength", 1);
        this.checkRequiredTag(metadata, "ImageWidth", 1);
        if (p == 1) {
            this.checkRequiredTag(metadata, "BitsPerSample", 1, new long[]{8L, 16L});
        } else {
            this.checkRequiredTag(metadata, "BitsPerSample", 1, new long[]{8L});
        }
        if (p == 0) {
            this.checkRequiredTag(metadata, "Compression", 1, new long[]{1L, 7L, 8L, 32895L});
        } else if (p == 1) {
            this.checkRequiredTag(metadata, "Compression", 1, new long[]{1L});
        } else {
            this.checkRequiredTag(metadata, "Compression", 1, new long[]{1L, 7L, 8L});
        }
        if (p == 0) {
            this.checkRequiredTag(metadata, "PhotometricInterpretation", 1);
        } else {
            this.checkRequiredTag(metadata, "PhotometricInterpretation", 1, new long[]{0L});
        }
        this.checkRequiredTag(metadata, "StripOffsets", 1);
        if (p == 0) {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L, 4L, 5L, 8L});
        } else {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L});
        }
        if (p == 1) {
            this.checkRequiredTag(metadata, "SamplesPerPixel", 1, new long[]{1L});
        }
        this.checkRequiredTag(metadata, "StripBYTECount", 1);
        this.checkRequiredTag(metadata, "XResolution", 1);
        this.checkRequiredTag(metadata, "YResolution", 1);
        if (p == 1 || p == 2) {
            this.checkRequiredTag(metadata, "ResolutionUnit", 1, new long[]{2L, 3L});
            this.checkRequiredTag(metadata, "DotRange", 2, new long[]{0L, 255L});
            this.checkRequiredTag(metadata, "PixelIntensityRange", 2, new long[]{0L, 255L});
        }
        this.checkRequiredTag(metadata, "ImageColorIndicator", 1, new long[]{0L, 1L});
    }

    private void validateIfdBP(IFD ifd, int p) {
        IfdTags metadata = ifd.getMetadata();
        if (p == 1 || p == 2) {
            this.checkRequiredTag(metadata, "NewSubfileType", 1, new long[]{0L});
        }
        this.checkRequiredTag(metadata, "ImageLength", 1);
        this.checkRequiredTag(metadata, "ImageWidth", 1);
        this.checkRequiredTag(metadata, "BitsPerSample", 1, new long[]{1L});
        if (p == 0) {
            this.checkRequiredTag(metadata, "Compression", 1, new long[]{1L, 4L, 8L});
        } else if (p == 1) {
            this.checkRequiredTag(metadata, "Compression", 1, new long[]{1L});
        } else {
            this.checkRequiredTag(metadata, "Compression", 1, new long[]{1L, 4L, 8L});
        }
        if (p == 0) {
            this.checkRequiredTag(metadata, "PhotometricInterpretation", 1);
        } else {
            this.checkRequiredTag(metadata, "PhotometricInterpretation", 1, new long[]{0L});
        }
        this.checkRequiredTag(metadata, "StripOffsets", 1);
        if (p == 0) {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L, 4L, 5L, 8L});
        } else {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L});
        }
        this.checkRequiredTag(metadata, "SamplesPerPixel", 1, new long[]{1L});
        this.checkRequiredTag(metadata, "StripBYTECount", 1);
        this.checkRequiredTag(metadata, "XResolution", 1);
        this.checkRequiredTag(metadata, "YResolution", 1);
        if (p == 1 || p == 2) {
            this.checkRequiredTag(metadata, "ResolutionUnit", 1, new long[]{2L, 3L});
            this.checkRequiredTag(metadata, "DotRange", 2, new long[]{0L, 255L});
        }
        this.checkRequiredTag(metadata, "ImageColorIndicator", 1, new long[]{0L, 1L, 2L});
        this.checkRequiredTag(metadata, "BackgroundColorIndicator", 1, new long[]{0L, 1L, 2L});
    }

    private void validateIfdBL(IFD ifd, int p) {
        IfdTags metadata = ifd.getMetadata();
        if (p == 1) {
            this.checkRequiredTag(metadata, "NewSubfileType", 1, new long[]{0L});
        }
        this.checkRequiredTag(metadata, "ImageLength", 1);
        this.checkRequiredTag(metadata, "ImageWidth", 1);
        this.checkRequiredTag(metadata, "BitsPerSample", 1, new long[]{1L});
        this.checkRequiredTag(metadata, "Compression", 1, new long[]{32898L});
        if (p == 0) {
            this.checkRequiredTag(metadata, "PhotometricInterpretation", 1, new long[]{0L, 1L});
        } else {
            this.checkRequiredTag(metadata, "PhotometricInterpretation", 1, new long[]{0L});
        }
        this.checkRequiredTag(metadata, "StripOffsets", 1);
        if (p == 0) {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L, 4L, 5L, 8L});
        } else {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L});
        }
        this.checkRequiredTag(metadata, "SamplesPerPixel", 1, new long[]{1L});
        this.checkRequiredTag(metadata, "StripBYTECount", 1);
        this.checkRequiredTag(metadata, "XResolution", 1);
        this.checkRequiredTag(metadata, "YResolution", 1);
        if (p == 1) {
            this.checkRequiredTag(metadata, "ResolutionUnit", 1, new long[]{2L, 3L});
            this.checkRequiredTag(metadata, "DotRange", 2, new long[]{0L, 255L});
        }
        this.checkRequiredTag(metadata, "ImageColorIndicator", 1, new long[]{0L, 1L, 2L});
        this.checkRequiredTag(metadata, "BackgroundColorIndicator", 1, new long[]{0L, 1L, 2L});
    }

    private void validateIfdSD(IFD ifd, int p) {
        IfdTags metadata = ifd.getMetadata();
        if (p == 2) {
            this.checkRequiredTag(metadata, "NewSubfileType", 1, new long[]{0L});
        }
        this.checkRequiredTag(metadata, "ImageLength", 1);
        this.checkRequiredTag(metadata, "ImageWidth", 1);
        this.checkRequiredTag(metadata, "BitsPerSample", 1, new long[]{1L});
        this.checkRequiredTag(metadata, "Compression", 1, new long[]{1L, 4L, 8L});
        this.checkRequiredTag(metadata, "PhotometricInterpretation", 1, new long[]{5L});
        this.checkRequiredTag(metadata, "StripOffsets", 1);
        if (p == 0) {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L, 4L, 5L, 8L});
        } else {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L});
        }
        if (p == 2) {
            this.checkRequiredTag(metadata, "SamplesPerPixel", 1, new long[]{1L, 4L});
        }
        this.checkRequiredTag(metadata, "StripBYTECount", 1);
        this.checkRequiredTag(metadata, "XResolution", 1);
        this.checkRequiredTag(metadata, "YResolution", 1);
        this.checkRequiredTag(metadata, "PlanarConfiguration", 1, new long[]{2L});
        if (p == 2) {
            this.checkRequiredTag(metadata, "ResolutionUnit", 1, new long[]{2L, 3L});
            this.checkRequiredTag(metadata, "NumberOfInks", 1, new long[]{4L});
        }
        this.checkRequiredTag(metadata, "InkSet", 1, new long[]{1L});
        this.checkRequiredTag(metadata, "BackgroundColorIndicator", 1, new long[]{0L, 1L, 2L});
    }

    private void validateIfdFP(IFD ifd, int p) {
        IfdTags metadata = ifd.getMetadata();
        this.checkRequiredTag(metadata, "ImageDescription", 1);
        this.checkRequiredTag(metadata, "StripOffsets", 1);
        if (p == 1 || p == 2) {
            this.checkRequiredTag(metadata, "StripOffsets", 1, new long[]{0L});
        }
        this.checkRequiredTag(metadata, "NewSubfileType", 1);
        this.checkRequiredTag(metadata, "ImageLength", 1);
        this.checkRequiredTag(metadata, "ImageWidth", 1);
        this.checkRequiredTag(metadata, "StripOffsets", 1);
        if (p == 0) {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L, 4L, 5L, 8L});
        } else {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L});
        }
        this.checkRequiredTag(metadata, "StripBYTECount", 1);
        this.checkRequiredTag(metadata, "XResolution", 1);
        this.checkRequiredTag(metadata, "YResolution", 1);
        this.checkRequiredTag(metadata, "PlanarConfiguration", 1, new long[]{2L});
        if (p == 1 || p == 2) {
            this.checkRequiredTag(metadata, "ResolutionUnit", 1, new long[]{2L, 3L});
            this.checkRequiredTag(metadata, "NumberOfInks", 1, new long[]{4L});
        }
    }

    private boolean checkRequiredTag(IfdTags metadata, String tagName, int cardinality, long[] possibleValues) {
        boolean ok = true;
        int tagid = TiffTags.getTagId(tagName);
        if (!metadata.containsTagId(tagid)) {
            this.validation.addErrorLoc("Missing required tag for TiffIT" + this.profile + " " + tagName, "IFD" + this.currentIfd);
            ok = false;
        } else if (cardinality != -1 && metadata.get(tagid).getCardinality() != cardinality) {
            this.validation.addError("Invalid cardinality for TiffIT" + this.profile + " tag " + tagName, "IFD" + this.currentIfd, metadata.get(tagid).getCardinality());
        } else if (cardinality == 1 && possibleValues != null) {
            long val = metadata.get(tagid).getFirstNumericValue();
            boolean contained = false;
            for (int i = 0; i < possibleValues.length && !contained; ++i) {
                contained = possibleValues[i] == val;
            }
            if (!contained) {
                this.validation.addError("Invalid value for TiffIT" + this.profile + " tag " + tagName, "IFD" + this.currentIfd, val);
            }
        }
        return ok;
    }

    private boolean checkRequiredTag(IfdTags metadata, String tagName, int cardinality) {
        return this.checkRequiredTag(metadata, tagName, cardinality, null);
    }
}

