/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountryCode {
    private String twoLetterCode;
    private String threeLetterCode;
    private String threeDigitCode;
    private String name;
    private static Map<String, CountryCode> byAnyKey;
    private static List<CountryCode> countryCodes;

    private CountryCode(String twoLetterCode, String threeLetterCode, String threeDigitCode, String name) {
        this.twoLetterCode = twoLetterCode;
        this.threeLetterCode = threeLetterCode;
        this.threeDigitCode = threeDigitCode;
        this.name = name;
    }

    public static CountryCode get(String key) {
        return byAnyKey.get(key);
    }

    public static List<CountryCode> getCountryCodes() {
        return countryCodes;
    }

    public String get3DigitCode() {
        return this.threeDigitCode;
    }

    public String get3LetterCode() {
        return this.threeLetterCode;
    }

    public String get2LetterCode() {
        return this.twoLetterCode;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.get3LetterCode();
    }

    private static void loadCountryCodeHelper(String codeFile) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new InputStreamReader(CountryCode.class.getResourceAsStream(codeFile)));
        while ((line = r.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
            CountryCode cc = new CountryCode(line.substring(0, 2), line.substring(3, 6), line.substring(7, 10), line.substring(11));
            countryCodes.add(cc);
            byAnyKey.put(cc.get2LetterCode(), cc);
            byAnyKey.put(cc.get3LetterCode(), cc);
            byAnyKey.put(cc.get3DigitCode(), cc);
        }
        r.close();
    }

    public static void main(String[] args) {
        System.out.println(CountryCode.getCountryCodes());
    }

    static {
        try {
            byAnyKey = new HashMap<String, CountryCode>();
            countryCodes = new ArrayList<CountryCode>(300);
            CountryCode.loadCountryCodeHelper("iso3166.txt");
            CountryCode.loadCountryCodeHelper("iptc_naa.txt");
            countryCodes = Collections.unmodifiableList(countryCodes);
            byAnyKey = Collections.unmodifiableMap(byAnyKey);
        }
        catch (Exception e) {
            System.err.println("Failed to load country codes: " + e);
        }
    }
}

