/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j;

import com.nmote.iim4j.dataset.DataSetInfo;
import com.nmote.iim4j.dataset.DataSetInfoFactory;
import com.nmote.iim4j.dataset.DefaultDataSetInfo;
import com.nmote.iim4j.dataset.DefaultDataSetInfoFactory;
import com.nmote.iim4j.dataset.InvalidDataSetException;
import com.nmote.iim4j.dataset.UnsupportedDataSetException;
import com.nmote.iim4j.serialize.DefaultSerializerFactory;
import com.nmote.iim4j.serialize.SerializerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IIMDataSetInfoFactory
extends DefaultDataSetInfoFactory {
    public static final DataSetInfoFactory VERSION_4 = new IIMDataSetInfoFactory();
    private final Map<Integer, DataSetInfo> dataSets;

    public IIMDataSetInfoFactory() {
        this("4", new DefaultSerializerFactory());
    }

    public IIMDataSetInfoFactory(String version, SerializerFactory serializerFactory) {
        String file = "IIMv" + version + ".txt";
        try {
            InputStream in = IIMDataSetInfoFactory.class.getResourceAsStream(file);
            if (in == null) {
                throw new RuntimeException("IIM meta file: " + file + " not found in com.nmote.iim4j package");
            }
            this.dataSets = this.load(in, serializerFactory);
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException while reading IIM meta file: " + file, ioe);
        }
    }

    private Map<Integer, DataSetInfo> load(InputStream in, SerializerFactory serializerFactory) throws IOException {
        String line;
        HashMap<Integer, DataSetInfo> ds = new HashMap<Integer, DataSetInfo>();
        BufferedReader r = new BufferedReader(new InputStreamReader(in, "utf-8"));
        while ((line = r.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            String[] a = line.split(":");
            DefaultDataSetInfo info = new DefaultDataSetInfo(Integer.parseInt(a[0]) << 8 | Integer.parseInt(a[1]), a[2].trim(), serializerFactory.create(a[3]), true);
            ds.put(this.createKey(info.getDataSetNumber()), info);
        }
        r.close();
        return ds;
    }

    private Integer createKey(int dataSet) {
        return new Integer(dataSet);
    }

    @Override
    public DataSetInfo create(int dataSet) throws InvalidDataSetException {
        DataSetInfo info = this.dataSets.get(this.createKey(dataSet));
        if (info == null) {
            int recordNumber = dataSet >> 8 & 0xFF;
            int dataSetNumber = dataSet & 0xFF;
            throw new UnsupportedDataSetException(recordNumber + ":" + dataSetNumber);
        }
        return info;
    }

    public static void main(String[] args) throws Exception {
        IIMDataSetInfoFactory dsf = new IIMDataSetInfoFactory();
        for (Map.Entry<Integer, DataSetInfo> entry : dsf.dataSets.entrySet()) {
            DataSetInfo ds = entry.getValue();
            int dataSet = entry.getKey();
            int recordNumber = dataSet >> 8 & 0xFF;
            int dataSetNumber = dataSet & 0xFF;
            System.out.println("\t/** " + recordNumber + ":" + dataSetNumber + " " + ds.getName() + " */");
            System.out.println("\tpublic static final int " + ds.getName().toUpperCase().replace(' ', '_').replace('/', '_').replace('-', '_') + " = DS(" + recordNumber + ", " + dataSetNumber + ");");
            System.out.println();
        }
    }
}

