/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j;

import com.nmote.iim4j.CachedDataSet;
import com.nmote.iim4j.dataset.DataSet;
import com.nmote.iim4j.dataset.DataSetInfo;
import com.nmote.iim4j.stream.IIMOutputStream;
import java.io.IOException;

public class IIMWriter {
    private IIMOutputStream output;

    public IIMWriter(IIMOutputStream out) {
        this.output = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataSet ds) throws IOException {
        if (this.output == null) {
            throw new IOException("output was closed");
        }
        IIMOutputStream iIMOutputStream = this.output;
        synchronized (iIMOutputStream) {
            this.output.write(28);
            DataSetInfo info = ds.getInfo();
            int dsn = info.getDataSetNumber();
            this.output.write(dsn >> 8 & 0xFF);
            this.output.write(dsn & 0xFF);
            int len = ds.getLength();
            if (len <= Short.MAX_VALUE) {
                this.output.write(len >> 8 & 0xFF);
                this.output.write(len & 0xFF);
            } else {
                int i;
                int count = 1;
                for (i = len >> 8; i > 0; i >>= 8) {
                    ++count;
                }
                this.output.write(128);
                this.output.write(count);
                for (i = count - 1; i >= 0; --i) {
                    this.output.write(len >> 8 * i & 0xFF);
                }
            }
            if (ds instanceof CachedDataSet) {
                ((CachedDataSet)ds).writeDataTo(this.output);
            } else {
                this.output.write(ds.getData());
            }
        }
    }

    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }
}

