/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j.serialize;

import com.nmote.iim4j.serialize.SerializationContext;
import com.nmote.iim4j.serialize.SerializationException;
import com.nmote.iim4j.serialize.Serializer;

public class VarBinaryNumberSerializer
implements Serializer {
    public VarBinaryNumberSerializer(String def) {
    }

    public Object deserialize(byte[] data, SerializationContext ctx) throws SerializationException {
        if (data.length > 8) {
            throw new SerializationException("data too long: " + data.length);
        }
        long r = 0L;
        for (int i = 0; i < data.length; ++i) {
            r = r << 8 | (long)(data[i] & 0xFF);
        }
        return new Long(r);
    }

    public byte[] serialize(Object o, SerializationContext ctx) throws SerializationException {
        long n = ((Number)o).longValue();
        if (n < 0L) {
            throw new SerializationException("negative number: " + n);
        }
        int length = 0;
        long n1 = n;
        while (n1 > 0L) {
            n1 >>= 8;
            ++length;
        }
        byte[] result = new byte[length];
        for (int i = result.length - 1; n > 0L && i >= 0; n >>= 8, --i) {
            result[i] = (byte)(n & 0xFFL);
        }
        if (n > 0L) {
            throw new SerializationException("number too large to fit in " + length + ": " + o);
        }
        return result;
    }
}

