/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j.stream;

import com.nmote.iim4j.stream.IIMInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileIIMInputStream
implements IIMInputStream {
    private final RandomAccessFile file;

    public FileIIMInputStream(RandomAccessFile file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        this.file = file;
    }

    public FileIIMInputStream(File file) throws IOException {
        this(new RandomAccessFile(file, "r"));
    }

    public boolean isCached() {
        return true;
    }

    public void seek(long position) throws IOException {
        this.file.seek(position);
    }

    public int read() throws IOException {
        return this.file.read();
    }

    public int read(byte[] buffer) throws IOException {
        return this.file.read(buffer);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.file.read(buffer, offset, length);
    }

    public void close() throws IOException {
        this.file.close();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public long position() throws IOException {
        return this.file.getFilePointer();
    }
}

