/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j.stream;

import com.nmote.iim4j.stream.IIMInputStream;
import com.nmote.iim4j.stream.IIMNotFoundException;
import com.nmote.iim4j.stream.JPEGUtil;
import com.nmote.iim4j.stream.SubIIMInputStream;
import java.io.EOFException;
import java.io.IOException;

public class JPEGIIMInputStream
extends SubIIMInputStream {
    public JPEGIIMInputStream(IIMInputStream input) throws IOException {
        super(input);
        int segmentSize;
        if (JPEGUtil.readInt8(input) != 255 || JPEGUtil.readInt8(input) != 216) {
            throw new IOException("not a JPEG file (invalid magic number)");
        }
        while (true) {
            if (JPEGUtil.readInt8(input) != 255) {
                throw new IOException("expected JPEG segment start identifier");
            }
            int segmentMarker = JPEGUtil.readInt8(input);
            if (segmentMarker == 218) {
                throw new IIMNotFoundException();
            }
            segmentSize = JPEGUtil.readInt16(input);
            segmentSize -= 2;
            if (segmentMarker == 237) {
                if (input.isCached()) {
                    JPEGIIMInputStream.findStartTag(input);
                }
                break;
            }
            input.seek(input.position() + (long)segmentSize);
        }
        this.setOffsetAndLength(input.position(), segmentSize);
    }

    private static void findStartTag(IIMInputStream input) throws IOException {
        int tag = input.read();
        while (tag != 28) {
            if (tag == -1) {
                throw new EOFException("Can't find 0x1C marker in APPD segment");
            }
            tag = input.read();
        }
        long pos = input.position() - 1L;
        input.seek(pos);
    }
}

