/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j.stream;

import com.nmote.iim4j.IIMFile;
import com.nmote.iim4j.IIMWriter;
import com.nmote.iim4j.dataset.DataSet;
import com.nmote.iim4j.stream.DefaultIIMOutputStream;
import com.nmote.iim4j.stream.IIMInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;

public class JPEGUtil {
    static final int APPD = 237;
    static final int START = 255;
    static final int SOS = 218;
    private static final String PHOTOSHOP30_HEADER = "Photoshop 3.0\u00008BIM\u0004\u0004\u0000\u0000\u0000\u0000";

    public static void insertIIMIntoJPEG(OutputStream out, IIMFile file, InputStream jpegIn) throws IOException {
        IIMFile clone = file.clone();
        Iterator<DataSet> i = clone.getDataSets().iterator();
        while (i.hasNext()) {
            DataSet ds = i.next();
            if (ds.getInfo().getDataSetNumber() >> 8 == 2) continue;
            i.remove();
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        IIMWriter writer = new IIMWriter(new DefaultIIMOutputStream(buffer));
        clone.writeTo(writer);
        writer.close();
        JPEGUtil.insertIIMIntoJPEG(out, buffer.toByteArray(), jpegIn);
    }

    public static void insertIIMIntoJPEG(OutputStream out, byte[] iim, InputStream jpegIn) throws IOException {
        if (JPEGUtil.readInt8(jpegIn) != 255 || JPEGUtil.readInt8(jpegIn) != 216) {
            throw new IOException("not a JPEG file (invalid magic number)");
        }
        out.write(255);
        out.write(216);
        while (true) {
            if (JPEGUtil.readInt8(jpegIn) != 255) {
                throw new IOException("expected JPEG segment start identifier");
            }
            int segmentMarker = JPEGUtil.readInt8(jpegIn);
            if (segmentMarker == 218) break;
            int segmentSize = JPEGUtil.readInt16(jpegIn);
            if (segmentMarker == 237) {
                jpegIn.skip(segmentSize - 2);
                continue;
            }
            out.write(255);
            out.write(segmentMarker);
            JPEGUtil.writeInt16(out, segmentSize);
            JPEGUtil.copyStream(jpegIn, out, segmentSize - 2);
        }
        byte[] ps30Header = PHOTOSHOP30_HEADER.getBytes("iso-8859-1");
        int fillCount = iim.length % 4;
        if (fillCount > 0) {
            fillCount = 4 - fillCount;
        }
        out.write(255);
        out.write(237);
        JPEGUtil.writeInt16(out, ps30Header.length + 2 + iim.length + 2 + fillCount);
        out.write(ps30Header);
        JPEGUtil.writeInt16(out, iim.length);
        out.write(iim);
        if (fillCount > 0) {
            for (int i = 0; i < fillCount; ++i) {
                out.write(0);
            }
        }
        out.write(255);
        out.write(218);
        JPEGUtil.copyStream(jpegIn, out);
        out.close();
        jpegIn.close();
    }

    static int readInt16(IIMInputStream in) throws IOException {
        int hi = JPEGUtil.readInt8(in);
        int lo = JPEGUtil.readInt8(in);
        return hi << 8 | lo;
    }

    static int readInt8(IIMInputStream in) throws IOException {
        int r = in.read();
        if (r < 0) {
            throw new EOFException();
        }
        return r;
    }

    static int readInt16(InputStream in) throws IOException {
        int hi = JPEGUtil.readInt8(in);
        int lo = JPEGUtil.readInt8(in);
        return hi << 8 | lo;
    }

    static int readInt8(InputStream in) throws IOException {
        int r = in.read();
        if (r < 0) {
            throw new EOFException();
        }
        return r;
    }

    static void writeInt16(OutputStream out, int i) throws IOException {
        JPEGUtil.writeInt8(out, i >> 8 & 0xFF);
        JPEGUtil.writeInt8(out, i & 0xFF);
    }

    static void writeInt8(OutputStream out, int i) throws IOException {
        out.write(i);
    }

    static void copyStream(InputStream in, OutputStream out, int len) throws IOException {
        int r;
        byte[] buffer = new byte[4096];
        for (int i = 0; i < len; i += r) {
            int toRead = Math.min(buffer.length, len - i);
            r = in.read(buffer, 0, toRead);
            if (r < 0) {
                throw new EOFException();
            }
            out.write(buffer, 0, r);
        }
    }

    static void copyStream(InputStream in, OutputStream out) throws IOException {
        int r;
        byte[] buffer = new byte[4096];
        while ((r = in.read(buffer)) >= 0) {
            out.write(buffer, 0, r);
        }
    }
}

