/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j.stream;

import com.nmote.iim4j.stream.IIMInputStream;
import java.io.EOFException;
import java.io.IOException;

public class SubIIMInputStream
implements IIMInputStream {
    private final IIMInputStream subStream;
    private long position;
    private long offset;
    private int length;

    public SubIIMInputStream(IIMInputStream subStream, long offset, int length) throws IOException {
        this(subStream);
        this.setOffsetAndLength(offset, length);
    }

    protected SubIIMInputStream(IIMInputStream subStream) throws IOException {
        if (!subStream.isCached()) {
            throw new IOException("SubIIMInputStream can only be constructed from cached IIMINputStreams");
        }
        this.subStream = subStream;
    }

    protected void setOffsetAndLength(long offset, int length) throws IOException {
        this.offset = offset;
        this.length = length;
        this.position = 0L;
        if (this.subStream.position() != offset) {
            this.subStream.seek(offset);
        }
    }

    public boolean isCached() {
        return true;
    }

    public void seek(long position) throws IOException {
        if (position > (long)this.length) {
            throw new EOFException("seek past end of file (pos=" + position + ", length=" + this.length);
        }
        this.position = position;
    }

    public long position() throws IOException {
        return this.position;
    }

    public int read() throws IOException {
        int r;
        this.subStream.seek(this.position + this.offset);
        if (this.position >= (long)this.length) {
            r = -1;
        } else {
            ++this.position;
            r = this.subStream.read();
        }
        return r;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int boffset, int blength) throws IOException {
        int r;
        this.subStream.seek(this.position + this.offset);
        if (this.position + (long)blength > (long)this.length) {
            blength = (int)((long)this.length - this.position);
        }
        if ((r = this.subStream.read(buffer, boffset, blength)) > 0) {
            this.position += (long)r;
        }
        return r;
    }

    public void close() throws IOException {
        this.subStream.close();
    }
}

