/**
 * <h1>ImplementationCheckerObjectType.java</h1> <p> This program is free software: you can
 * redistribute it and/or modify it under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version; or, at your choice, under the terms of the Mozilla Public License, v. 2.0. SPDX GPL-3.0+
 * or MPL-2.0+. </p> <p> This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License and the Mozilla Public License for more details. </p>
 * <p> You should have received a copy of the GNU General Public License and the Mozilla Public
 * License along with this program. If not, see <a href="http://www.gnu.org/licenses/">http://www.gnu.org/licenses/</a>
 * and at <a href="http://mozilla.org/MPL/2.0">http://mozilla.org/MPL/2.0</a> . </p> <p> NB: for the
 * © statement, include Easy Innova SL or other company/Person contributing the code. </p> <p> ©
 * 2015 Easy Innova, SL </p>
 *
 * @author Víctor Muñoz Sola
 * @version 1.0
 * @since 23/7/2015
 */
package com.easyinnova.implementation_checker.rules.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * <p>Java class for implementationCheckerObjectType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="implementationCheckerObjectType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="title" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="iso" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="description" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="version" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="author" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="date" type="{http://www.w3.org/2001/XMLSchema}date"/>
 *         &lt;element name="include" type="{http://www.dpfmanager.org/ProfileChecker}includeType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;sequence>
 *           &lt;element name="rules" type="{http://www.dpfmanager.org/ProfileChecker}rulesType" maxOccurs="unbounded"/>
 *         &lt;/sequence>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlRootElement(name = "implementationCheckerObject")
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "implementationCheckerObjectType", propOrder = {
    "title",
    "iso",
    "description",
    "version",
    "author",
    "date",
    "include",
    "rules"
})
public class ImplementationCheckerObjectType {

  @XmlElement(required = true)
  protected String title;
  @XmlElement(required = true)
  protected String iso;
  @XmlElement(required = true)
  protected String description;
  @XmlElement(required = true)
  protected String version;
  @XmlElement(required = true)
  protected String author;
  @XmlElement(required = true)
  @XmlSchemaType(name = "date")
  protected XMLGregorianCalendar date;
  protected List<IncludeType> include;
  @XmlElement(required = true)
  protected List<RulesType> rules;

  /**
   * Gets the value of the title property.
   *
   * @return
   *     possible object is
   *     {@link String }
   *
   */
  public String getTitle() {
    return title;
  }

  /**
   * Sets the value of the title property.
   *
   * @param value
   *     allowed object is
   *     {@link String }
   *
   */
  public void setTitle(String value) {
    this.title = value;
  }

  /**
   * Gets the value of the iso property.
   *
   * @return
   *     possible object is
   *     {@link String }
   *
   */
  public String getIso() {
    return iso;
  }

  /**
   * Sets the value of the iso property.
   *
   * @param value
   *     allowed object is
   *     {@link String }
   *
   */
  public void setIso(String value) {
    this.iso = value;
  }

  /**
   * Gets the value of the description property.
   *
   * @return
   *     possible object is
   *     {@link String }
   *
   */
  public String getDescription() {
    return description;
  }

  /**
   * Sets the value of the description property.
   *
   * @param value
   *     allowed object is
   *     {@link String }
   *
   */
  public void setDescription(String value) {
    this.description = value;
  }

  /**
   * Gets the value of the version property.
   *
   * @return
   *     possible object is
   *     {@link String }
   *
   */
  public String getVersion() {
    return version;
  }

  /**
   * Sets the value of the version property.
   *
   * @param value
   *     allowed object is
   *     {@link String }
   *
   */
  public void setVersion(String value) {
    this.version = value;
  }

  /**
   * Gets the value of the author property.
   *
   * @return
   *     possible object is
   *     {@link String }
   *
   */
  public String getAuthor() {
    return author;
  }

  /**
   * Sets the value of the author property.
   *
   * @param value
   *     allowed object is
   *     {@link String }
   *
   */
  public void setAuthor(String value) {
    this.author = value;
  }

  /**
   * Gets the value of the date property.
   *
   * @return
   *     possible object is
   *     {@link XMLGregorianCalendar }
   *
   */
  public XMLGregorianCalendar getDate() {
    return date;
  }

  /**
   * Sets the value of the date property.
   *
   * @param value
   *     allowed object is
   *     {@link XMLGregorianCalendar }
   *
   */
  public void setDate(XMLGregorianCalendar value) {
    this.date = value;
  }

  /**
   * Gets the value of the include property.
   *
   * <p>
   * This accessor method returns a reference to the live list,
   * not a snapshot. Therefore any modification you make to the
   * returned list will be present inside the JAXB object.
   * This is why there is not a <CODE>set</CODE> method for the include property.
   *
   * <p>
   * For example, to add a new item, do as follows:
   * <pre>
   *    getInclude().add(newItem);
   * </pre>
   *
   *
   * <p>
   * Objects of the following type(s) are allowed in the list
   * {@link IncludeType }
   *
   *
   */
  public List<IncludeType> getInclude() {
    if (include == null) {
      include = new ArrayList<IncludeType>();
    }
    return this.include;
  }

  /**
   * Gets the value of the rules property.
   *
   * <p>
   * This accessor method returns a reference to the live list,
   * not a snapshot. Therefore any modification you make to the
   * returned list will be present inside the JAXB object.
   * This is why there is not a <CODE>set</CODE> method for the rules property.
   *
   * <p>
   * For example, to add a new item, do as follows:
   * <pre>
   *    getRules().add(newItem);
   * </pre>
   *
   *
   * <p>
   * Objects of the following type(s) are allowed in the list
   * {@link RulesType }
   *
   *
   */
  public List<RulesType> getRules() {
    if (rules == null) {
      rules = new ArrayList<RulesType>();
    }
    return this.rules;
  }

  public List<RulesType> getOwnRules() {
    List<RulesType> ownRules = new ArrayList<>();
    if (rules != null) {
      for (RulesType rule : rules){
        if (!rule.isIncluded()){
          ownRules.add(rule);
        }
      }
    }
    return ownRules;
  }

  public void removeRule(String id) {
    RulesType delete = null;
    for (RulesType rulesType : rules) {
      if (rulesType.getId().equals(id)) {
        delete = rulesType;
      }
    }
    if (delete != null) {
      rules.remove(delete);
    }
  }

  public RulesType getRulesById(String id) {
    for (RulesType rulesType : rules) {
      if (rulesType.getId().equals(id)) {
        return rulesType;
      }
    }
    return null;
  }

  public void makeCopy(ImplementationCheckerObjectType copy){
    title = copy.getTitle();
    iso = copy.getIso();
    author = copy.getAuthor();
    description = copy.getDescription();
    version = copy.getVersion();
    date = copy.getDate();
    include = new ArrayList<>();
    include.addAll(copy.getInclude());
    rules = new ArrayList<>();
    rules.addAll(copy.getRules());
  }

  public void removeIncludedRules(){
    rules = getOwnRules();
  }

}
