/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.implementation_checker;

import com.easyinnova.implementation_checker.ImplementationCheckerLoader;
import com.easyinnova.implementation_checker.ValidationResult;
import com.easyinnova.implementation_checker.model.TiffNode;
import com.easyinnova.implementation_checker.model.TiffValidationObject;
import com.easyinnova.implementation_checker.rules.Clausule;
import com.easyinnova.implementation_checker.rules.Clausules;
import com.easyinnova.implementation_checker.rules.RuleElement;
import com.easyinnova.implementation_checker.rules.RuleResult;
import com.easyinnova.implementation_checker.rules.model.AssertType;
import com.easyinnova.implementation_checker.rules.model.ImplementationCheckerObjectType;
import com.easyinnova.implementation_checker.rules.model.RuleType;
import com.easyinnova.implementation_checker.rules.model.RulesType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Validator {
    private TiffValidationObject model;
    private ValidationResult result;
    static HashMap<String, ImplementationCheckerObjectType> preLoadedValidatorsSingleton = new HashMap();

    public List<RuleResult> getErrors() {
        return this.result.getErrors();
    }

    public List<RuleResult> getWarningsAndInfos() {
        return this.result.getWarnings(true);
    }

    public List<RuleResult> getWarnings() {
        return this.result.getWarnings(false);
    }

    public ValidationResult validate(String content, String rulesFile, boolean fastBreak) throws JAXBException, ParserConfigurationException, IOException, SAXException {
        try {
            TiffValidationObject obj = Validator.createValidationObjectFromXml(content);
            ImplementationCheckerObjectType rules = ImplementationCheckerLoader.getRules(rulesFile);
            this.validate(obj, rules, fastBreak);
        }
        catch (Exception ex) {
            RuleResult rr = new RuleResult("Fatal error in TIFF file");
            this.result = new ValidationResult();
            this.result.add(rr);
        }
        return this.result;
    }

    public static TiffValidationObject createValidationObjectFromXml(String content) throws JAXBException, ParserConfigurationException, IOException, SAXException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TiffValidationObject.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        StringReader reader = new StringReader(content);
        TiffValidationObject obj = (TiffValidationObject)jaxbUnmarshaller.unmarshal((Reader)reader);
        return obj;
    }

    public void validate(TiffValidationObject model, ImplementationCheckerObjectType rules, boolean fastBreak) throws JAXBException, ParserConfigurationException, IOException, SAXException {
        this.result = new ValidationResult();
        this.model = model;
        boolean bbreak = false;
        ArrayList<RuleType> ordRules = new ArrayList<RuleType>();
        for (RulesType ruleSet : rules.getRules()) {
            for (RuleType rule : ruleSet.getRule()) {
                if (rule.getExperimental() || !rule.isCritical()) continue;
                ordRules.add(rule);
            }
        }
        for (RulesType ruleSet : rules.getRules()) {
            for (RuleType rule : ruleSet.getRule()) {
                if (rule.getExperimental() || rule.isCritical() || (!fastBreak || !rule.isError()) && fastBreak) continue;
                ordRules.add(rule);
            }
        }
        for (RuleType rule : ordRules) {
            String context = rule.getContext();
            List<TiffNode> objects = model.getObjectsFromContext(context, true);
            for (TiffNode node : objects) {
                boolean ok = this.checkRule(rule, node);
                if (!ok && (rule.isWarning() || rule.isInfo())) {
                    ok = true;
                }
                if (!ok) {
                    // empty if block
                }
                if (ok || !rule.isCritical() && !fastBreak) continue;
                bbreak = true;
                break;
            }
            if (!bbreak) continue;
            break;
        }
    }

    boolean checkRule(RuleType rule, TiffNode node) {
        RuleResult rr;
        boolean ok = true;
        try {
            AssertType test = rule.getAssert();
            String expression = test.getTest();
            Clausules clausules = new Clausules();
            clausules.parse(expression);
            for (int ic = 0; ic < clausules.getClausules().size(); ++ic) {
                RuleElement elem;
                Clausule clausule = clausules.getClausules().get(ic);
                if (clausule.value.startsWith("count(")) {
                    String countField = clausule.value.substring(clausule.value.indexOf("(") + 1);
                    countField = countField.substring(0, countField.indexOf(")"));
                    String checkop = clausule.value.substring(clausule.value.indexOf(")") + 1).trim();
                    RuleElement field = new RuleElement(countField, node, this.model);
                    if (field.valid) {
                        String field2;
                        List<TiffNode> childs = field.getChildren();
                        int n = childs.size();
                        if (checkop.startsWith("==")) {
                            field2 = checkop.substring("==".length()).trim();
                            ok = n == Integer.parseInt(field2);
                        } else if (checkop.startsWith("!=")) {
                            field2 = checkop.substring("!=".length()).trim();
                            ok = n != Integer.parseInt(field2);
                        } else if (checkop.startsWith(">")) {
                            field2 = checkop.substring(">".length()).trim();
                            ok = n > Integer.parseInt(field2);
                        } else if (checkop.startsWith("<")) {
                            field2 = checkop.substring("<".length()).trim();
                            ok = n < Integer.parseInt(field2);
                        }
                    }
                } else if (clausule.value.startsWith("date(")) {
                    String dateTimeField = clausule.value.substring(clausule.value.indexOf("(") + 1);
                    dateTimeField = dateTimeField.substring(0, dateTimeField.indexOf(")"));
                    RuleElement field = new RuleElement(dateTimeField, node, this.model);
                    if (field.valid) {
                        List<TiffNode> childs = field.getChildren();
                        for (TiffNode nod : childs) {
                            ok = false;
                            String value = nod.getValue();
                            if (value.length() != 19 || value.split(" ").length != 2 || value.split(":").length != 5) continue;
                            String sdate = value.split(" ")[0];
                            String stime = value.split(" ")[1];
                            try {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy:MM:dd");
                                sdf.setLenient(false);
                                Date date = sdf.parse(sdate);
                                sdf = new SimpleDateFormat("HH:mm:ss");
                                sdf.setLenient(false);
                                Date time = sdf.parse(stime);
                                ok = true;
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else if (clausule.value.contains("==") || clausule.value.contains(">") || clausule.value.contains("<") || clausule.value.contains("!=")) {
                    String operation = clausule.value.contains("==") ? "==" : (clausule.value.contains(">") ? ">" : (clausule.value.contains("!=") ? "!=" : "<"));
                    RuleElement op1 = new RuleElement(clausule.value.substring(0, clausule.value.indexOf(operation)), node, this.model);
                    if (op1.valid) {
                        String value = op1.getValue();
                        if (value == null) {
                            if (!rule.isError() && !rule.isCritical()) {
                                ok = false;
                            }
                            break;
                        }
                        RuleElement op2 = new RuleElement(clausule.value.substring(clausule.value.indexOf(operation) + operation.length()).trim(), node, this.model);
                        if (!op2.valid) {
                            ok = false;
                        } else {
                            String value2 = op2.getValue();
                            if (value2 == null) {
                                op2.getValue();
                            }
                            if (value2 == null) {
                                value2 = "";
                            }
                            if (value.contains("/")) {
                                value = Double.parseDouble(value.split("/")[0]) / Double.parseDouble(value.split("/")[1]) + "";
                            }
                            if (value2.contains("/")) {
                                value2 = Double.parseDouble(value2.split("/")[0]) / Double.parseDouble(value2.split("/")[1]) + "";
                            }
                            if (operation.equals("==")) {
                                try {
                                    ok = Double.parseDouble(value) == Double.parseDouble(value2);
                                }
                                catch (Exception ex) {
                                    ok = value.toLowerCase().equals(value2.toLowerCase());
                                }
                            } else if (operation.equals("!=")) {
                                try {
                                    ok = Double.parseDouble(value) != Double.parseDouble(value2);
                                }
                                catch (Exception ex) {
                                    ok = !value.toLowerCase().equals(value2.toLowerCase());
                                }
                            } else if (operation.equals(">")) {
                                try {
                                    ok = Double.parseDouble(value) > Double.parseDouble(value2);
                                }
                                catch (Exception ex) {
                                    ok = false;
                                }
                            } else {
                                try {
                                    ok = Double.parseDouble(value) < Double.parseDouble(value2);
                                }
                                catch (Exception ex) {
                                    ok = false;
                                }
                                if (!ok) {
                                    ok = false;
                                }
                            }
                        }
                    }
                } else if (clausule.value.startsWith("!")) {
                    elem = new RuleElement(clausule.value.substring(1), node, this.model);
                    ok = !elem.valid ? true : elem.getChildren().size() == 0;
                } else {
                    List<TiffNode> childs;
                    elem = new RuleElement(clausule.value, node, this.model);
                    ok = !elem.valid ? false : ((childs = elem.getChildren()) == null ? false : childs.size() > 0);
                }
                Clausules.Operator nextClausuleOperator = null;
                if (ic + 1 < clausules.getClausules().size()) {
                    nextClausuleOperator = clausules.getClausules().get((int)(ic + 1)).operator;
                }
                if (nextClausuleOperator == null || (nextClausuleOperator != Clausules.Operator.OR || !ok) && (nextClausuleOperator != Clausules.Operator.AND || ok)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ok = false;
        }
        if (ok && rule.isWarning()) {
            rr = new RuleResult(false, node, rule);
            rr.setWarning(true);
            this.result.add(rr);
        } else if (ok && rule.isInfo()) {
            rr = new RuleResult(false, node, rule);
            rr.setInfo(true);
            this.result.add(rr);
        } else if (ok) {
            rr = new RuleResult(true, node, rule);
            this.result.add(rr);
        } else if (!rule.isWarning() && !rule.isInfo()) {
            rr = new RuleResult(false, node, rule);
            this.result.add(rr);
        } else if (rule.getId().startsWith("pol-") && rule.isWarning()) {
            rr = new RuleResult(true, node, rule);
            rr.setWarning(true);
            this.result.add(rr);
        }
        return ok;
    }

    public ValidationResult getResult() {
        return this.result;
    }
}

