/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.implementation_checker.model;

import com.easyinnova.implementation_checker.model.TiffNodeInterface;
import com.easyinnova.implementation_checker.rules.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TiffNode
implements TiffNodeInterface,
Serializable {
    private String location;
    private String parent;

    @Override
    public List<TiffNode> getChildren(boolean subchilds) {
        return new ArrayList<TiffNode>();
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    @Override
    public String getContext() {
        return null;
    }

    @Override
    public String getValue() {
        return null;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public TiffNode getChild(String nodeName) {
        return this.getChild(nodeName, null);
    }

    public boolean hasChild(String nodeName) {
        return this.hasChild(nodeName, null);
    }

    public List<TiffNode> getChildren(String nodeName) {
        return this.getChildren(nodeName, null);
    }

    public TiffNode getChild(String nodeName, Filter filter) {
        for (TiffNode node : this.getChildren(nodeName, filter)) {
            if (!node.getContext().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    public List<TiffNode> getChildren(String nodeName, Filter filter) {
        ArrayList<TiffNode> nodes = new ArrayList<TiffNode>();
        for (TiffNode node : this.getChildren(false)) {
            if (!node.getContext().equals(nodeName)) continue;
            if (filter == null) {
                nodes.add(node);
                continue;
            }
            if (!node.hasChild(filter.getAttribute()) || !node.getChild(filter.getAttribute()).getValue().equals(filter.getValue())) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public boolean hasChild(String nodeName, Filter filter) {
        for (TiffNode node : this.getChildren(nodeName, filter)) {
            if (!node.getContext().equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String s = "";
        if (this.getLocation() != null) {
            return this.getLocation();
        }
        s = s + this.getContext();
        return s;
    }

    public boolean contextMatch(String context) {
        if (context.equals("*")) {
            return true;
        }
        String nodeContext = this.getContext();
        if (this.parent != null && context.contains(".")) {
            nodeContext = this.parent + "." + nodeContext;
        }
        if (!context.contains("[")) {
            return nodeContext.equals(context);
        }
        String contextBase = context.substring(0, context.indexOf("["));
        if (nodeContext.equals(contextBase)) {
            String[] filters;
            String sFilter = context.substring(context.indexOf("[") + 1);
            sFilter = sFilter.substring(0, sFilter.indexOf("]"));
            boolean matches = true;
            for (String filter : filters = sFilter.split(",")) {
                String childValue = filter.substring(filter.indexOf("=") + 1).trim();
                String childName = filter.substring(0, filter.indexOf("=")).trim();
                if (this.hasChild(childName) && this.getChild(childName).getValue() != null && this.getChild(childName).getValue().equals(childValue)) continue;
                matches = false;
            }
            return matches;
        }
        return false;
    }
}

