/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFACryptFilterMap;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ACryptFilterMap;
import org.verapdf.model.alayer.AEncryptionStandard;
import org.verapdf.model.baselayer.Object;

public class GFAEncryptionStandard
extends GFAObject
implements AEncryptionStandard {
    public GFAEncryptionStandard(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AEncryptionStandard");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CF": {
                return this.getCF();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ACryptFilterMap> getCF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCF1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ACryptFilterMap> getCF1_5() {
        COSObject object = this.getCFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACryptFilterMap> list = new ArrayList<GFACryptFilterMap>(1);
            list.add(new GFACryptFilterMap((COSDictionary)object.getDirectBase(), this.baseObject, "CF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsCF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CF"));
    }

    public COSObject getCFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CF"));
        return object;
    }

    @Override
    public String getCFType() {
        COSObject CF = this.getCFValue();
        return this.getObjectType(CF);
    }

    @Override
    public Boolean getCFHasTypeDictionary() {
        COSObject CF = this.getCFValue();
        return GFAEncryptionStandard.getHasTypeDictionary(CF);
    }

    @Override
    public Boolean getcontainsEFF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("EFF"));
    }

    public COSObject getEFFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("EFF"));
        return object;
    }

    @Override
    public String getEFFType() {
        COSObject EFF = this.getEFFValue();
        return this.getObjectType(EFF);
    }

    @Override
    public Boolean getEFFHasTypeName() {
        COSObject EFF = this.getEFFValue();
        return GFAEncryptionStandard.getHasTypeName(EFF);
    }

    @Override
    public Boolean getcontainsEncryptMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom("EncryptMetadata"));
    }

    public COSObject getEncryptMetadataDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct(true);
            }
        }
        return null;
    }

    public COSObject getEncryptMetadataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("EncryptMetadata"));
        if (object == null || object.empty()) {
            object = this.getEncryptMetadataDefaultValue();
        }
        return object;
    }

    @Override
    public String getEncryptMetadataType() {
        COSObject EncryptMetadata = this.getEncryptMetadataValue();
        return this.getObjectType(EncryptMetadata);
    }

    @Override
    public Boolean getEncryptMetadataHasTypeBoolean() {
        COSObject EncryptMetadata = this.getEncryptMetadataValue();
        return GFAEncryptionStandard.getHasTypeBoolean(EncryptMetadata);
    }

    @Override
    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Filter"));
    }

    public COSObject getFilterDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return COSName.construct("Standard");
            }
        }
        return null;
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        if (object == null || object.empty()) {
            object = this.getFilterDefaultValue();
        }
        return object;
    }

    @Override
    public String getFilterType() {
        COSObject Filter2 = this.getFilterValue();
        return this.getObjectType(Filter2);
    }

    @Override
    public Boolean getFilterHasTypeName() {
        COSObject Filter2 = this.getFilterValue();
        return GFAEncryptionStandard.getHasTypeName(Filter2);
    }

    @Override
    public String getFilterNameValue() {
        COSObject Filter2 = this.getFilterValue();
        return GFAEncryptionStandard.getNameValue(Filter2);
    }

    @Override
    public Boolean getcontainsKDFSalt() {
        return this.baseObject.knownKey(ASAtom.getASAtom("KDFSalt"));
    }

    public COSObject getKDFSaltValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("KDFSalt"));
        return object;
    }

    @Override
    public Boolean getisKDFSaltIndirect() {
        COSObject KDFSalt = this.getKDFSaltValue();
        return GFAEncryptionStandard.getisIndirect(KDFSalt);
    }

    @Override
    public String getKDFSaltType() {
        COSObject KDFSalt = this.getKDFSaltValue();
        return this.getObjectType(KDFSalt);
    }

    @Override
    public Boolean getKDFSaltHasTypeStringByte() {
        COSObject KDFSalt = this.getKDFSaltValue();
        return GFAEncryptionStandard.getHasTypeStringByte(KDFSalt);
    }

    @Override
    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Length"));
    }

    public COSObject getLengthDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: {
                return COSInteger.construct(40L);
            }
        }
        return null;
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Length"));
        if (object == null || object.empty()) {
            object = this.getLengthDefaultValue();
        }
        return object;
    }

    @Override
    public String getLengthType() {
        COSObject Length = this.getLengthValue();
        return this.getObjectType(Length);
    }

    @Override
    public Boolean getLengthHasTypeInteger() {
        COSObject Length = this.getLengthValue();
        return GFAEncryptionStandard.getHasTypeInteger(Length);
    }

    @Override
    public Long getLengthIntegerValue() {
        COSObject Length = this.getLengthValue();
        return GFAEncryptionStandard.getIntegerValue(Length);
    }

    @Override
    public Boolean getcontainsO() {
        return this.baseObject.knownKey(ASAtom.getASAtom("O"));
    }

    public COSObject getOValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("O"));
        return object;
    }

    @Override
    public String getOType() {
        COSObject O = this.getOValue();
        return this.getObjectType(O);
    }

    @Override
    public Boolean getOHasTypeStringByte() {
        COSObject O = this.getOValue();
        return GFAEncryptionStandard.getHasTypeStringByte(O);
    }

    @Override
    public Long getOStringSize() {
        COSObject O = this.getOValue();
        if (O != null && O.getType() == COSObjType.COS_STRING) {
            return O.getString().length();
        }
        return null;
    }

    @Override
    public Boolean getcontainsOE() {
        return this.baseObject.knownKey(ASAtom.getASAtom("OE"));
    }

    public COSObject getOEValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OE"));
        return object;
    }

    @Override
    public String getOEType() {
        COSObject OE = this.getOEValue();
        return this.getObjectType(OE);
    }

    @Override
    public Boolean getOEHasTypeStringByte() {
        COSObject OE = this.getOEValue();
        return GFAEncryptionStandard.getHasTypeStringByte(OE);
    }

    @Override
    public Long getOEStringSize() {
        COSObject OE = this.getOEValue();
        if (OE != null && OE.getType() == COSObjType.COS_STRING) {
            return OE.getString().length();
        }
        return null;
    }

    @Override
    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom("P"));
    }

    public COSObject getPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("P"));
        return object;
    }

    @Override
    public String getPType() {
        COSObject P = this.getPValue();
        return this.getObjectType(P);
    }

    @Override
    public Boolean getPHasTypeBitmask() {
        COSObject P = this.getPValue();
        return GFAEncryptionStandard.getHasTypeBitmask(P);
    }

    @Override
    public Long getPBitmaskValue() {
        COSObject P = this.getPValue();
        return GFAEncryptionStandard.getBitmaskValue(P);
    }

    @Override
    public Boolean getcontainsPerms() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Perms"));
    }

    public COSObject getPermsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Perms"));
        return object;
    }

    @Override
    public String getPermsType() {
        COSObject Perms = this.getPermsValue();
        return this.getObjectType(Perms);
    }

    @Override
    public Boolean getPermsHasTypeStringByte() {
        COSObject Perms = this.getPermsValue();
        return GFAEncryptionStandard.getHasTypeStringByte(Perms);
    }

    @Override
    public Boolean getcontainsR() {
        return this.baseObject.knownKey(ASAtom.getASAtom("R"));
    }

    public COSObject getRValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("R"));
        return object;
    }

    @Override
    public String getRType() {
        COSObject R = this.getRValue();
        return this.getObjectType(R);
    }

    @Override
    public Boolean getRHasTypeInteger() {
        COSObject R = this.getRValue();
        return GFAEncryptionStandard.getHasTypeInteger(R);
    }

    @Override
    public Long getRIntegerValue() {
        COSObject R = this.getRValue();
        return GFAEncryptionStandard.getIntegerValue(R);
    }

    @Override
    public Boolean getcontainsStmF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("StmF"));
    }

    public COSObject getStmFDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("Identity");
            }
        }
        return null;
    }

    public COSObject getStmFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("StmF"));
        if (object == null || object.empty()) {
            object = this.getStmFDefaultValue();
        }
        return object;
    }

    @Override
    public String getStmFType() {
        COSObject StmF = this.getStmFValue();
        return this.getObjectType(StmF);
    }

    @Override
    public Boolean getStmFHasTypeName() {
        COSObject StmF = this.getStmFValue();
        return GFAEncryptionStandard.getHasTypeName(StmF);
    }

    @Override
    public Boolean getcontainsStrF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("StrF"));
    }

    public COSObject getStrFDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("Identity");
            }
        }
        return null;
    }

    public COSObject getStrFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("StrF"));
        if (object == null || object.empty()) {
            object = this.getStrFDefaultValue();
        }
        return object;
    }

    @Override
    public String getStrFType() {
        COSObject StrF = this.getStrFValue();
        return this.getObjectType(StrF);
    }

    @Override
    public Boolean getStrFHasTypeName() {
        COSObject StrF = this.getStrFValue();
        return GFAEncryptionStandard.getHasTypeName(StrF);
    }

    @Override
    public Boolean getcontainsSubFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("SubFilter"));
    }

    public COSObject getSubFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("SubFilter"));
        return object;
    }

    @Override
    public String getSubFilterType() {
        COSObject SubFilter = this.getSubFilterValue();
        return this.getObjectType(SubFilter);
    }

    @Override
    public Boolean getSubFilterHasTypeName() {
        COSObject SubFilter = this.getSubFilterValue();
        return GFAEncryptionStandard.getHasTypeName(SubFilter);
    }

    @Override
    public Boolean getcontainsU() {
        return this.baseObject.knownKey(ASAtom.getASAtom("U"));
    }

    public COSObject getUValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("U"));
        return object;
    }

    @Override
    public String getUType() {
        COSObject U = this.getUValue();
        return this.getObjectType(U);
    }

    @Override
    public Boolean getUHasTypeStringByte() {
        COSObject U = this.getUValue();
        return GFAEncryptionStandard.getHasTypeStringByte(U);
    }

    @Override
    public Long getUStringSize() {
        COSObject U = this.getUValue();
        if (U != null && U.getType() == COSObjType.COS_STRING) {
            return U.getString().length();
        }
        return null;
    }

    @Override
    public Boolean getcontainsUE() {
        return this.baseObject.knownKey(ASAtom.getASAtom("UE"));
    }

    public COSObject getUEValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("UE"));
        return object;
    }

    @Override
    public String getUEType() {
        COSObject UE = this.getUEValue();
        return this.getObjectType(UE);
    }

    @Override
    public Boolean getUEHasTypeStringByte() {
        COSObject UE = this.getUEValue();
        return GFAEncryptionStandard.getHasTypeStringByte(UE);
    }

    @Override
    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom("V"));
    }

    public COSObject getVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("V"));
        return object;
    }

    @Override
    public String getVType() {
        COSObject V = this.getVValue();
        return this.getObjectType(V);
    }

    @Override
    public Boolean getVHasTypeInteger() {
        COSObject V = this.getVValue();
        return GFAEncryptionStandard.getHasTypeInteger(V);
    }

    @Override
    public Long getVIntegerValue() {
        COSObject V = this.getVValue();
        return GFAEncryptionStandard.getIntegerValue(V);
    }

    @Override
    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }

    @Override
    public Boolean gethasExtensionISO_TS_32004() {
        return false;
    }
}

