/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARichMediaActivation;
import org.verapdf.gf.model.impl.arlington.GFARichMediaDeactivation;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ARichMediaActivation;
import org.verapdf.model.alayer.ARichMediaDeactivation;
import org.verapdf.model.alayer.ARichMediaSettings;
import org.verapdf.model.baselayer.Object;

public class GFARichMediaSettings
extends GFAObject
implements ARichMediaSettings {
    public GFARichMediaSettings(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARichMediaSettings");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Activation": {
                return this.getActivation();
            }
            case "Deactivation": {
                return this.getDeactivation();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ARichMediaActivation> getActivation() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getActivation1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<ARichMediaActivation> getActivation1_7() {
        COSObject object = this.getActivationValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARichMediaActivation> list = new ArrayList<GFARichMediaActivation>(1);
            list.add(new GFARichMediaActivation((COSDictionary)object.getDirectBase(), this.baseObject, "Activation"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ARichMediaDeactivation> getDeactivation() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDeactivation1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<ARichMediaDeactivation> getDeactivation1_7() {
        COSObject object = this.getDeactivationValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARichMediaDeactivation> list = new ArrayList<GFARichMediaDeactivation>(1);
            list.add(new GFARichMediaDeactivation((COSDictionary)object.getDirectBase(), this.baseObject, "Deactivation"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsActivation() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Activation"));
    }

    public COSObject getActivationValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Activation"));
        return object;
    }

    @Override
    public String getActivationType() {
        COSObject Activation = this.getActivationValue();
        return this.getObjectType(Activation);
    }

    @Override
    public Boolean getActivationHasTypeDictionary() {
        COSObject Activation = this.getActivationValue();
        return GFARichMediaSettings.getHasTypeDictionary(Activation);
    }

    @Override
    public Boolean getcontainsDeactivation() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Deactivation"));
    }

    public COSObject getDeactivationValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Deactivation"));
        return object;
    }

    @Override
    public String getDeactivationType() {
        COSObject Deactivation = this.getDeactivationValue();
        return this.getObjectType(Deactivation);
    }

    @Override
    public Boolean getDeactivationHasTypeDictionary() {
        COSObject Deactivation = this.getDeactivationValue();
        return GFARichMediaSettings.getHasTypeDictionary(Deactivation);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFARichMediaSettings.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFARichMediaSettings.getNameValue(Type2);
    }

    @Override
    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }
}

