/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFABeadFirst;
import org.verapdf.gf.model.impl.arlington.GFADocInfo;
import org.verapdf.gf.model.impl.arlington.GFAMetadata;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ABeadFirst;
import org.verapdf.model.alayer.ADocInfo;
import org.verapdf.model.alayer.AMetadata;
import org.verapdf.model.alayer.AThread;
import org.verapdf.model.baselayer.Object;

public class GFAThread
extends GFAObject
implements AThread {
    public GFAThread(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AThread");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "F": {
                return this.getF();
            }
            case "I": {
                return this.getI();
            }
            case "Metadata": {
                return this.getMetadata();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ABeadFirst> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getF1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<ABeadFirst> getF1_1() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFABeadFirst> list = new ArrayList<GFABeadFirst>(1);
            list.add(new GFABeadFirst((COSDictionary)object.getDirectBase(), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ADocInfo> getI() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getI1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<ADocInfo> getI1_1() {
        COSObject object = this.getIValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFADocInfo> list = new ArrayList<GFADocInfo>(1);
            list.add(new GFADocInfo((COSDictionary)object.getDirectBase(), this.baseObject, "I"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AMetadata> getMetadata() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getMetadata2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AMetadata> getMetadata2_0() {
        COSObject object = this.getMetadataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAMetadata> list = new ArrayList<GFAMetadata>(1);
            list.add(new GFAMetadata((COSStream)object.getDirectBase(), this.baseObject, "Metadata"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("F"));
        return object;
    }

    @Override
    public Boolean getisFIndirect() {
        COSObject F = this.getFValue();
        return GFAThread.getisIndirect(F);
    }

    @Override
    public String getFType() {
        COSObject F = this.getFValue();
        return this.getObjectType(F);
    }

    @Override
    public Boolean getFHasTypeDictionary() {
        COSObject F = this.getFValue();
        return GFAThread.getHasTypeDictionary(F);
    }

    @Override
    public Boolean getcontainsI() {
        return this.baseObject.knownKey(ASAtom.getASAtom("I"));
    }

    public COSObject getIValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("I"));
        return object;
    }

    @Override
    public String getIType() {
        COSObject I = this.getIValue();
        return this.getObjectType(I);
    }

    @Override
    public Boolean getIHasTypeDictionary() {
        COSObject I = this.getIValue();
        return GFAThread.getHasTypeDictionary(I);
    }

    @Override
    public Boolean getcontainsMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Metadata"));
    }

    public COSObject getMetadataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Metadata"));
        return object;
    }

    @Override
    public Boolean getisMetadataIndirect() {
        COSObject Metadata2 = this.getMetadataValue();
        return GFAThread.getisIndirect(Metadata2);
    }

    @Override
    public String getMetadataType() {
        COSObject Metadata2 = this.getMetadataValue();
        return this.getObjectType(Metadata2);
    }

    @Override
    public Boolean getMetadataHasTypeStream() {
        COSObject Metadata2 = this.getMetadataValue();
        return GFAThread.getHasTypeStream(Metadata2);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAThread.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAThread.getNameValue(Type2);
    }
}

