/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfCompressionFilterNames;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfDecodeParams;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfXRefIndexIntegers;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfXRefWIntegers;
import org.verapdf.gf.model.impl.arlington.GFAAuthCode;
import org.verapdf.gf.model.impl.arlington.GFACatalog;
import org.verapdf.gf.model.impl.arlington.GFADocInfo;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionPublicKey;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionStandard;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAFilterFlateDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterLZWDecode;
import org.verapdf.gf.model.impl.arlington.GFAOOAdditionalStmsArray;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFATrailerIDArray;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfCompressionFilterNames;
import org.verapdf.model.alayer.AArrayOfXRefIndexIntegers;
import org.verapdf.model.alayer.AArrayOfXRefWIntegers;
import org.verapdf.model.alayer.AAuthCode;
import org.verapdf.model.alayer.ACatalog;
import org.verapdf.model.alayer.ADocInfo;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.AOOAdditionalStmsArray;
import org.verapdf.model.alayer.ATrailerIDArray;
import org.verapdf.model.alayer.AXRefStream;
import org.verapdf.tools.StaticResources;

public class GFAXRefStream
extends GFAObject
implements AXRefStream {
    public GFAXRefStream(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AXRefStream");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AdditionalStreams": {
                return this.getAdditionalStreams();
            }
            case "AuthCode": {
                return this.getAuthCode();
            }
            case "DecodeParms": {
                return this.getDecodeParms();
            }
            case "Encrypt": {
                return this.getEncrypt();
            }
            case "F": {
                return this.getF();
            }
            case "FDecodeParms": {
                return this.getFDecodeParms();
            }
            case "FFilter": {
                return this.getFFilter();
            }
            case "Filter": {
                return this.getFilter();
            }
            case "entryID": {
                return this.getentryID();
            }
            case "Index": {
                return this.getIndex();
            }
            case "Info": {
                return this.getInfo();
            }
            case "Root": {
                return this.getRoot();
            }
            case "W": {
                return this.getW();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AOOAdditionalStmsArray> getAdditionalStreams() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAdditionalStreams1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AOOAdditionalStmsArray> getAdditionalStreams1_5() {
        COSObject object = this.getAdditionalStreamsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAOOAdditionalStmsArray> list = new ArrayList<GFAOOAdditionalStmsArray>(1);
            list.add(new GFAOOAdditionalStmsArray((COSArray)object.getDirectBase(), this.baseObject, "AdditionalStreams"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AAuthCode> getAuthCode() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getAuthCode2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AAuthCode> getAuthCode2_0() {
        COSObject object = this.getAuthCodeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAAuthCode> list = new ArrayList<GFAAuthCode>(1);
            list.add(new GFAAuthCode((COSDictionary)object.getDirectBase(), this.baseObject, "AuthCode"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_5() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_5(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEncrypt1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt1_5() {
        COSObject object = this.getEncryptValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getEncryptDictionary1_5(object.getDirectBase(), "Encrypt");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getEncryptDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom("Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
        }
        switch (subtypeValue) {
            case "Adobe.PubSec": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "AdobePPKLite": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "Standard": {
                return new GFAEncryptionStandard(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AFileSpecification> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getF1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getF1_5() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSDictionary)object.getDirectBase(), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_5() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_5(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfCompressionFilterNames> getFFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFFilter1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFFilter1_5() {
        COSObject object = this.getFFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSArray)object.getDirectBase(), this.baseObject, "FFilter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFilter1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter1_5() {
        COSObject object = this.getFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSArray)object.getDirectBase(), this.baseObject, "Filter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ATrailerIDArray> getentryID() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getentryID1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ATrailerIDArray> getentryID1_5() {
        COSObject object = this.getentryIDValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFATrailerIDArray> list = new ArrayList<GFATrailerIDArray>(1);
            list.add(new GFATrailerIDArray((COSArray)object.getDirectBase(), this.baseObject, "ID"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfXRefIndexIntegers> getIndex() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getIndex1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfXRefIndexIntegers> getIndex1_5() {
        COSObject object = this.getIndexValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfXRefIndexIntegers> list = new ArrayList<GFAArrayOfXRefIndexIntegers>(1);
            list.add(new GFAArrayOfXRefIndexIntegers((COSArray)object.getDirectBase(), this.baseObject, "Index"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ADocInfo> getInfo() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getInfo1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ADocInfo> getInfo1_5() {
        COSObject object = this.getInfoValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFADocInfo> list = new ArrayList<GFADocInfo>(1);
            list.add(new GFADocInfo((COSDictionary)object.getDirectBase(), this.baseObject, "Info"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ACatalog> getRoot() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getRoot1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ACatalog> getRoot1_5() {
        COSObject object = this.getRootValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACatalog> list = new ArrayList<GFACatalog>(1);
            list.add(new GFACatalog((COSDictionary)object.getDirectBase(), this.baseObject, "Root"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfXRefWIntegers> getW() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getW1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfXRefWIntegers> getW1_5() {
        COSObject object = this.getWValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfXRefWIntegers> list = new ArrayList<GFAArrayOfXRefWIntegers>(1);
            list.add(new GFAArrayOfXRefWIntegers((COSArray)object.getDirectBase(), this.baseObject, "W"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsAdditionalStreams() {
        return this.baseObject.knownKey(ASAtom.getASAtom("AdditionalStreams"));
    }

    public COSObject getAdditionalStreamsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("AdditionalStreams"));
        return object;
    }

    @Override
    public Boolean getisAdditionalStreamsIndirect() {
        COSObject AdditionalStreams = this.getAdditionalStreamsValue();
        return GFAXRefStream.getisIndirect(AdditionalStreams);
    }

    @Override
    public String getAdditionalStreamsType() {
        COSObject AdditionalStreams = this.getAdditionalStreamsValue();
        return this.getObjectType(AdditionalStreams);
    }

    @Override
    public Boolean getAdditionalStreamsHasTypeArray() {
        COSObject AdditionalStreams = this.getAdditionalStreamsValue();
        return GFAXRefStream.getHasTypeArray(AdditionalStreams);
    }

    @Override
    public Long getAdditionalStreamsArraySize() {
        COSObject AdditionalStreams = this.getAdditionalStreamsValue();
        return GFAXRefStream.getArraySize(AdditionalStreams);
    }

    @Override
    public Boolean getcontainsAuthCode() {
        return this.baseObject.knownKey(ASAtom.getASAtom("AuthCode"));
    }

    public COSObject getAuthCodeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("AuthCode"));
        return object;
    }

    @Override
    public Boolean getisAuthCodeIndirect() {
        COSObject AuthCode = this.getAuthCodeValue();
        return GFAXRefStream.getisIndirect(AuthCode);
    }

    @Override
    public String getAuthCodeType() {
        COSObject AuthCode = this.getAuthCodeValue();
        return this.getObjectType(AuthCode);
    }

    @Override
    public Boolean getAuthCodeHasTypeDictionary() {
        COSObject AuthCode = this.getAuthCodeValue();
        return GFAXRefStream.getHasTypeDictionary(AuthCode);
    }

    @Override
    public Boolean getcontainsDL() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DL"));
    }

    public COSObject getDLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DL"));
        return object;
    }

    @Override
    public Boolean getisDLIndirect() {
        COSObject DL = this.getDLValue();
        return GFAXRefStream.getisIndirect(DL);
    }

    @Override
    public String getDLType() {
        COSObject DL = this.getDLValue();
        return this.getObjectType(DL);
    }

    @Override
    public Boolean getDLHasTypeInteger() {
        COSObject DL = this.getDLValue();
        return GFAXRefStream.getHasTypeInteger(DL);
    }

    @Override
    public Long getDLIntegerValue() {
        COSObject DL = this.getDLValue();
        return GFAXRefStream.getIntegerValue(DL);
    }

    @Override
    public Boolean getcontainsDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DecodeParms"));
    }

    public COSObject getDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DecodeParms"));
        return object;
    }

    @Override
    public Boolean getisDecodeParmsIndirect() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXRefStream.getisIndirect(DecodeParms);
    }

    @Override
    public String getDecodeParmsType() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return this.getObjectType(DecodeParms);
    }

    @Override
    public Boolean getDecodeParmsHasTypeArray() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXRefStream.getHasTypeArray(DecodeParms);
    }

    @Override
    public Boolean getDecodeParmsHasTypeDictionary() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXRefStream.getHasTypeDictionary(DecodeParms);
    }

    @Override
    public Long getDecodeParmsArraySize() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXRefStream.getArraySize(DecodeParms);
    }

    @Override
    public Boolean getcontainsDocChecksum() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DocChecksum"));
    }

    public COSObject getDocChecksumValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DocChecksum"));
        return object;
    }

    @Override
    public Boolean getisDocChecksumIndirect() {
        COSObject DocChecksum = this.getDocChecksumValue();
        return GFAXRefStream.getisIndirect(DocChecksum);
    }

    @Override
    public String getDocChecksumType() {
        COSObject DocChecksum = this.getDocChecksumValue();
        return this.getObjectType(DocChecksum);
    }

    @Override
    public Boolean getDocChecksumHasTypeName() {
        COSObject DocChecksum = this.getDocChecksumValue();
        return GFAXRefStream.getHasTypeName(DocChecksum);
    }

    @Override
    public Boolean getcontainsEncrypt() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Encrypt"));
    }

    public COSObject getEncryptValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Encrypt"));
        return object;
    }

    @Override
    public Boolean getisEncryptIndirect() {
        COSObject Encrypt = this.getEncryptValue();
        return GFAXRefStream.getisIndirect(Encrypt);
    }

    @Override
    public String getEncryptType() {
        COSObject Encrypt = this.getEncryptValue();
        return this.getObjectType(Encrypt);
    }

    @Override
    public Boolean getEncryptHasTypeDictionary() {
        COSObject Encrypt = this.getEncryptValue();
        return GFAXRefStream.getHasTypeDictionary(Encrypt);
    }

    @Override
    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("F"));
        return object;
    }

    @Override
    public String getFType() {
        COSObject F = this.getFValue();
        return this.getObjectType(F);
    }

    @Override
    public Boolean getFHasTypeDictionary() {
        COSObject F = this.getFValue();
        return GFAXRefStream.getHasTypeDictionary(F);
    }

    @Override
    public Boolean getFHasTypeString() {
        COSObject F = this.getFValue();
        return GFAXRefStream.getHasTypeString(F);
    }

    @Override
    public Boolean getcontainsFDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FDecodeParms"));
    }

    public COSObject getFDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FDecodeParms"));
        return object;
    }

    @Override
    public String getFDecodeParmsType() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return this.getObjectType(FDecodeParms);
    }

    @Override
    public Boolean getFDecodeParmsHasTypeArray() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXRefStream.getHasTypeArray(FDecodeParms);
    }

    @Override
    public Boolean getFDecodeParmsHasTypeDictionary() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXRefStream.getHasTypeDictionary(FDecodeParms);
    }

    @Override
    public Long getFDecodeParmsArraySize() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXRefStream.getArraySize(FDecodeParms);
    }

    @Override
    public Boolean getcontainsFFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FFilter"));
    }

    public COSObject getFFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FFilter"));
        return object;
    }

    @Override
    public String getFFilterType() {
        COSObject FFilter = this.getFFilterValue();
        return this.getObjectType(FFilter);
    }

    @Override
    public Boolean getFFilterHasTypeArray() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXRefStream.getHasTypeArray(FFilter);
    }

    @Override
    public Boolean getFFilterHasTypeName() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXRefStream.getHasTypeName(FFilter);
    }

    @Override
    public String getFFilterNameValue() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXRefStream.getNameValue(FFilter);
    }

    @Override
    public Long getFFilterArraySize() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXRefStream.getArraySize(FFilter);
    }

    @Override
    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        return object;
    }

    @Override
    public Boolean getisFilterIndirect() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXRefStream.getisIndirect(Filter2);
    }

    @Override
    public String getFilterType() {
        COSObject Filter2 = this.getFilterValue();
        return this.getObjectType(Filter2);
    }

    @Override
    public Boolean getFilterHasTypeArray() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXRefStream.getHasTypeArray(Filter2);
    }

    @Override
    public Boolean getFilterHasTypeName() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXRefStream.getHasTypeName(Filter2);
    }

    @Override
    public String getFilterNameValue() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXRefStream.getNameValue(Filter2);
    }

    @Override
    public Long getFilterArraySize() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXRefStream.getArraySize(Filter2);
    }

    @Override
    public String getFilterEntriesString() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXRefStream.getEntriesString(Filter2);
    }

    @Override
    public Boolean getcontainsID() {
        return this.baseObject.knownKey(ASAtom.getASAtom("ID"));
    }

    public COSObject getentryIDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ID"));
        return object;
    }

    @Override
    public Boolean getisentryIDIndirect() {
        COSObject entryID = this.getentryIDValue();
        return GFAXRefStream.getisIndirect(entryID);
    }

    @Override
    public String getentryIDType() {
        COSObject entryID = this.getentryIDValue();
        return this.getObjectType(entryID);
    }

    @Override
    public Boolean getentryIDHasTypeArray() {
        COSObject entryID = this.getentryIDValue();
        return GFAXRefStream.getHasTypeArray(entryID);
    }

    @Override
    public Boolean getcontainsIndex() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Index"));
    }

    public COSObject getIndexValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Index"));
        return object;
    }

    @Override
    public Boolean getisIndexIndirect() {
        COSObject Index = this.getIndexValue();
        return GFAXRefStream.getisIndirect(Index);
    }

    @Override
    public String getIndexType() {
        COSObject Index = this.getIndexValue();
        return this.getObjectType(Index);
    }

    @Override
    public Boolean getIndexHasTypeArray() {
        COSObject Index = this.getIndexValue();
        return GFAXRefStream.getHasTypeArray(Index);
    }

    @Override
    public Boolean getisIndexArraySortAscending2() {
        COSObject Index = this.getIndexValue();
        return GFAXRefStream.getisArraySortAscending(Index, 2);
    }

    @Override
    public Long getIndexArraySize() {
        COSObject Index = this.getIndexValue();
        return GFAXRefStream.getArraySize(Index);
    }

    @Override
    public Boolean getcontainsInfo() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Info"));
    }

    public COSObject getInfoValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Info"));
        return object;
    }

    @Override
    public Boolean getisInfoIndirect() {
        COSObject Info = this.getInfoValue();
        return GFAXRefStream.getisIndirect(Info);
    }

    @Override
    public String getInfoType() {
        COSObject Info = this.getInfoValue();
        return this.getObjectType(Info);
    }

    @Override
    public Boolean getInfoHasTypeDictionary() {
        COSObject Info = this.getInfoValue();
        return GFAXRefStream.getHasTypeDictionary(Info);
    }

    @Override
    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Length"));
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Length"));
        return object;
    }

    @Override
    public Boolean getisLengthIndirect() {
        COSObject Length = this.getLengthValue();
        return GFAXRefStream.getisIndirect(Length);
    }

    @Override
    public String getLengthType() {
        COSObject Length = this.getLengthValue();
        return this.getObjectType(Length);
    }

    @Override
    public Boolean getLengthHasTypeInteger() {
        COSObject Length = this.getLengthValue();
        return GFAXRefStream.getHasTypeInteger(Length);
    }

    @Override
    public Long getLengthIntegerValue() {
        COSObject Length = this.getLengthValue();
        return GFAXRefStream.getIntegerValue(Length);
    }

    @Override
    public Boolean getcontainsPrev() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Prev"));
    }

    public COSObject getPrevValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Prev"));
        return object;
    }

    @Override
    public Boolean getisPrevIndirect() {
        COSObject Prev = this.getPrevValue();
        return GFAXRefStream.getisIndirect(Prev);
    }

    @Override
    public String getPrevType() {
        COSObject Prev = this.getPrevValue();
        return this.getObjectType(Prev);
    }

    @Override
    public Boolean getPrevHasTypeInteger() {
        COSObject Prev = this.getPrevValue();
        return GFAXRefStream.getHasTypeInteger(Prev);
    }

    @Override
    public Long getPrevIntegerValue() {
        COSObject Prev = this.getPrevValue();
        return GFAXRefStream.getIntegerValue(Prev);
    }

    @Override
    public Boolean getcontainsRoot() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Root"));
    }

    public COSObject getRootValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Root"));
        return object;
    }

    @Override
    public Boolean getisRootIndirect() {
        COSObject Root = this.getRootValue();
        return GFAXRefStream.getisIndirect(Root);
    }

    @Override
    public String getRootType() {
        COSObject Root = this.getRootValue();
        return this.getObjectType(Root);
    }

    @Override
    public Boolean getRootHasTypeDictionary() {
        COSObject Root = this.getRootValue();
        return GFAXRefStream.getHasTypeDictionary(Root);
    }

    @Override
    public Boolean getcontainsSize() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Size"));
    }

    public COSObject getSizeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Size"));
        return object;
    }

    @Override
    public Boolean getisSizeIndirect() {
        COSObject Size = this.getSizeValue();
        return GFAXRefStream.getisIndirect(Size);
    }

    @Override
    public String getSizeType() {
        COSObject Size = this.getSizeValue();
        return this.getObjectType(Size);
    }

    @Override
    public Boolean getSizeHasTypeInteger() {
        COSObject Size = this.getSizeValue();
        return GFAXRefStream.getHasTypeInteger(Size);
    }

    @Override
    public Long getSizeIntegerValue() {
        COSObject Size = this.getSizeValue();
        return GFAXRefStream.getIntegerValue(Size);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getisTypeIndirect() {
        COSObject Type2 = this.getTypeValue();
        return GFAXRefStream.getisIndirect(Type2);
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAXRefStream.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAXRefStream.getNameValue(Type2);
    }

    @Override
    public Boolean getcontainsW() {
        return this.baseObject.knownKey(ASAtom.getASAtom("W"));
    }

    public COSObject getWValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("W"));
        return object;
    }

    @Override
    public Boolean getisWIndirect() {
        COSObject W = this.getWValue();
        return GFAXRefStream.getisIndirect(W);
    }

    @Override
    public String getWType() {
        COSObject W = this.getWValue();
        return this.getObjectType(W);
    }

    @Override
    public Boolean getWHasTypeArray() {
        COSObject W = this.getWValue();
        return GFAXRefStream.getHasTypeArray(W);
    }

    public COSObject getEncryptVValue() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Encrypt = this.baseObject.getKey(ASAtom.getASAtom("Encrypt"));
        if (Encrypt == null || !Encrypt.getType().isDictionaryBased()) {
            return null;
        }
        COSObject V = Encrypt.getKey(ASAtom.getASAtom("V"));
        return V;
    }

    public COSObject gettrailerCatalogValue() {
        COSObject trailer = StaticResources.getDocument().getDocument().getTrailer().getObject();
        if (trailer == null || !trailer.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Root = trailer.getKey(ASAtom.getASAtom("Root"));
        return Root;
    }

    public COSObject gettrailerInfoValue() {
        COSObject trailer = StaticResources.getDocument().getDocument().getTrailer().getObject();
        if (trailer == null || !trailer.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Info = trailer.getKey(ASAtom.getASAtom("Info"));
        return Info;
    }

    @Override
    public Long getEncryptVIntegerValue() {
        COSObject EncryptV = this.getEncryptVValue();
        return GFAXRefStream.getIntegerValue(EncryptV);
    }

    @Override
    public Boolean getEncryptVHasTypeInteger() {
        COSObject EncryptV = this.getEncryptVValue();
        return GFAXRefStream.getHasTypeInteger(EncryptV);
    }

    @Override
    public Boolean getcontainstrailerCatalogPieceInfo() {
        COSObject trailerCatalog = this.gettrailerCatalogValue();
        return trailerCatalog.knownKey(ASAtom.getASAtom("PieceInfo"));
    }

    @Override
    public Boolean getcontainstrailerInfoModDate() {
        COSObject trailerInfo = this.gettrailerInfoValue();
        return trailerInfo.knownKey(ASAtom.getASAtom("ModDate"));
    }

    @Override
    public Boolean gethasExtensionISO_TS_32004() {
        return false;
    }

    @Override
    public Boolean gethasExtensionOpenOffice() {
        return false;
    }
}

