/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf_4Integers;
import org.verapdf.gf.model.impl.arlington.GFADocTimeStamp;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFASignature;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOf_4Integers;
import org.verapdf.model.alayer.AAuthCode;
import org.verapdf.model.baselayer.Object;

public class GFAAuthCode
extends GFAObject
implements AAuthCode {
    public GFAAuthCode(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AAuthCode");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "ByteRange": {
                return this.getByteRange();
            }
            case "SigObjRef": {
                return this.getSigObjRef();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOf_4Integers> getByteRange() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getByteRange2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf_4Integers> getByteRange2_0() {
        COSObject object = this.getByteRangeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf_4Integers> list = new ArrayList<GFAArrayOf_4Integers>(1);
            list.add(new GFAArrayOf_4Integers((COSArray)object.getDirectBase(), this.baseObject, "ByteRange"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<Object> getSigObjRef() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getSigObjRef2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getSigObjRef2_0() {
        COSObject object = this.getSigObjRefValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            Object result = this.getSigObjRefDictionary2_0(object.getDirectBase(), "SigObjRef");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getSigObjRefDictionary2_0(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom("Type"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "DocTimeStamp": {
                return new GFADocTimeStamp(base, this.baseObject, keyName);
            }
            case "Sig": {
                return new GFASignature(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    @Override
    public Boolean getcontainsByteRange() {
        return this.baseObject.knownKey(ASAtom.getASAtom("ByteRange"));
    }

    public COSObject getByteRangeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ByteRange"));
        return object;
    }

    @Override
    public Boolean getisByteRangeIndirect() {
        COSObject ByteRange = this.getByteRangeValue();
        return GFAAuthCode.getisIndirect(ByteRange);
    }

    @Override
    public String getByteRangeType() {
        COSObject ByteRange = this.getByteRangeValue();
        return this.getObjectType(ByteRange);
    }

    @Override
    public Boolean getByteRangeHasTypeArray() {
        COSObject ByteRange = this.getByteRangeValue();
        return GFAAuthCode.getHasTypeArray(ByteRange);
    }

    @Override
    public Boolean getcontainsMAC() {
        return this.baseObject.knownKey(ASAtom.getASAtom("MAC"));
    }

    public COSObject getMACValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("MAC"));
        return object;
    }

    @Override
    public Boolean getisMACIndirect() {
        COSObject MAC = this.getMACValue();
        return GFAAuthCode.getisIndirect(MAC);
    }

    @Override
    public String getMACType() {
        COSObject MAC = this.getMACValue();
        return this.getObjectType(MAC);
    }

    @Override
    public Boolean getMACHasTypeStringByte() {
        COSObject MAC = this.getMACValue();
        return GFAAuthCode.getHasTypeStringByte(MAC);
    }

    @Override
    public Boolean getcontainsMACLocation() {
        return this.baseObject.knownKey(ASAtom.getASAtom("MACLocation"));
    }

    public COSObject getMACLocationValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("MACLocation"));
        return object;
    }

    @Override
    public Boolean getisMACLocationIndirect() {
        COSObject MACLocation = this.getMACLocationValue();
        return GFAAuthCode.getisIndirect(MACLocation);
    }

    @Override
    public String getMACLocationType() {
        COSObject MACLocation = this.getMACLocationValue();
        return this.getObjectType(MACLocation);
    }

    @Override
    public Boolean getMACLocationHasTypeName() {
        COSObject MACLocation = this.getMACLocationValue();
        return GFAAuthCode.getHasTypeName(MACLocation);
    }

    @Override
    public String getMACLocationNameValue() {
        COSObject MACLocation = this.getMACLocationValue();
        return GFAAuthCode.getNameValue(MACLocation);
    }

    @Override
    public Boolean getcontainsSigObjRef() {
        return this.baseObject.knownKey(ASAtom.getASAtom("SigObjRef"));
    }

    public COSObject getSigObjRefValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("SigObjRef"));
        return object;
    }

    @Override
    public Boolean getisSigObjRefIndirect() {
        COSObject SigObjRef = this.getSigObjRefValue();
        return GFAAuthCode.getisIndirect(SigObjRef);
    }

    @Override
    public String getSigObjRefType() {
        COSObject SigObjRef = this.getSigObjRefValue();
        return this.getObjectType(SigObjRef);
    }

    @Override
    public Boolean getSigObjRefHasTypeDictionary() {
        COSObject SigObjRef = this.getSigObjRefValue();
        return GFAAuthCode.getHasTypeDictionary(SigObjRef);
    }

    @Override
    public Long getByteRange0IntegerValue() {
        COSObject ByteRange = this.getByteRangeValue();
        if (ByteRange == null || ByteRange.getType() != COSObjType.COS_ARRAY || ByteRange.size() <= 0) {
            return null;
        }
        return new GFAArrayOf_4Integers(ByteRange.getDirectBase(), null, null).getentry0IntegerValue();
    }

    @Override
    public Long getByteRange1IntegerValue() {
        COSObject ByteRange = this.getByteRangeValue();
        if (ByteRange == null || ByteRange.getType() != COSObjType.COS_ARRAY || ByteRange.size() <= 1) {
            return null;
        }
        return new GFAArrayOf_4Integers(ByteRange.getDirectBase(), null, null).getentry1IntegerValue();
    }

    @Override
    public Long getByteRange2IntegerValue() {
        COSObject ByteRange = this.getByteRangeValue();
        if (ByteRange == null || ByteRange.getType() != COSObjType.COS_ARRAY || ByteRange.size() <= 2) {
            return null;
        }
        return new GFAArrayOf_4Integers(ByteRange.getDirectBase(), null, null).getentry2IntegerValue();
    }

    @Override
    public Long getByteRange3IntegerValue() {
        COSObject ByteRange = this.getByteRangeValue();
        if (ByteRange == null || ByteRange.getType() != COSObjType.COS_ARRAY || ByteRange.size() <= 3) {
            return null;
        }
        return new GFAArrayOf_4Integers(ByteRange.getDirectBase(), null, null).getentry3IntegerValue();
    }

    @Override
    public Boolean getByteRange0HasTypeInteger() {
        COSObject ByteRange = this.getByteRangeValue();
        if (ByteRange == null || ByteRange.getType() != COSObjType.COS_ARRAY || ByteRange.size() <= 0) {
            return null;
        }
        return new GFAArrayOf_4Integers(ByteRange.getDirectBase(), null, null).getentry0HasTypeInteger();
    }

    @Override
    public Boolean getByteRange1HasTypeInteger() {
        COSObject ByteRange = this.getByteRangeValue();
        if (ByteRange == null || ByteRange.getType() != COSObjType.COS_ARRAY || ByteRange.size() <= 1) {
            return null;
        }
        return new GFAArrayOf_4Integers(ByteRange.getDirectBase(), null, null).getentry1HasTypeInteger();
    }

    @Override
    public Boolean getByteRange2HasTypeInteger() {
        COSObject ByteRange = this.getByteRangeValue();
        if (ByteRange == null || ByteRange.getType() != COSObjType.COS_ARRAY || ByteRange.size() <= 2) {
            return null;
        }
        return new GFAArrayOf_4Integers(ByteRange.getDirectBase(), null, null).getentry2HasTypeInteger();
    }

    @Override
    public Boolean getByteRange3HasTypeInteger() {
        COSObject ByteRange = this.getByteRangeValue();
        if (ByteRange == null || ByteRange.getType() != COSObjType.COS_ARRAY || ByteRange.size() <= 3) {
            return null;
        }
        return new GFAArrayOf_4Integers(ByteRange.getDirectBase(), null, null).getentry3HasTypeInteger();
    }
}

