/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStreamsGeneral;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAVRIMap;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfStreamsGeneral;
import org.verapdf.model.alayer.ADSS;
import org.verapdf.model.alayer.AVRIMap;
import org.verapdf.model.baselayer.Object;

public class GFADSS
extends GFAObject
implements ADSS {
    public GFADSS(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ADSS");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CRLs": {
                return this.getCRLs();
            }
            case "Certs": {
                return this.getCerts();
            }
            case "OCSPs": {
                return this.getOCSPs();
            }
            case "VRI": {
                return this.getVRI();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfStreamsGeneral> getCRLs() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getCRLs2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCRLs2_0() {
        COSObject object = this.getCRLsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSArray)object.getDirectBase(), this.baseObject, "CRLs"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCerts() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getCerts2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCerts2_0() {
        COSObject object = this.getCertsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSArray)object.getDirectBase(), this.baseObject, "Certs"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getOCSPs() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getOCSPs2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getOCSPs2_0() {
        COSObject object = this.getOCSPsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSArray)object.getDirectBase(), this.baseObject, "OCSPs"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AVRIMap> getVRI() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getVRI2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AVRIMap> getVRI2_0() {
        COSObject object = this.getVRIValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAVRIMap> list = new ArrayList<GFAVRIMap>(1);
            list.add(new GFAVRIMap((COSDictionary)object.getDirectBase(), this.baseObject, "VRI"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsCRLs() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CRLs"));
    }

    public COSObject getCRLsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CRLs"));
        return object;
    }

    @Override
    public Boolean getCRLsHasTypeArray() {
        COSObject object = this.getCRLsValue();
        return GFADSS.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsCerts() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Certs"));
    }

    public COSObject getCertsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Certs"));
        return object;
    }

    @Override
    public Boolean getCertsHasTypeArray() {
        COSObject object = this.getCertsValue();
        return GFADSS.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsOCSPs() {
        return this.baseObject.knownKey(ASAtom.getASAtom("OCSPs"));
    }

    public COSObject getOCSPsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OCSPs"));
        return object;
    }

    @Override
    public Boolean getOCSPsHasTypeArray() {
        COSObject object = this.getOCSPsValue();
        return GFADSS.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFADSS.getHasTypeName(object);
    }

    @Override
    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        return GFADSS.getNameValue(object);
    }

    @Override
    public Boolean getcontainsVRI() {
        return this.baseObject.knownKey(ASAtom.getASAtom("VRI"));
    }

    public COSObject getVRIValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("VRI"));
        return object;
    }

    @Override
    public Boolean getVRIHasTypeDictionary() {
        COSObject object = this.getVRIValue();
        return GFADSS.getHasTypeDictionary(object);
    }
}

