/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AFilterJBIG2Decode;
import org.verapdf.model.alayer.AStream;
import org.verapdf.model.baselayer.Object;

public class GFAFilterJBIG2Decode
extends GFAObject
implements AFilterJBIG2Decode {
    public GFAFilterJBIG2Decode(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AFilterJBIG2Decode");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "JBIG2Globals": {
                return this.getJBIG2Globals();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AStream> getJBIG2Globals() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getJBIG2Globals1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getJBIG2Globals1_4() {
        COSObject object = this.getJBIG2GlobalsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "JBIG2Globals"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsJBIG2Globals() {
        return this.baseObject.knownKey(ASAtom.getASAtom("JBIG2Globals"));
    }

    public COSObject getJBIG2GlobalsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("JBIG2Globals"));
        return object;
    }

    @Override
    public Boolean getisJBIG2GlobalsIndirect() {
        COSObject object = this.getJBIG2GlobalsValue();
        return GFAFilterJBIG2Decode.getisIndirect(object);
    }

    @Override
    public Boolean getJBIG2GlobalsHasTypeStream() {
        COSObject object = this.getJBIG2GlobalsValue();
        return GFAFilterJBIG2Decode.getHasTypeStream(object);
    }
}

