/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.images;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.colors.PDColorSpace;

public class PDInlineImage
extends PDResource {
    private static final Logger LOGGER = Logger.getLogger(PDInlineImage.class.getCanonicalName());
    private PDResources imageResources;
    private PDResources pageResources;

    public PDInlineImage(COSObject obj, PDResources imageResources, PDResources pageResources) {
        super(obj);
        this.imageResources = imageResources;
        this.pageResources = pageResources;
    }

    public boolean isInterpolate() {
        Boolean value = this.getObject().getBooleanKey(ASAtom.I);
        value = value == null ? this.getObject().getBooleanKey(ASAtom.INTERPOLATE) : value;
        return value != null ? value : false;
    }

    public Long getBitsPerComponent() {
        return this.getObject().getIntegerKey(ASAtom.BITS_PER_COMPONENT);
    }

    public List<COSName> getCOSFilters() {
        COSObject filters = this.getKey(ASAtom.F);
        if (filters == null || filters.empty()) {
            filters = this.getKey(ASAtom.FILTER);
        }
        if (filters != null) {
            ArrayList<COSName> res = new ArrayList<COSName>();
            if (filters.getType() == COSObjType.COS_NAME) {
                res.add((COSName)filters.getDirectBase());
            } else if (filters.getType() == COSObjType.COS_ARRAY) {
                for (COSObject filter : (COSArray)filters.getDirectBase()) {
                    if (filter == null || filter.getType() != COSObjType.COS_NAME) {
                        LOGGER.log(Level.FINE, "Filter array contains non name value");
                        return Collections.emptyList();
                    }
                    res.add((COSName)filter.getDirectBase());
                }
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public PDColorSpace getImageCS() {
        PDColorSpace result;
        COSObject cs = this.getKey(ASAtom.CS);
        if (cs.empty()) {
            cs = this.getKey(ASAtom.COLORSPACE);
        }
        if (cs != null && cs.getType() == COSObjType.COS_NAME) {
            PDInlineImage.replaceAbbreviation((COSName)cs.getDirectBase());
            result = this.getDefaultColorSpace(cs.getName());
            if (result != null) {
                return result;
            }
        }
        if ((result = ColorSpaceFactory.getColorSpace(cs, this.imageResources)) == null) {
            result = ColorSpaceFactory.getColorSpace(cs, this.pageResources);
        }
        return result;
    }

    public boolean getImageMask() {
        Boolean result;
        COSObject im = this.getKey(ASAtom.IM);
        if (im.empty()) {
            im = this.getKey(ASAtom.IMAGE_MASK);
        }
        return (result = im.getBoolean()) != null ? result : false;
    }

    private PDColorSpace getDefaultColorSpace(ASAtom name) {
        if (PDInlineImage.isDeviceDependent(name)) {
            if (this.imageResources != null) {
                ASAtom value = ColorSpaceFactory.getDefaultValue(this.imageResources, name);
                if (value != null) {
                    return this.imageResources.getColorSpace(value);
                }
            } else {
                ASAtom value = ColorSpaceFactory.getDefaultValue(this.pageResources, name);
                if (value != null) {
                    return this.pageResources.getColorSpace(value);
                }
            }
        }
        return null;
    }

    private static boolean isDeviceDependent(ASAtom name) {
        return ASAtom.DEVICERGB.equals(name) || ASAtom.DEVICEGRAY.equals(name) || ASAtom.DEVICECMYK.equals(name);
    }

    private static void replaceAbbreviation(COSName abbreviation) {
        if (abbreviation.getName() == ASAtom.CMYK) {
            abbreviation.set(ASAtom.DEVICECMYK);
        } else if (abbreviation.getName() == ASAtom.RGB) {
            abbreviation.set(ASAtom.DEVICERGB);
        } else if (abbreviation.getName() == ASAtom.G) {
            abbreviation.set(ASAtom.DEVICEGRAY);
        }
    }

    public COSName getIntent() {
        COSObject object = this.getKey(ASAtom.INTENT);
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return (COSName)object.getDirectBase();
        }
        return null;
    }
}

