/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf3DTransMatrix;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf3PDUNames;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfNumbersGeneral;
import org.verapdf.gf.model.impl.arlington.GFAGeographicCoordinateSystem;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAProjectedCoordinateSystem;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOf3DTransMatrix;
import org.verapdf.model.alayer.AArrayOf3PDUNames;
import org.verapdf.model.alayer.AArrayOfNumbersGeneral;
import org.verapdf.model.alayer.AMeasureGEO;

public class GFAMeasureGEO
extends GFAObject
implements AMeasureGEO {
    public GFAMeasureGEO(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AMeasureGEO");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Bounds": {
                return this.getBounds();
            }
            case "DCS": {
                return this.getDCS();
            }
            case "GCS": {
                return this.getGCS();
            }
            case "GPTS": {
                return this.getGPTS();
            }
            case "LPTS": {
                return this.getLPTS();
            }
            case "PCSM": {
                return this.getPCSM();
            }
            case "PDU": {
                return this.getPDU();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfNumbersGeneral> getBounds() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getBounds1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNumbersGeneral> getBounds1_7() {
        COSObject object = this.getBoundsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNumbersGeneral> list = new ArrayList<GFAArrayOfNumbersGeneral>(1);
            list.add(new GFAArrayOfNumbersGeneral((COSArray)object.getDirectBase(), this.baseObject, "Bounds"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDCS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDCS1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDCS1_7() {
        COSObject object = this.getDCSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDCSDictionary1_7(object.getDirectBase(), "DCS");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDCSDictionary1_7(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom("Type"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "GEOGCS": {
                return new GFAGeographicCoordinateSystem(base, this.baseObject, keyName);
            }
            case "PROJCS": {
                return new GFAProjectedCoordinateSystem(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getGCS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getGCS1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getGCS1_7() {
        COSObject object = this.getGCSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getGCSDictionary1_7(object.getDirectBase(), "GCS");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getGCSDictionary1_7(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom("Type"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "GEOGCS": {
                return new GFAGeographicCoordinateSystem(base, this.baseObject, keyName);
            }
            case "PROJCS": {
                return new GFAProjectedCoordinateSystem(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfNumbersGeneral> getGPTS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getGPTS1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNumbersGeneral> getGPTS1_7() {
        COSObject object = this.getGPTSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNumbersGeneral> list = new ArrayList<GFAArrayOfNumbersGeneral>(1);
            list.add(new GFAArrayOfNumbersGeneral((COSArray)object.getDirectBase(), this.baseObject, "GPTS"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNumbersGeneral> getLPTS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getLPTS1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNumbersGeneral> getLPTS1_7() {
        COSObject object = this.getLPTSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNumbersGeneral> list = new ArrayList<GFAArrayOfNumbersGeneral>(1);
            list.add(new GFAArrayOfNumbersGeneral((COSArray)object.getDirectBase(), this.baseObject, "LPTS"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DTransMatrix> getPCSM() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getPCSM2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DTransMatrix> getPCSM2_0() {
        COSObject object = this.getPCSMValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf3DTransMatrix> list = new ArrayList<GFAArrayOf3DTransMatrix>(1);
            list.add(new GFAArrayOf3DTransMatrix((COSArray)object.getDirectBase(), this.baseObject, "PCSM"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3PDUNames> getPDU() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getPDU1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3PDUNames> getPDU1_7() {
        COSObject object = this.getPDUValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf3PDUNames> list = new ArrayList<GFAArrayOf3PDUNames>(1);
            list.add(new GFAArrayOf3PDUNames((COSArray)object.getDirectBase(), this.baseObject, "PDU"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsBounds() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Bounds"));
    }

    public COSObject getBoundsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Bounds"));
        return object;
    }

    @Override
    public String getBoundsType() {
        COSObject Bounds = this.getBoundsValue();
        return this.getObjectType(Bounds);
    }

    @Override
    public Boolean getBoundsHasTypeArray() {
        COSObject Bounds = this.getBoundsValue();
        return GFAMeasureGEO.getHasTypeArray(Bounds);
    }

    @Override
    public Boolean getcontainsDCS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DCS"));
    }

    public COSObject getDCSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DCS"));
        return object;
    }

    @Override
    public String getDCSType() {
        COSObject DCS = this.getDCSValue();
        return this.getObjectType(DCS);
    }

    @Override
    public Boolean getDCSHasTypeDictionary() {
        COSObject DCS = this.getDCSValue();
        return GFAMeasureGEO.getHasTypeDictionary(DCS);
    }

    @Override
    public Boolean getcontainsGCS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("GCS"));
    }

    public COSObject getGCSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("GCS"));
        return object;
    }

    @Override
    public String getGCSType() {
        COSObject GCS = this.getGCSValue();
        return this.getObjectType(GCS);
    }

    @Override
    public Boolean getGCSHasTypeDictionary() {
        COSObject GCS = this.getGCSValue();
        return GFAMeasureGEO.getHasTypeDictionary(GCS);
    }

    @Override
    public Boolean getcontainsGPTS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("GPTS"));
    }

    public COSObject getGPTSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("GPTS"));
        return object;
    }

    @Override
    public String getGPTSType() {
        COSObject GPTS = this.getGPTSValue();
        return this.getObjectType(GPTS);
    }

    @Override
    public Boolean getGPTSHasTypeArray() {
        COSObject GPTS = this.getGPTSValue();
        return GFAMeasureGEO.getHasTypeArray(GPTS);
    }

    @Override
    public Boolean getcontainsLPTS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("LPTS"));
    }

    public COSObject getLPTSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("LPTS"));
        return object;
    }

    @Override
    public String getLPTSType() {
        COSObject LPTS = this.getLPTSValue();
        return this.getObjectType(LPTS);
    }

    @Override
    public Boolean getLPTSHasTypeArray() {
        COSObject LPTS = this.getLPTSValue();
        return GFAMeasureGEO.getHasTypeArray(LPTS);
    }

    @Override
    public Boolean getcontainsPCSM() {
        return this.baseObject.knownKey(ASAtom.getASAtom("PCSM"));
    }

    public COSObject getPCSMValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("PCSM"));
        return object;
    }

    @Override
    public String getPCSMType() {
        COSObject PCSM = this.getPCSMValue();
        return this.getObjectType(PCSM);
    }

    @Override
    public Boolean getPCSMHasTypeArray() {
        COSObject PCSM = this.getPCSMValue();
        return GFAMeasureGEO.getHasTypeArray(PCSM);
    }

    @Override
    public Boolean getcontainsPDU() {
        return this.baseObject.knownKey(ASAtom.getASAtom("PDU"));
    }

    public COSObject getPDUValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("PDU"));
        return object;
    }

    @Override
    public String getPDUType() {
        COSObject PDU = this.getPDUValue();
        return this.getObjectType(PDU);
    }

    @Override
    public Boolean getPDUHasTypeArray() {
        COSObject PDU = this.getPDUValue();
        return GFAMeasureGEO.getHasTypeArray(PDU);
    }

    @Override
    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Subtype"));
        return object;
    }

    @Override
    public String getSubtypeType() {
        COSObject Subtype = this.getSubtypeValue();
        return this.getObjectType(Subtype);
    }

    @Override
    public Boolean getSubtypeHasTypeName() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAMeasureGEO.getHasTypeName(Subtype);
    }

    @Override
    public String getSubtypeNameValue() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAMeasureGEO.getNameValue(Subtype);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAMeasureGEO.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAMeasureGEO.getNameValue(Type2);
    }
}

