/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSIndirect;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSNull;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.cos.COSString;
import org.verapdf.exceptions.VeraPDFParserException;
import org.verapdf.io.InternalInputStream;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.parser.BaseParser;
import org.verapdf.parser.Token;
import org.verapdf.pd.encryption.StandardSecurityHandler;
import org.verapdf.tools.resource.ASFileStreamCloser;

public class COSParser
extends BaseParser {
    private static final Logger LOGGER = Logger.getLogger(COSParser.class.getCanonicalName());
    protected final int LINEARIZATION_DICTIONARY_LOOKUP_SIZE = 1024;
    protected COSDocument document;
    protected Queue<COSObject> objects = new LinkedList<COSObject>();
    protected Queue<Long> integers = new LinkedList<Long>();
    protected COSKey keyOfCurrentObject;
    protected boolean flag = true;

    public COSParser(SeekableInputStream seekableInputStream) throws IOException {
        super(seekableInputStream);
    }

    public COSParser(String filename) throws IOException {
        super(filename);
    }

    public COSParser(InputStream fileStream) throws IOException {
        super(fileStream);
    }

    public COSParser(COSDocument document, String filename) throws IOException {
        this(filename);
        this.document = document;
    }

    public COSParser(COSDocument document, InputStream fileStream) throws IOException {
        this(fileStream);
        this.document = document;
    }

    public COSObject nextObject() throws IOException {
        if (!this.objects.isEmpty()) {
            COSObject result = this.objects.peek();
            this.objects.remove();
            return result;
        }
        if (this.flag) {
            this.initializeToken();
            this.nextToken();
        }
        this.flag = true;
        Token token = this.getToken();
        if (token.type == Token.Type.TT_INTEGER) {
            this.integers.add(token.integer);
            if (this.integers.size() == 3) {
                COSObject result = COSInteger.construct(this.integers.peek());
                this.integers.remove();
                return result;
            }
            return this.nextObject();
        }
        if (token.type == Token.Type.TT_KEYWORD && token.keyword == Token.Keyword.KW_R && this.integers.size() == 2) {
            int number = this.integers.peek().intValue();
            this.integers.remove();
            int generation = this.integers.peek().intValue();
            this.integers.remove();
            return COSIndirect.construct(new COSKey(number, generation), this.document);
        }
        if (!this.integers.isEmpty()) {
            COSObject result = COSInteger.construct(this.integers.peek());
            this.integers.remove();
            while (!this.integers.isEmpty()) {
                this.objects.add(COSInteger.construct(this.integers.peek()));
                this.integers.remove();
            }
            this.flag = false;
            return result;
        }
        block0 : switch (token.type) {
            case TT_NONE: {
                break;
            }
            case TT_KEYWORD: {
                if (token.keyword == null) break;
                switch (token.keyword) {
                    case KW_NONE: {
                        break block0;
                    }
                    case KW_NULL: {
                        return COSNull.construct();
                    }
                    case KW_TRUE: {
                        return COSBoolean.construct(true);
                    }
                    case KW_FALSE: {
                        return COSBoolean.construct(false);
                    }
                }
                break;
            }
            case TT_INTEGER: {
                break;
            }
            case TT_REAL: {
                return COSReal.construct(token.real);
            }
            case TT_LITSTRING: {
                return COSString.construct(token.getByteValue());
            }
            case TT_HEXSTRING: {
                COSObject res = COSString.construct(token.getByteValue(), true, token.getHexCount(), token.isContainsOnlyHex());
                if (this.document == null || !this.document.isEncrypted()) {
                    return res;
                }
                return this.decryptCOSString(res);
            }
            case TT_NAME: {
                return COSName.construct(token.getValue());
            }
            case TT_OPENARRAY: {
                this.flag = false;
                return this.getArray();
            }
            case TT_CLOSEARRAY: {
                return new COSObject();
            }
            case TT_OPENDICT: {
                this.flag = false;
                return this.getDictionary();
            }
            case TT_CLOSEDICT: {
                return new COSObject();
            }
            case TT_EOF: {
                return new COSObject();
            }
        }
        return new COSObject();
    }

    protected COSObject getArray() throws IOException {
        if (this.flag) {
            this.nextToken();
        }
        this.flag = true;
        Token token = this.getToken();
        if (token.type != Token.Type.TT_OPENARRAY) {
            return new COSObject();
        }
        COSObject arr = COSArray.construct();
        COSObject obj = this.nextObject();
        while (!obj.empty()) {
            arr.add(obj);
            obj = this.nextObject();
        }
        if (token.type != Token.Type.TT_CLOSEARRAY) {
            throw new IOException(this.getErrorMessage("invalid pdf array"));
        }
        return arr;
    }

    protected COSObject getName() throws IOException {
        if (this.flag) {
            this.nextToken();
        }
        this.flag = true;
        Token token = this.getToken();
        if (token.type != Token.Type.TT_NAME) {
            return new COSObject();
        }
        return COSName.construct(token.getValue());
    }

    protected COSObject getDictionary() throws IOException {
        if (this.flag) {
            this.nextToken();
        }
        this.flag = true;
        Token token = this.getToken();
        if (token.type != Token.Type.TT_OPENDICT) {
            return new COSObject();
        }
        COSObject dict = COSDictionary.construct();
        COSObject key = this.getName();
        while (!key.empty()) {
            COSObject obj = this.nextObject();
            if (dict.getKeySet().contains(key.getName())) {
                LOGGER.log(Level.WARNING, this.getErrorMessage("Dictionary/Stream contains duplicated key " + key));
            }
            dict.setKey(key.getName(), obj);
            key = this.getName();
        }
        if (token.type != Token.Type.TT_CLOSEDICT) {
            throw new IOException(this.getErrorMessage("invalid pdf dictonary"));
        }
        long reset = this.source.getOffset();
        if (this.flag) {
            this.nextToken();
        }
        this.flag = false;
        if (token.type == Token.Type.TT_KEYWORD && token.keyword == Token.Keyword.KW_STREAM) {
            return this.getStream(dict);
        }
        this.source.seek(reset);
        this.flag = true;
        return dict;
    }

    protected COSObject getStream(COSObject dict) throws IOException {
        if (this.flag) {
            this.nextToken();
        }
        this.flag = true;
        Token token = this.getToken();
        if (token.type != Token.Type.TT_KEYWORD || token.keyword != Token.Keyword.KW_STREAM) {
            this.flag = false;
            return dict;
        }
        this.checkStreamSpacings(dict);
        long streamStartOffset = this.source.getOffset();
        COSObject length = dict.getKey(ASAtom.LENGTH);
        if (this.keyOfCurrentObject != null && length.isIndirect().booleanValue() && this.keyOfCurrentObject.equals(length.getKey())) {
            throw new VeraPDFParserException(this.getErrorMessage("Object has stream length value which references to its own object key"));
        }
        Long size = length.getInteger();
        this.source.seek(streamStartOffset);
        boolean streamLengthValid = this.checkStreamLength(size);
        if (streamLengthValid) {
            dict.setRealStreamSize(size);
            ASInputStream stm = super.getRandomAccess(size);
            dict.setData(stm);
            if (stm instanceof InternalInputStream) {
                this.document.addFileResource(new ASFileStreamCloser(stm));
            }
        } else {
            long realStreamSize = -1L;
            int bufferLength = 512;
            byte[] buffer = new byte[bufferLength];
            int eolLength = 0;
            boolean isPrevCR = false;
            block0: while (realStreamSize == -1L && !this.source.isEOF()) {
                long bytesRead = this.source.read(buffer, bufferLength);
                int i = 0;
                while ((long)i < bytesRead) {
                    if (buffer[i] == 101) {
                        long reset = this.source.getOffset();
                        long possibleEndStreamOffset = reset - bytesRead + (long)i - (long)eolLength;
                        this.source.seek(possibleEndStreamOffset);
                        this.nextToken();
                        if (token.type == Token.Type.TT_KEYWORD && token.keyword == Token.Keyword.KW_ENDSTREAM) {
                            realStreamSize = possibleEndStreamOffset - streamStartOffset;
                            dict.setRealStreamSize(realStreamSize);
                            this.source.seek(streamStartOffset);
                            ASInputStream stm = super.getRandomAccess(realStreamSize);
                            dict.setData(stm);
                            this.source.seek(possibleEndStreamOffset);
                            if (!(stm instanceof InternalInputStream)) continue block0;
                            this.document.addFileResource(new ASFileStreamCloser(stm));
                            continue block0;
                        }
                        this.source.seek(reset);
                    }
                    if (COSParser.isCR(buffer[i])) {
                        eolLength = 1;
                        isPrevCR = true;
                    } else {
                        eolLength = COSParser.isLF(buffer[i]) ? (isPrevCR ? 2 : 1) : 0;
                        isPrevCR = false;
                    }
                    ++i;
                }
            }
            if (realStreamSize == -1L) {
                throw new IOException(this.getErrorMessage("End of stream is not found"));
            }
        }
        this.checkEndstreamSpacings(dict, streamStartOffset, size);
        return dict;
    }

    private void checkStreamSpacings(COSObject stream) throws IOException {
        byte whiteSpace = this.source.readByte();
        if (COSParser.isCR(whiteSpace)) {
            whiteSpace = this.source.readByte();
            if (!COSParser.isLF(whiteSpace)) {
                stream.setStreamKeywordCRLFCompliant(false);
                this.source.unread();
            }
        } else if (!COSParser.isLF(whiteSpace)) {
            LOGGER.log(Level.WARNING, this.getErrorMessage("Stream has no EOL marker."));
            stream.setStreamKeywordCRLFCompliant(false);
            this.source.unread();
        }
    }

    private boolean checkStreamLength(Long streamLength) throws IOException {
        if (streamLength == null) {
            LOGGER.log(Level.WARNING, this.getErrorMessage("Stream length is missing"));
            return false;
        }
        boolean validLength = true;
        long start = this.source.getOffset();
        long expectedEndstreamOffset = start + streamLength;
        if (expectedEndstreamOffset > this.source.getStreamLength()) {
            validLength = false;
            LOGGER.log(Level.WARNING, this.getErrorMessage("Couldn't find expected endstream keyword", expectedEndstreamOffset));
        } else {
            this.source.seek(expectedEndstreamOffset);
            this.nextToken();
            Token token = this.getToken();
            if (token.type != Token.Type.TT_KEYWORD || token.keyword != Token.Keyword.KW_ENDSTREAM) {
                validLength = false;
                LOGGER.log(Level.WARNING, this.getErrorMessage("Couldn't find expected endstream keyword", expectedEndstreamOffset));
            }
            this.source.seek(start);
        }
        return validLength;
    }

    private void checkEndstreamSpacings(COSObject stream, long streamStartOffset, Long expectedLength) throws IOException {
        this.skipSpaces();
        byte eolCount = 0;
        long approximateLength = this.source.getOffset() - streamStartOffset;
        long expected = expectedLength == null ? 0L : expectedLength;
        long diff = approximateLength - expected;
        this.source.unread(2);
        byte firstSymbol = this.source.readByte();
        byte secondSymbol = this.source.readByte();
        if (secondSymbol == 10) {
            eolCount = firstSymbol == 13 ? (byte)(diff > 1L ? 2 : 1) : (byte)1;
        } else if (secondSymbol == 13) {
            eolCount = 1;
        } else {
            LOGGER.log(Level.FINE, this.getErrorMessage("End of stream doesn't contain EOL marker."));
            stream.setEndstreamKeywordCRLFCompliant(false);
        }
        stream.setRealStreamSize(approximateLength - (long)eolCount);
        this.nextToken();
    }

    public COSDocument getDocument() {
        return this.document;
    }

    private COSObject decryptCOSString(COSObject string) {
        StandardSecurityHandler ssh = this.document.getStandardSecurityHandler();
        try {
            ssh.decryptString((COSString)string.getDirectBase(), this.keyOfCurrentObject);
            return string;
        }
        catch (IOException | GeneralSecurityException e) {
            LOGGER.log(Level.WARNING, this.getErrorMessage("Can't decrypt string in object"));
            return string;
        }
    }

    @Override
    protected String getErrorMessage(String message) {
        if (this.keyOfCurrentObject != null) {
            return message + "(object key = " + this.keyOfCurrentObject + ", offset = " + this.source.getCurrentOffset() + ")";
        }
        return super.getErrorMessage(message);
    }
}

