/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfRichMediaCuePoints;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfRichMediaCuePoints;
import org.verapdf.model.alayer.ARichMediaParams;
import org.verapdf.model.alayer.AStream;
import org.verapdf.model.baselayer.Object;

public class GFARichMediaParams
extends GFAObject
implements ARichMediaParams {
    public GFARichMediaParams(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARichMediaParams");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CuePoints": {
                return this.getCuePoints();
            }
            case "FlashVars": {
                return this.getFlashVars();
            }
            case "Settings": {
                return this.getSettings();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfRichMediaCuePoints> getCuePoints() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCuePoints1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfRichMediaCuePoints> getCuePoints1_7() {
        COSObject object = this.getCuePointsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfRichMediaCuePoints> list = new ArrayList<GFAArrayOfRichMediaCuePoints>(1);
            list.add(new GFAArrayOfRichMediaCuePoints((COSArray)object.getDirectBase(), this.baseObject, "CuePoints"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getFlashVars() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFlashVars1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getFlashVars1_7() {
        COSObject object = this.getFlashVarsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "FlashVars"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getSettings() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getSettings1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getSettings1_7() {
        COSObject object = this.getSettingsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "Settings"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsBinding() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Binding"));
    }

    public COSObject getBindingDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("None");
            }
        }
        return null;
    }

    public COSObject getBindingValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Binding"));
        if (object == null || object.empty()) {
            object = this.getBindingDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getBindingHasTypeName() {
        COSObject object = this.getBindingValue();
        return GFARichMediaParams.getHasTypeName(object);
    }

    @Override
    public String getBindingNameValue() {
        COSObject object = this.getBindingValue();
        return GFARichMediaParams.getNameValue(object);
    }

    @Override
    public Boolean getcontainsBindingMaterial() {
        return this.baseObject.knownKey(ASAtom.getASAtom("BindingMaterial"));
    }

    public COSObject getBindingMaterialValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("BindingMaterial"));
        return object;
    }

    @Override
    public Boolean getBindingMaterialHasTypeStringText() {
        COSObject object = this.getBindingMaterialValue();
        return GFARichMediaParams.getHasTypeStringText(object);
    }

    @Override
    public Boolean getcontainsCuePoints() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CuePoints"));
    }

    public COSObject getCuePointsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CuePoints"));
        return object;
    }

    @Override
    public Boolean getCuePointsHasTypeArray() {
        COSObject object = this.getCuePointsValue();
        return GFARichMediaParams.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsFlashVars() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FlashVars"));
    }

    public COSObject getFlashVarsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FlashVars"));
        return object;
    }

    @Override
    public Boolean getisFlashVarsIndirect() {
        COSObject object = this.getFlashVarsValue();
        return GFARichMediaParams.getisIndirect(object);
    }

    @Override
    public Boolean getFlashVarsHasTypeStream() {
        COSObject object = this.getFlashVarsValue();
        return GFARichMediaParams.getHasTypeStream(object);
    }

    @Override
    public Boolean getFlashVarsHasTypeStringText() {
        COSObject object = this.getFlashVarsValue();
        return GFARichMediaParams.getHasTypeStringText(object);
    }

    @Override
    public Boolean getcontainsSettings() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Settings"));
    }

    public COSObject getSettingsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Settings"));
        return object;
    }

    @Override
    public Boolean getisSettingsIndirect() {
        COSObject object = this.getSettingsValue();
        return GFARichMediaParams.getisIndirect(object);
    }

    @Override
    public Boolean getSettingsHasTypeStream() {
        COSObject object = this.getSettingsValue();
        return GFARichMediaParams.getHasTypeStream(object);
    }

    @Override
    public Boolean getSettingsHasTypeStringText() {
        COSObject object = this.getSettingsValue();
        return GFARichMediaParams.getHasTypeStringText(object);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFARichMediaParams.getHasTypeName(object);
    }

    @Override
    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        return GFARichMediaParams.getNameValue(object);
    }

    @Override
    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }
}

