/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfSoftwareVersions;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStringsByte;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfSoftwareVersions;
import org.verapdf.model.alayer.AArrayOfStringsByte;
import org.verapdf.model.alayer.ASoftwareIdentifier;
import org.verapdf.model.baselayer.Object;

public class GFASoftwareIdentifier
extends GFAObject
implements ASoftwareIdentifier {
    public GFASoftwareIdentifier(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ASoftwareIdentifier");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "H": {
                return this.getH();
            }
            case "L": {
                return this.getL();
            }
            case "OS": {
                return this.getOS();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfSoftwareVersions> getH() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getH1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfSoftwareVersions> getH1_5() {
        COSObject object = this.getHValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfSoftwareVersions> list = new ArrayList<GFAArrayOfSoftwareVersions>(1);
            list.add(new GFAArrayOfSoftwareVersions((COSArray)object.getDirectBase(), this.baseObject, "H"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfSoftwareVersions> getL() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getL1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfSoftwareVersions> getL1_5() {
        COSObject object = this.getLValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfSoftwareVersions> list = new ArrayList<GFAArrayOfSoftwareVersions>(1);
            list.add(new GFAArrayOfSoftwareVersions((COSArray)object.getDirectBase(), this.baseObject, "L"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getOS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getOS1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getOS1_5() {
        COSObject object = this.getOSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsByte> list = new ArrayList<GFAArrayOfStringsByte>(1);
            list.add(new GFAArrayOfStringsByte((COSArray)object.getDirectBase(), this.baseObject, "OS"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsH() {
        return this.baseObject.knownKey(ASAtom.getASAtom("H"));
    }

    public COSObject getHValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("H"));
        return object;
    }

    @Override
    public Boolean getHHasTypeArray() {
        COSObject object = this.getHValue();
        return GFASoftwareIdentifier.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsHI() {
        return this.baseObject.knownKey(ASAtom.getASAtom("HI"));
    }

    public COSObject getHIDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct(true);
            }
        }
        return null;
    }

    public COSObject getHIValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("HI"));
        if (object == null || object.empty()) {
            object = this.getHIDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getHIHasTypeBoolean() {
        COSObject object = this.getHIValue();
        return GFASoftwareIdentifier.getHasTypeBoolean(object);
    }

    @Override
    public Boolean getcontainsL() {
        return this.baseObject.knownKey(ASAtom.getASAtom("L"));
    }

    public COSObject getLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("L"));
        return object;
    }

    @Override
    public Boolean getLHasTypeArray() {
        COSObject object = this.getLValue();
        return GFASoftwareIdentifier.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsLI() {
        return this.baseObject.knownKey(ASAtom.getASAtom("LI"));
    }

    public COSObject getLIDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct(true);
            }
        }
        return null;
    }

    public COSObject getLIValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("LI"));
        if (object == null || object.empty()) {
            object = this.getLIDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getLIHasTypeBoolean() {
        COSObject object = this.getLIValue();
        return GFASoftwareIdentifier.getHasTypeBoolean(object);
    }

    @Override
    public Boolean getcontainsOS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("OS"));
    }

    public COSObject getOSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OS"));
        return object;
    }

    @Override
    public Boolean getOSHasTypeArray() {
        COSObject object = this.getOSValue();
        return GFASoftwareIdentifier.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFASoftwareIdentifier.getHasTypeName(object);
    }

    @Override
    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    @Override
    public Boolean getcontainsU() {
        return this.baseObject.knownKey(ASAtom.getASAtom("U"));
    }

    public COSObject getUValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("U"));
        return object;
    }

    @Override
    public Boolean getUHasTypeStringAscii() {
        COSObject object = this.getUValue();
        return GFASoftwareIdentifier.getHasTypeStringAscii(object);
    }
}

