/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARichMediaParams;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.ARichMediaInstance;
import org.verapdf.model.alayer.ARichMediaParams;
import org.verapdf.model.baselayer.Object;

public class GFARichMediaInstance
extends GFAObject
implements ARichMediaInstance {
    public GFARichMediaInstance(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARichMediaInstance");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Asset": {
                return this.getAsset();
            }
            case "Params": {
                return this.getParams();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AFileSpecification> getAsset() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAsset1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getAsset1_7() {
        COSObject object = this.getAssetValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSDictionary)object.getDirectBase(), this.baseObject, "Asset"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ARichMediaParams> getParams() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getParams1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<ARichMediaParams> getParams1_7() {
        COSObject object = this.getParamsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARichMediaParams> list = new ArrayList<GFARichMediaParams>(1);
            list.add(new GFARichMediaParams((COSDictionary)object.getDirectBase(), this.baseObject, "Params"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsAsset() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Asset"));
    }

    public COSObject getAssetValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Asset"));
        return object;
    }

    @Override
    public Boolean getAssetHasTypeDictionary() {
        COSObject object = this.getAssetValue();
        return GFARichMediaInstance.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsParams() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Params"));
    }

    public COSObject getParamsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Params"));
        return object;
    }

    @Override
    public Boolean getParamsHasTypeDictionary() {
        COSObject object = this.getParamsValue();
        return GFARichMediaInstance.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsScene() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Scene"));
    }

    public COSObject getSceneValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Scene"));
        return object;
    }

    @Override
    public Boolean getSceneHasTypeInteger() {
        COSObject object = this.getSceneValue();
        return GFARichMediaInstance.getHasTypeInteger(object);
    }

    @Override
    public Long getSceneIntegerValue() {
        COSObject object = this.getSceneValue();
        return GFARichMediaInstance.getIntegerValue(object);
    }

    @Override
    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Subtype"));
        return object;
    }

    @Override
    public Boolean getSubtypeHasTypeName() {
        COSObject object = this.getSubtypeValue();
        return GFARichMediaInstance.getHasTypeName(object);
    }

    @Override
    public String getSubtypeNameValue() {
        COSObject object = this.getSubtypeValue();
        return GFARichMediaInstance.getNameValue(object);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFARichMediaInstance.getHasTypeName(object);
    }

    @Override
    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        return GFARichMediaInstance.getNameValue(object);
    }

    @Override
    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }

    @Override
    public Boolean gethasExtensionISO_TS_32007() {
        return false;
    }
}

