/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class MiniLogoPanel
extends JPanel {
    private static final long serialVersionUID = -199053265127458738L;

    MiniLogoPanel(String arlingtonlogoPath) throws IOException {
        this.setLayout(new FlowLayout(0));
        this.addLogo(arlingtonlogoPath, "     Choose a PDF and a PDF flavour or custom profile, then press \"Execute\"", 0.5);
    }

    private void addLogo(String logoPath, String text, final double scale) throws IOException {
        JLabel label = new JLabel(text);
        label.setToolTipText("<html>PDF flavour: arlington part<br>Validation profile: custom collection of validation rules</html>");
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(logoPath);){
            final BufferedImage image = ImageIO.read(is);
            Icon icon = new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    g.drawImage(image, 0, 0, this.getIconWidth(), this.getIconHeight(), 0, 0, image.getWidth(), image.getHeight(), null);
                }

                @Override
                public int getIconWidth() {
                    return (int)((double)image.getWidth() * scale);
                }

                @Override
                public int getIconHeight() {
                    return (int)((double)image.getHeight() * scale);
                }
            };
            label.setIcon(icon);
        }
        this.add(label);
    }
}

