/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSString;
import org.verapdf.features.objects.DocSecurityFeaturesObjectAdapter;
import org.verapdf.pd.encryption.AccessPermissions;
import org.verapdf.pd.encryption.PDEncryption;

public class GFDocSecurityFeaturesObjectAdapter
implements DocSecurityFeaturesObjectAdapter {
    private PDEncryption encryption;

    public GFDocSecurityFeaturesObjectAdapter(PDEncryption encryption) {
        this.encryption = encryption;
    }

    @Override
    public String getFilter() {
        if (this.encryption == null || this.encryption.empty()) {
            return null;
        }
        ASAtom filter = this.encryption.getFilter();
        return filter == null ? null : filter.getValue();
    }

    @Override
    public String getSubFilter() {
        if (this.encryption == null || this.encryption.empty()) {
            return null;
        }
        ASAtom subFilter = this.encryption.getSubFilter();
        return subFilter == null ? null : subFilter.getValue();
    }

    @Override
    public int getVersion() {
        return this.encryption == null || this.encryption.empty() ? 0 : this.encryption.getV();
    }

    @Override
    public int getLength() {
        return this.encryption == null || this.encryption.empty() ? 0 : this.encryption.getLength();
    }

    @Override
    public String getHexEncodedOwnerKey() {
        COSString ownerKey;
        if (this.encryption != null && !this.encryption.empty() && (ownerKey = this.encryption.getO()) != null) {
            return ownerKey.getHexString();
        }
        return null;
    }

    @Override
    public String getHexEncodedUserKey() {
        COSString userKey;
        if (this.encryption != null && !this.encryption.empty() && (userKey = this.encryption.getU()) != null) {
            return userKey.getHexString();
        }
        return null;
    }

    @Override
    public boolean isEncryptMetadata() {
        return this.encryption == null || this.encryption.empty() || this.encryption.isEncryptMetadata();
    }

    @Override
    public boolean isUserPermissionsPresent() {
        return this.encryption != null && !this.encryption.empty() && this.encryption.getUserPermissions() != null;
    }

    @Override
    public boolean isPrintAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canPrint();
        }
        return true;
    }

    @Override
    public boolean isPrintDegradedAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canPrintDegraded();
        }
        return true;
    }

    @Override
    public boolean isChangesAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canModify();
        }
        return true;
    }

    @Override
    public boolean isModifyAnnotationsAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canModifyAnnotations();
        }
        return true;
    }

    @Override
    public boolean isFillingSigningAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canFillInForm();
        }
        return true;
    }

    @Override
    public boolean isDocumentAssemblyAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canAssembleDocument();
        }
        return true;
    }

    @Override
    public boolean isExtractContentAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canExtractContent();
        }
        return true;
    }

    @Override
    public boolean isExtractAccessibilityAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canExtractForAccessibility();
        }
        return true;
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.encryption != null && !this.encryption.empty();
    }

    @Override
    public List<String> getErrors() {
        return Collections.emptyList();
    }
}

