/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAEmbeddedFileStream;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AEmbeddedFileStream;
import org.verapdf.model.alayer.AFileSpecEF;
import org.verapdf.model.baselayer.Object;

public class GFAFileSpecEF
extends GFAObject
implements AFileSpecEF {
    public GFAFileSpecEF(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AFileSpecEF");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "F": {
                return this.getF();
            }
            case "UF": {
                return this.getUF();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AEmbeddedFileStream> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getF1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AEmbeddedFileStream> getF1_3() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAEmbeddedFileStream> list = new ArrayList<GFAEmbeddedFileStream>(1);
            list.add(new GFAEmbeddedFileStream((COSStream)object.getDirectBase(), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AEmbeddedFileStream> getUF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getUF1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AEmbeddedFileStream> getUF1_7() {
        COSObject object = this.getUFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAEmbeddedFileStream> list = new ArrayList<GFAEmbeddedFileStream>(1);
            list.add(new GFAEmbeddedFileStream((COSStream)object.getDirectBase(), this.baseObject, "UF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("F"));
        return object;
    }

    @Override
    public Boolean getisFIndirect() {
        COSObject F = this.getFValue();
        return GFAFileSpecEF.getisIndirect(F);
    }

    @Override
    public Boolean getFHasTypeStream() {
        COSObject F = this.getFValue();
        return GFAFileSpecEF.getHasTypeStream(F);
    }

    @Override
    public Boolean getcontainsUF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("UF"));
    }

    public COSObject getUFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("UF"));
        return object;
    }

    @Override
    public Boolean getisUFIndirect() {
        COSObject UF = this.getUFValue();
        return GFAFileSpecEF.getisIndirect(UF);
    }

    @Override
    public Boolean getUFHasTypeStream() {
        COSObject UF = this.getUFValue();
        return GFAFileSpecEF.getHasTypeStream(UF);
    }
}

