/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFASignature;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.APermissions;
import org.verapdf.model.alayer.ASignature;
import org.verapdf.model.baselayer.Object;

public class GFAPermissions
extends GFAObject
implements APermissions {
    public GFAPermissions(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "APermissions");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "DocMDP": {
                return this.getDocMDP();
            }
            case "UR3": {
                return this.getUR3();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ASignature> getDocMDP() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDocMDP1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ASignature> getDocMDP1_5() {
        COSObject object = this.getDocMDPValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFASignature> list = new ArrayList<GFASignature>(1);
            list.add(new GFASignature((COSDictionary)object.getDirectBase(), this.baseObject, "DocMDP"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ASignature> getUR3() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getUR31_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ASignature> getUR31_5() {
        COSObject object = this.getUR3Value();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFASignature> list = new ArrayList<GFASignature>(1);
            list.add(new GFASignature((COSDictionary)object.getDirectBase(), this.baseObject, "UR3"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsDocMDP() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DocMDP"));
    }

    public COSObject getDocMDPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DocMDP"));
        return object;
    }

    @Override
    public Boolean getisDocMDPIndirect() {
        COSObject DocMDP = this.getDocMDPValue();
        return GFAPermissions.getisIndirect(DocMDP);
    }

    @Override
    public Boolean getDocMDPHasTypeDictionary() {
        COSObject DocMDP = this.getDocMDPValue();
        return GFAPermissions.getHasTypeDictionary(DocMDP);
    }

    @Override
    public Boolean getcontainsUR3() {
        return this.baseObject.knownKey(ASAtom.getASAtom("UR3"));
    }

    public COSObject getUR3Value() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("UR3"));
        return object;
    }

    @Override
    public Boolean getUR3HasTypeDictionary() {
        COSObject UR3 = this.getUR3Value();
        return GFAPermissions.getHasTypeDictionary(UR3);
    }

    public COSObject getDocMDPReferenceValue() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject DocMDP = this.baseObject.getKey(ASAtom.getASAtom("DocMDP"));
        if (DocMDP == null || !DocMDP.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Reference2 = DocMDP.getKey(ASAtom.getASAtom("Reference"));
        return Reference2;
    }

    public COSObject getUR3Reference0TransformMethodValue() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject UR3 = this.baseObject.getKey(ASAtom.getASAtom("UR3"));
        if (UR3 == null || !UR3.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Reference2 = UR3.getKey(ASAtom.getASAtom("Reference"));
        if (Reference2 == null || Reference2.getType() != COSObjType.COS_ARRAY) {
            return null;
        }
        if (Reference2.size() <= 0) {
            return null;
        }
        COSObject entry0 = Reference2.at(0);
        if (entry0 == null || !entry0.getType().isDictionaryBased()) {
            return null;
        }
        COSObject TransformMethod = entry0.getKey(ASAtom.getASAtom("TransformMethod"));
        return TransformMethod;
    }

    @Override
    public Long getDocMDPReferenceArraySize() {
        COSObject DocMDPReference = this.getDocMDPReferenceValue();
        return GFAPermissions.getArraySize(DocMDPReference);
    }

    @Override
    public String getUR3Reference0TransformMethodNameValue() {
        COSObject UR3Reference0TransformMethod = this.getUR3Reference0TransformMethodValue();
        return GFAPermissions.getNameValue(UR3Reference0TransformMethod);
    }

    @Override
    public Boolean getDocMDPReferenceHasTypeArray() {
        COSObject DocMDPReference = this.getDocMDPReferenceValue();
        return GFAPermissions.getHasTypeArray(DocMDPReference);
    }
}

