/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfArraysXPTSValues;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfNamesInPtData;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfArraysXPTSValues;
import org.verapdf.model.alayer.AArrayOfNamesInPtData;
import org.verapdf.model.alayer.APointData;
import org.verapdf.model.baselayer.Object;

public class GFAPointData
extends GFAObject
implements APointData {
    public GFAPointData(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "APointData");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Names": {
                return this.getNames();
            }
            case "XPTS": {
                return this.getXPTS();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfNamesInPtData> getNames() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getNames1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNamesInPtData> getNames1_7() {
        COSObject object = this.getNamesValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNamesInPtData> list = new ArrayList<GFAArrayOfNamesInPtData>(1);
            list.add(new GFAArrayOfNamesInPtData((COSArray)object.getDirectBase(), this.baseObject, "Names"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfArraysXPTSValues> getXPTS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getXPTS1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfArraysXPTSValues> getXPTS1_7() {
        COSObject object = this.getXPTSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfArraysXPTSValues> list = new ArrayList<GFAArrayOfArraysXPTSValues>(1);
            list.add(new GFAArrayOfArraysXPTSValues((COSArray)object.getDirectBase(), this.baseObject, "XPTS"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsNames() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Names"));
    }

    public COSObject getNamesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Names"));
        return object;
    }

    @Override
    public Boolean getNamesHasTypeArray() {
        COSObject Names = this.getNamesValue();
        return GFAPointData.getHasTypeArray(Names);
    }

    @Override
    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Subtype"));
        return object;
    }

    @Override
    public Boolean getSubtypeHasTypeName() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAPointData.getHasTypeName(Subtype);
    }

    @Override
    public String getSubtypeNameValue() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAPointData.getNameValue(Subtype);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAPointData.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAPointData.getNameValue(Type2);
    }

    @Override
    public Boolean getcontainsXPTS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("XPTS"));
    }

    public COSObject getXPTSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("XPTS"));
        return object;
    }

    @Override
    public Boolean getXPTSHasTypeArray() {
        COSObject XPTS = this.getXPTSValue();
        return GFAPointData.getHasTypeArray(XPTS);
    }

    @Override
    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }
}

