/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfIndirectFileSpecificationsEntry;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.baselayer.Object;
import org.verapdf.pd.PDNameTreeNode;

public class GFAArrayOfIndirectFileSpecificationsEntry
extends GFAObject
implements AArrayOfIndirectFileSpecificationsEntry {
    private final COSBase parentParentObject;
    private final String collectionName;

    public GFAArrayOfIndirectFileSpecificationsEntry(COSBase baseObject, COSBase parentObject, COSBase parentParentObject, String collectionName, String keyName) {
        super(baseObject, parentObject, keyName, "AArrayOfIndirectFileSpecificationsEntry");
        this.parentParentObject = parentParentObject;
        this.collectionName = collectionName;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entry": {
                return this.getEntry();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AFileSpecification> getEntry() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionADBE_Extn3().booleanValue()) {
                    return this.getEntry1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getEntry1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getEntry1_7() {
        COSObject object = new COSObject(this.baseObject);
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSDictionary)object.getDirectBase(), this.parentObject, this.keyName));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public COSObject getValue() {
        COSObject object = new COSObject(this.baseObject);
        return object;
    }

    @Override
    public Boolean getisIndirect() {
        COSObject entry = this.getValue();
        return GFAArrayOfIndirectFileSpecificationsEntry.getisIndirect(entry);
    }

    @Override
    public String getType() {
        COSObject entry = this.getValue();
        return this.getObjectType(entry);
    }

    @Override
    public Boolean getHasTypeDictionary() {
        COSObject entry = this.getValue();
        return GFAArrayOfIndirectFileSpecificationsEntry.getHasTypeDictionary(entry);
    }

    public COSObject getparentRichMediaContentAssetsValue() {
        if (this.parentParentObject == null || !this.parentParentObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject RichMediaContent = this.parentParentObject.getKey(ASAtom.getASAtom("RichMediaContent"));
        if (RichMediaContent == null || !RichMediaContent.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Assets = RichMediaContent.getKey(ASAtom.getASAtom("Assets"));
        return Assets;
    }

    @Override
    public Boolean getIsNameTreeparentRichMediaContentAssetsValue() {
        COSObject entry = this.getValue();
        COSObject parentRichMediaContentAssets = this.getparentRichMediaContentAssetsValue();
        if (entry == null) {
            return false;
        }
        if (parentRichMediaContentAssets == null || parentRichMediaContentAssets.getType() != COSObjType.COS_DICT) {
            return false;
        }
        PDNameTreeNode nameTreeNode = PDNameTreeNode.create(parentRichMediaContentAssets);
        return nameTreeNode.containsValue(entry);
    }
}

