/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFA3DAnimationStyle;
import org.verapdf.gf.model.impl.arlington.GFA3DStreamNameTreeResources;
import org.verapdf.gf.model.impl.arlington.GFA3DView;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf3DView;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfCompressionFilterNames;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfDecodeParams;
import org.verapdf.gf.model.impl.arlington.GFACalRGBColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAFilterCrypt;
import org.verapdf.gf.model.impl.arlington.GFAFilterFlateDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterLZWDecode;
import org.verapdf.gf.model.impl.arlington.GFAICCBasedColorSpace;
import org.verapdf.gf.model.impl.arlington.GFANameTreeNode;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.A3DAnimationStyle;
import org.verapdf.model.alayer.A3DStream;
import org.verapdf.model.alayer.A3DStreamNameTreeResources;
import org.verapdf.model.alayer.A3DView;
import org.verapdf.model.alayer.AArrayOf3DView;
import org.verapdf.model.alayer.AArrayOfCompressionFilterNames;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.ANameTreeNode;
import org.verapdf.model.alayer.AStream;

public class GFA3DStream
extends GFAObject
implements A3DStream {
    public GFA3DStream(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "A3DStream");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AN": {
                return this.getAN();
            }
            case "ColorSpace": {
                return this.getColorSpace();
            }
            case "DV": {
                return this.getDV();
            }
            case "DecodeParms": {
                return this.getDecodeParms();
            }
            case "F": {
                return this.getF();
            }
            case "FDecodeParms": {
                return this.getFDecodeParms();
            }
            case "FFilter": {
                return this.getFFilter();
            }
            case "Filter": {
                return this.getFilter();
            }
            case "OnInstantiate": {
                return this.getOnInstantiate();
            }
            case "Resources": {
                return this.getResources();
            }
            case "ResourcesTreeNode": {
                return this.getResourcesTreeNode();
            }
            case "VA": {
                return this.getVA();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<A3DAnimationStyle> getAN() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAN1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<A3DAnimationStyle> getAN1_7() {
        COSObject object = this.getANValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA3DAnimationStyle> list = new ArrayList<GFA3DAnimationStyle>(1);
            list.add(new GFA3DAnimationStyle((COSDictionary)object.getDirectBase(), this.baseObject, "AN"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getColorSpace() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getColorSpace2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getColorSpace2_0() {
        COSObject object = this.getColorSpaceValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            org.verapdf.model.baselayer.Object result = this.getColorSpaceArray2_0(object.getDirectBase(), "ColorSpace");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getColorSpaceArray2_0(COSBase base, String keyName) {
        String subtypeValue;
        if (base.size() <= 0) {
            return null;
        }
        COSObject subtype = base.at(0);
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CalRGB": {
                return new GFACalRGBColorSpace(base, this.baseObject, keyName);
            }
            case "ICCBased": {
                return new GFAICCBasedColorSpace(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<A3DView> getDV() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getDV1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<A3DView> getDV1_6() {
        COSObject object = this.getDVValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA3DView> list = new ArrayList<GFA3DView>(1);
            list.add(new GFA3DView((COSDictionary)object.getDirectBase(), this.baseObject, "DV"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getDecodeParms1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_6() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_6(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_6(COSBase base, String keyName) {
        String subtypeValue;
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AFileSpecification> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getF1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getF1_6() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSDictionary)object.getDirectBase(), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getFDecodeParms1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_6() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_6(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_6(COSBase base, String keyName) {
        String subtypeValue;
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("FFilter"));
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfCompressionFilterNames> getFFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getFFilter1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFFilter1_6() {
        COSObject object = this.getFFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSArray)object.getDirectBase(), this.baseObject, "FFilter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getFilter1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter1_6() {
        COSObject object = this.getFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSArray)object.getDirectBase(), this.baseObject, "Filter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getOnInstantiate() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getOnInstantiate1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getOnInstantiate1_6() {
        COSObject object = this.getOnInstantiateValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "OnInstantiate"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<A3DStreamNameTreeResources> getResources() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getResources1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<A3DStreamNameTreeResources> getResources1_6() {
        COSObject object = this.getResourcesValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA3DStreamNameTreeResources> list = new ArrayList<GFA3DStreamNameTreeResources>(1);
            list.add(new GFA3DStreamNameTreeResources((COSDictionary)object.getDirectBase(), this.baseObject, "Resources"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ANameTreeNode> getResourcesTreeNode() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getResourcesTreeNode1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<ANameTreeNode> getResourcesTreeNode1_6() {
        COSObject object = this.getResourcesTreeNodeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFANameTreeNode> list = new ArrayList<GFANameTreeNode>(1);
            list.add(new GFANameTreeNode((COSDictionary)object.getDirectBase(), this.baseObject, "ResourcesTreeNode"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DView> getVA() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getVA1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DView> getVA1_6() {
        COSObject object = this.getVAValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf3DView> list = new ArrayList<GFAArrayOf3DView>(1);
            list.add(new GFAArrayOf3DView((COSArray)object.getDirectBase(), this.baseObject, "VA"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsAN() {
        return this.baseObject.knownKey(ASAtom.getASAtom("AN"));
    }

    public COSObject getANValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("AN"));
        return object;
    }

    @Override
    public String getANType() {
        COSObject AN = this.getANValue();
        return this.getObjectType(AN);
    }

    @Override
    public Boolean getANHasTypeDictionary() {
        COSObject AN = this.getANValue();
        return GFA3DStream.getHasTypeDictionary(AN);
    }

    @Override
    public Boolean getcontainsColorSpace() {
        return this.baseObject.knownKey(ASAtom.getASAtom("ColorSpace"));
    }

    public COSObject getColorSpaceValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ColorSpace"));
        return object;
    }

    @Override
    public String getColorSpaceType() {
        COSObject ColorSpace2 = this.getColorSpaceValue();
        return this.getObjectType(ColorSpace2);
    }

    @Override
    public Boolean getColorSpaceHasTypeArray() {
        COSObject ColorSpace2 = this.getColorSpaceValue();
        return GFA3DStream.getHasTypeArray(ColorSpace2);
    }

    @Override
    public Boolean getColorSpaceHasTypeName() {
        COSObject ColorSpace2 = this.getColorSpaceValue();
        return GFA3DStream.getHasTypeName(ColorSpace2);
    }

    @Override
    public String getColorSpaceNameValue() {
        COSObject ColorSpace2 = this.getColorSpaceValue();
        return GFA3DStream.getNameValue(ColorSpace2);
    }

    @Override
    public Boolean getcontainsDL() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DL"));
    }

    public COSObject getDLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DL"));
        return object;
    }

    @Override
    public String getDLType() {
        COSObject DL = this.getDLValue();
        return this.getObjectType(DL);
    }

    @Override
    public Boolean getDLHasTypeInteger() {
        COSObject DL = this.getDLValue();
        return GFA3DStream.getHasTypeInteger(DL);
    }

    @Override
    public Long getDLIntegerValue() {
        COSObject DL = this.getDLValue();
        return GFA3DStream.getIntegerValue(DL);
    }

    @Override
    public Boolean getcontainsDV() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DV"));
    }

    public COSObject getDVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DV"));
        return object;
    }

    @Override
    public String getDVType() {
        COSObject DV = this.getDVValue();
        return this.getObjectType(DV);
    }

    @Override
    public Boolean getDVHasTypeDictionary() {
        COSObject DV = this.getDVValue();
        return GFA3DStream.getHasTypeDictionary(DV);
    }

    @Override
    public Boolean getDVHasTypeInteger() {
        COSObject DV = this.getDVValue();
        return GFA3DStream.getHasTypeInteger(DV);
    }

    @Override
    public Boolean getDVHasTypeName() {
        COSObject DV = this.getDVValue();
        return GFA3DStream.getHasTypeName(DV);
    }

    @Override
    public Boolean getDVHasTypeString() {
        COSObject DV = this.getDVValue();
        return GFA3DStream.getHasTypeString(DV);
    }

    @Override
    public Long getDVIntegerValue() {
        COSObject DV = this.getDVValue();
        return GFA3DStream.getIntegerValue(DV);
    }

    @Override
    public String getDVNameValue() {
        COSObject DV = this.getDVValue();
        return GFA3DStream.getNameValue(DV);
    }

    @Override
    public Boolean getcontainsDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DecodeParms"));
    }

    public COSObject getDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DecodeParms"));
        return object;
    }

    @Override
    public String getDecodeParmsType() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return this.getObjectType(DecodeParms);
    }

    @Override
    public Boolean getDecodeParmsHasTypeArray() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFA3DStream.getHasTypeArray(DecodeParms);
    }

    @Override
    public Boolean getDecodeParmsHasTypeDictionary() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFA3DStream.getHasTypeDictionary(DecodeParms);
    }

    @Override
    public Long getDecodeParmsArraySize() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFA3DStream.getArraySize(DecodeParms);
    }

    @Override
    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("F"));
        return object;
    }

    @Override
    public String getFType() {
        COSObject F = this.getFValue();
        return this.getObjectType(F);
    }

    @Override
    public Boolean getFHasTypeDictionary() {
        COSObject F = this.getFValue();
        return GFA3DStream.getHasTypeDictionary(F);
    }

    @Override
    public Boolean getFHasTypeString() {
        COSObject F = this.getFValue();
        return GFA3DStream.getHasTypeString(F);
    }

    @Override
    public Boolean getcontainsFDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FDecodeParms"));
    }

    public COSObject getFDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FDecodeParms"));
        return object;
    }

    @Override
    public String getFDecodeParmsType() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return this.getObjectType(FDecodeParms);
    }

    @Override
    public Boolean getFDecodeParmsHasTypeArray() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFA3DStream.getHasTypeArray(FDecodeParms);
    }

    @Override
    public Boolean getFDecodeParmsHasTypeDictionary() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFA3DStream.getHasTypeDictionary(FDecodeParms);
    }

    @Override
    public Long getFDecodeParmsArraySize() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFA3DStream.getArraySize(FDecodeParms);
    }

    @Override
    public Boolean getcontainsFFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FFilter"));
    }

    public COSObject getFFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FFilter"));
        return object;
    }

    @Override
    public String getFFilterType() {
        COSObject FFilter = this.getFFilterValue();
        return this.getObjectType(FFilter);
    }

    @Override
    public Boolean getFFilterHasTypeArray() {
        COSObject FFilter = this.getFFilterValue();
        return GFA3DStream.getHasTypeArray(FFilter);
    }

    @Override
    public Boolean getFFilterHasTypeName() {
        COSObject FFilter = this.getFFilterValue();
        return GFA3DStream.getHasTypeName(FFilter);
    }

    @Override
    public String getFFilterNameValue() {
        COSObject FFilter = this.getFFilterValue();
        return GFA3DStream.getNameValue(FFilter);
    }

    @Override
    public Long getFFilterArraySize() {
        COSObject FFilter = this.getFFilterValue();
        return GFA3DStream.getArraySize(FFilter);
    }

    @Override
    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        return object;
    }

    @Override
    public String getFilterType() {
        COSObject Filter2 = this.getFilterValue();
        return this.getObjectType(Filter2);
    }

    @Override
    public Boolean getFilterHasTypeArray() {
        COSObject Filter2 = this.getFilterValue();
        return GFA3DStream.getHasTypeArray(Filter2);
    }

    @Override
    public Boolean getFilterHasTypeName() {
        COSObject Filter2 = this.getFilterValue();
        return GFA3DStream.getHasTypeName(Filter2);
    }

    @Override
    public String getFilterNameValue() {
        COSObject Filter2 = this.getFilterValue();
        return GFA3DStream.getNameValue(Filter2);
    }

    @Override
    public Long getFilterArraySize() {
        COSObject Filter2 = this.getFilterValue();
        return GFA3DStream.getArraySize(Filter2);
    }

    @Override
    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Length"));
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Length"));
        return object;
    }

    @Override
    public String getLengthType() {
        COSObject Length = this.getLengthValue();
        return this.getObjectType(Length);
    }

    @Override
    public Boolean getLengthHasTypeInteger() {
        COSObject Length = this.getLengthValue();
        return GFA3DStream.getHasTypeInteger(Length);
    }

    @Override
    public Boolean getcontainsOnInstantiate() {
        return this.baseObject.knownKey(ASAtom.getASAtom("OnInstantiate"));
    }

    public COSObject getOnInstantiateValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OnInstantiate"));
        return object;
    }

    @Override
    public Boolean getisOnInstantiateIndirect() {
        COSObject OnInstantiate = this.getOnInstantiateValue();
        return GFA3DStream.getisIndirect(OnInstantiate);
    }

    @Override
    public String getOnInstantiateType() {
        COSObject OnInstantiate = this.getOnInstantiateValue();
        return this.getObjectType(OnInstantiate);
    }

    @Override
    public Boolean getOnInstantiateHasTypeStream() {
        COSObject OnInstantiate = this.getOnInstantiateValue();
        return GFA3DStream.getHasTypeStream(OnInstantiate);
    }

    @Override
    public Boolean getcontainsResources() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Resources"));
    }

    public COSObject getResourcesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Resources"));
        return object;
    }

    @Override
    public String getResourcesType() {
        COSObject Resources = this.getResourcesValue();
        return this.getObjectType(Resources);
    }

    @Override
    public Boolean getResourcesHasTypeNameTree() {
        COSObject Resources = this.getResourcesValue();
        return GFA3DStream.getHasTypeNameTree(Resources);
    }

    @Override
    public Boolean getcontainsResourcesTreeNode() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Resources"));
    }

    public COSObject getResourcesTreeNodeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Resources"));
        return object;
    }

    @Override
    public String getResourcesTreeNodeType() {
        COSObject ResourcesTreeNode = this.getResourcesTreeNodeValue();
        return this.getObjectType(ResourcesTreeNode);
    }

    @Override
    public Boolean getResourcesTreeNodeHasTypeNameTree() {
        COSObject ResourcesTreeNode = this.getResourcesTreeNodeValue();
        return GFA3DStream.getHasTypeNameTree(ResourcesTreeNode);
    }

    @Override
    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Subtype"));
        return object;
    }

    @Override
    public String getSubtypeType() {
        COSObject Subtype = this.getSubtypeValue();
        return this.getObjectType(Subtype);
    }

    @Override
    public Boolean getSubtypeHasTypeName() {
        COSObject Subtype = this.getSubtypeValue();
        return GFA3DStream.getHasTypeName(Subtype);
    }

    @Override
    public String getSubtypeNameValue() {
        COSObject Subtype = this.getSubtypeValue();
        return GFA3DStream.getNameValue(Subtype);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFA3DStream.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFA3DStream.getNameValue(Type2);
    }

    @Override
    public Boolean getcontainsVA() {
        return this.baseObject.knownKey(ASAtom.getASAtom("VA"));
    }

    public COSObject getVAValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("VA"));
        return object;
    }

    @Override
    public String getVAType() {
        COSObject VA = this.getVAValue();
        return this.getObjectType(VA);
    }

    @Override
    public Boolean getVAHasTypeArray() {
        COSObject VA = this.getVAValue();
        return GFA3DStream.getHasTypeArray(VA);
    }

    @Override
    public Long getVAArraySize() {
        COSObject VA = this.getVAValue();
        return GFA3DStream.getArraySize(VA);
    }
}

