/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFANameTreeNodeLimitsArray;
import org.verapdf.gf.model.impl.arlington.GFANameTreeNodeNamesArray;
import org.verapdf.gf.model.impl.arlington.GFANameTreeNodesArray;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ANameTreeNode;
import org.verapdf.model.alayer.ANameTreeNodeLimitsArray;
import org.verapdf.model.alayer.ANameTreeNodeNamesArray;
import org.verapdf.model.alayer.ANameTreeNodesArray;
import org.verapdf.model.baselayer.Object;

public class GFANameTreeNode
extends GFAObject
implements ANameTreeNode {
    public GFANameTreeNode(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ANameTreeNode");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Kids": {
                return this.getKids();
            }
            case "Limits": {
                return this.getLimits();
            }
            case "Names": {
                return this.getNames();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ANameTreeNodesArray> getKids() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getKids1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<ANameTreeNodesArray> getKids1_2() {
        COSObject object = this.getKidsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFANameTreeNodesArray> list = new ArrayList<GFANameTreeNodesArray>(1);
            list.add(new GFANameTreeNodesArray((COSArray)object.getDirectBase(), this.baseObject, "Kids"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ANameTreeNodeLimitsArray> getLimits() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getLimits1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<ANameTreeNodeLimitsArray> getLimits1_2() {
        COSObject object = this.getLimitsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFANameTreeNodeLimitsArray> list = new ArrayList<GFANameTreeNodeLimitsArray>(1);
            list.add(new GFANameTreeNodeLimitsArray((COSArray)object.getDirectBase(), this.baseObject, "Limits"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ANameTreeNodeNamesArray> getNames() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getNames1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<ANameTreeNodeNamesArray> getNames1_2() {
        COSObject object = this.getNamesValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFANameTreeNodeNamesArray> list = new ArrayList<GFANameTreeNodeNamesArray>(1);
            list.add(new GFANameTreeNodeNamesArray((COSArray)object.getDirectBase(), this.baseObject, "Names"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsKids() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Kids"));
    }

    public COSObject getKidsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Kids"));
        return object;
    }

    @Override
    public String getKidsType() {
        COSObject Kids = this.getKidsValue();
        return this.getObjectType(Kids);
    }

    @Override
    public Boolean getKidsHasTypeArray() {
        COSObject Kids = this.getKidsValue();
        return GFANameTreeNode.getHasTypeArray(Kids);
    }

    @Override
    public Boolean getcontainsLimits() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Limits"));
    }

    public COSObject getLimitsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Limits"));
        return object;
    }

    @Override
    public String getLimitsType() {
        COSObject Limits = this.getLimitsValue();
        return this.getObjectType(Limits);
    }

    @Override
    public Boolean getLimitsHasTypeArray() {
        COSObject Limits = this.getLimitsValue();
        return GFANameTreeNode.getHasTypeArray(Limits);
    }

    @Override
    public Boolean getcontainsNames() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Names"));
    }

    public COSObject getNamesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Names"));
        return object;
    }

    @Override
    public String getNamesType() {
        COSObject Names = this.getNamesValue();
        return this.getObjectType(Names);
    }

    @Override
    public Boolean getNamesHasTypeArray() {
        COSObject Names = this.getNamesValue();
        return GFANameTreeNode.getHasTypeArray(Names);
    }
}

