/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.regex.Pattern;
import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.functions.Round;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Whitespace;

public final class BigDecimalValue
extends DecimalValue {
    public static final int DIVIDE_PRECISION = 18;
    private final BigDecimal value;
    private double doubleValue = Double.NaN;
    public static final BigDecimal BIG_DECIMAL_ONE_MILLION = BigDecimal.valueOf(1000000L);
    public static final BigDecimal BIG_DECIMAL_ONE_BILLION = BigDecimal.valueOf(1000000000L);
    public static final BigDecimalValue ZERO = new BigDecimalValue(BigDecimal.valueOf(0L));
    public static final BigDecimalValue ONE = new BigDecimalValue(BigDecimal.valueOf(1L));
    public static final BigDecimalValue TWO = new BigDecimalValue(BigDecimal.valueOf(2L));
    public static final BigDecimalValue THREE = new BigDecimalValue(BigDecimal.valueOf(3L));
    public static final BigDecimal MAX_INT = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final Pattern decimalPattern = Pattern.compile("(\\-|\\+)?((\\.[0-9]+)|([0-9]+(\\.[0-9]*)?))");

    public BigDecimalValue(BigDecimal value) {
        super(BuiltInAtomicType.DECIMAL);
        this.value = value.stripTrailingZeros();
    }

    public BigDecimalValue(BigDecimal value, AtomicType typeLabel) {
        super(typeLabel);
        this.value = value.stripTrailingZeros();
    }

    public static ConversionResult makeDecimalValue(String in, boolean validate) {
        try {
            return BigDecimalValue.parse(in);
        }
        catch (NumberFormatException err) {
            ValidationFailure e = new ValidationFailure("Cannot convert string " + Err.wrap(in, 4) + " to xs:decimal: " + err.getMessage());
            e.setErrorCode("FORG0001");
            return e;
        }
    }

    public static BigDecimalValue parse(CharSequence in) throws NumberFormatException {
        StringBuilder digits = new StringBuilder(in.length());
        int scale = 0;
        int state = 0;
        boolean foundDigit = false;
        int len = in.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (state == 0) continue block7;
                    state = 5;
                    continue block7;
                }
                case '+': {
                    if (state != 0) {
                        throw new NumberFormatException("unexpected sign");
                    }
                    state = 1;
                    continue block7;
                }
                case '-': {
                    if (state != 0) {
                        throw new NumberFormatException("unexpected sign");
                    }
                    state = 1;
                    digits.append(c);
                    continue block7;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state == 0) {
                        state = 1;
                    } else if (state >= 3) {
                        ++scale;
                    }
                    if (state == 5) {
                        throw new NumberFormatException("contains embedded whitespace");
                    }
                    digits.append(c);
                    foundDigit = true;
                    continue block7;
                }
                case '.': {
                    if (state == 5) {
                        throw new NumberFormatException("contains embedded whitespace");
                    }
                    if (state >= 3) {
                        throw new NumberFormatException("more than one decimal point");
                    }
                    state = 3;
                    continue block7;
                }
                default: {
                    throw new NumberFormatException("invalid character '" + c + "'");
                }
            }
        }
        if (!foundDigit) {
            throw new NumberFormatException("no digits in value");
        }
        while (scale > 0 && digits.charAt(digits.length() - 1) == '0') {
            digits.setLength(digits.length() - 1);
            --scale;
        }
        if (digits.length() == 0 || digits.length() == 1 && digits.charAt(0) == '-') {
            return ZERO;
        }
        BigInteger bigInt = new BigInteger(digits.toString());
        BigDecimal bigDec = new BigDecimal(bigInt, scale);
        return new BigDecimalValue(bigDec);
    }

    public static boolean castableAsDecimal(String in) {
        String trimmed = Whitespace.trim(in).toString();
        return decimalPattern.matcher(trimmed).matches();
    }

    public BigDecimalValue(double in) throws ValidationException {
        super(BuiltInAtomicType.DECIMAL);
        try {
            BigDecimal d = new BigDecimal(in);
            this.value = d.stripTrailingZeros();
        }
        catch (Exception err) {
            ValidationFailure e = new ValidationFailure("Cannot convert double " + Err.wrap(in + "", 4) + " to decimal");
            e.setErrorCode("FOCA0002");
            throw e.makeException();
        }
    }

    public BigDecimalValue(long in) {
        super(BuiltInAtomicType.DECIMAL);
        this.value = BigDecimal.valueOf(in);
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        if (typeLabel.getPrimitiveItemType() == BuiltInAtomicType.INTEGER) {
            return IntegerValue.makeIntegerValue(this.value.toBigInteger()).copyAsSubType(typeLabel);
        }
        return new BigDecimalValue(this.value, typeLabel);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DECIMAL;
    }

    @Override
    public double getDoubleValue() {
        if (Double.isNaN(this.doubleValue)) {
            this.doubleValue = this.value.doubleValue();
        }
        return this.doubleValue;
    }

    @Override
    public float getFloatValue() {
        return (float)this.value.doubleValue();
    }

    @Override
    public long longValue() throws XPathException {
        return (long)this.value.doubleValue();
    }

    @Override
    public BigDecimal getDecimalValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        long longVal;
        BigDecimal round = this.value.setScale(0, RoundingMode.DOWN);
        try {
            longVal = round.longValue();
        }
        catch (Exception e) {
            longVal = Long.MAX_VALUE;
        }
        if (longVal > Integer.MIN_VALUE && longVal < Integer.MAX_VALUE) {
            return (int)longVal;
        }
        return Double.valueOf(this.getDoubleValue()).hashCode();
    }

    @Override
    public boolean effectiveBooleanValue() {
        return this.value.signum() != 0;
    }

    @Override
    public UnicodeString getCanonicalLexicalRepresentation() {
        UnicodeString s = this.getUnicodeStringValue().tidy();
        if (s.indexOf(46) < 0L) {
            s = s.concat(StringConstants.POINT_ZERO);
        }
        return s;
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        return BMPString.of(BigDecimalValue.decimalToString(this.value, new StringBuilder(16)).toString());
    }

    public static StringBuilder decimalToString(BigDecimal value, StringBuilder fsb) {
        int scale = value.scale();
        if (scale == 0) {
            fsb.append(value.toString());
            return fsb;
        }
        if (scale < 0) {
            String s = value.abs().unscaledValue().toString();
            if (s.equals("0")) {
                fsb.append('0');
                return fsb;
            }
            if (value.signum() < 0) {
                fsb.append('-');
            }
            fsb.append(s);
            for (int i = 0; i < -scale; ++i) {
                fsb.append('0');
            }
            return fsb;
        }
        String s = value.abs().unscaledValue().toString();
        if (s.equals("0")) {
            fsb.append('0');
            return fsb;
        }
        int len = s.length();
        if (value.signum() < 0) {
            fsb.append('-');
        }
        if (scale >= len) {
            fsb.append("0.");
            for (int i = len; i < scale; ++i) {
                fsb.append('0');
            }
            fsb.append(s);
        } else {
            fsb.append(s.substring(0, len - scale));
            fsb.append('.');
            fsb.append(s.substring(len - scale));
        }
        return fsb;
    }

    @Override
    public NumericValue negate() {
        return new BigDecimalValue(this.value.negate());
    }

    @Override
    public NumericValue floor() {
        return new BigDecimalValue(this.value.setScale(0, RoundingMode.FLOOR));
    }

    @Override
    public NumericValue ceiling() {
        return new BigDecimalValue(this.value.setScale(0, RoundingMode.CEILING));
    }

    @Override
    public NumericValue round(int scale) {
        if (scale >= this.value.scale()) {
            return this;
        }
        switch (this.value.signum()) {
            case -1: {
                return new BigDecimalValue(this.value.setScale(scale, RoundingMode.HALF_DOWN));
            }
            case 0: {
                return this;
            }
            case 1: {
                return new BigDecimalValue(this.value.setScale(scale, RoundingMode.HALF_UP));
            }
        }
        return this;
    }

    @Override
    public NumericValue round(int scale, Round.RoundingRule roundingRule) {
        BigDecimal scaledValue;
        if (scale >= this.value.scale()) {
            return this;
        }
        switch (roundingRule) {
            case FLOOR: {
                scaledValue = this.value.setScale(scale, RoundingMode.FLOOR);
                break;
            }
            case CEILING: {
                scaledValue = this.value.setScale(scale, RoundingMode.CEILING);
                break;
            }
            case AWAY_FROM_ZERO: {
                scaledValue = this.value.setScale(scale, RoundingMode.UP);
                break;
            }
            case TOWARD_ZERO: {
                scaledValue = this.value.setScale(scale, RoundingMode.DOWN);
                break;
            }
            case HALF_TO_FLOOR: {
                if (this.signum() >= 0) {
                    scaledValue = this.value.setScale(scale, RoundingMode.HALF_DOWN);
                    break;
                }
                scaledValue = this.value.setScale(scale, RoundingMode.HALF_UP);
                break;
            }
            default: {
                if (this.signum() >= 0) {
                    scaledValue = this.value.setScale(scale, RoundingMode.HALF_UP);
                    break;
                }
                scaledValue = this.value.setScale(scale, RoundingMode.HALF_DOWN);
                break;
            }
            case HALF_TOWARD_ZERO: {
                scaledValue = this.value.setScale(scale, RoundingMode.HALF_DOWN);
                break;
            }
            case HALF_AWAY_FROM_ZERO: {
                scaledValue = this.value.setScale(scale, RoundingMode.HALF_UP);
                break;
            }
            case HALF_TO_EVEN: {
                scaledValue = this.value.setScale(scale, RoundingMode.HALF_EVEN);
            }
        }
        return new BigDecimalValue(scaledValue.stripTrailingZeros());
    }

    @Override
    public int signum() {
        return this.value.signum();
    }

    @Override
    public boolean isWholeNumber() {
        return this.value.scale() == 0 || this.value.compareTo(this.value.setScale(0, RoundingMode.DOWN)) == 0;
    }

    @Override
    public int asSubscript() {
        if (this.isWholeNumber() && this.value.compareTo(BigDecimal.ZERO) > 0 && this.value.compareTo(MAX_INT) <= 0) {
            try {
                return (int)this.longValue();
            }
            catch (XPathException e) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public NumericValue abs() {
        if (this.value.signum() > 0) {
            return this;
        }
        return new BigDecimalValue(this.value.negate());
    }

    @Override
    public XPathComparable getXPathComparable(StringCollator collator, int implicitTimezone) {
        return this;
    }

    @Override
    public int compareTo(XPathComparable other) {
        if (other instanceof NumericValue) {
            if (NumericValue.isInteger((NumericValue)other)) {
                try {
                    return this.value.compareTo(((NumericValue)other).getDecimalValue());
                }
                catch (XPathException err) {
                    throw new AssertionError((Object)"Conversion of integer to decimal should never fail");
                }
            }
            if (other instanceof BigDecimalValue) {
                return this.value.compareTo(((BigDecimalValue)other).value);
            }
            if (other instanceof FloatValue) {
                return -other.compareTo(this);
            }
            return super.compareTo(other);
        }
        throw new ClassCastException("Cannot compare xs:decimal to " + other.toString());
    }

    @Override
    public int compareTo(long other) {
        if (other == 0L) {
            return this.value.signum();
        }
        return this.value.compareTo(BigDecimal.valueOf(other));
    }

    @Override
    public boolean isIdentical(AtomicValue v) {
        return v instanceof DecimalValue && this.equals(v);
    }
}

