/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import java.util.EnumSet;
import java.util.logging.Level;
import org.verapdf.extensions.ExtensionObjectType;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.pdfa.validation.validators.ValidatorConfigImpl;

public class ValidatorConfigBuilder {
    private PDFAFlavour flavour = PDFAFlavour.NO_FLAVOUR;
    private PDFAFlavour defaultFlavour = PDFAFlavour.ARLINGTON1_4;
    private boolean recordPasses = false;
    private int maxFails = -1;
    private boolean debug = false;
    private boolean showErrorMessages = true;
    private boolean isLogsEnabled = false;
    private Level loggingLevel = Level.WARNING;
    private int maxNumberOfDisplayedFailedChecks = 100;
    private String password = "";
    private boolean showProgress = false;
    private boolean nonPDFExtension = false;
    private EnumSet<ExtensionObjectType> enabledExtensions = EnumSet.noneOf(ExtensionObjectType.class);

    public ValidatorConfigBuilder password(String password) {
        this.password = password;
        return this;
    }

    public ValidatorConfigBuilder flavour(PDFAFlavour flavour) {
        this.flavour = flavour;
        return this;
    }

    public ValidatorConfigBuilder defaultFlavour(PDFAFlavour defaultFlavour) {
        this.defaultFlavour = defaultFlavour;
        return this;
    }

    public ValidatorConfigBuilder recordPasses(boolean recordPasses) {
        this.recordPasses = recordPasses;
        return this;
    }

    public ValidatorConfigBuilder maxFails(int maxFails) {
        this.maxFails = maxFails;
        return this;
    }

    public ValidatorConfigBuilder debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public ValidatorConfigBuilder showErrorMessages(boolean showErrorMessages) {
        this.showErrorMessages = showErrorMessages;
        return this;
    }

    public ValidatorConfigBuilder isLogsEnabled(boolean isLogsEnabled) {
        this.isLogsEnabled = isLogsEnabled;
        return this;
    }

    public ValidatorConfigBuilder loggingLevel(Level loggingLevel) {
        this.loggingLevel = loggingLevel;
        return this;
    }

    public ValidatorConfigBuilder maxNumberOfDisplayedFailedChecks(int maxNumberOfDisplayedFailedChecks) {
        this.maxNumberOfDisplayedFailedChecks = maxNumberOfDisplayedFailedChecks;
        return this;
    }

    public ValidatorConfigBuilder showProgress(boolean showProgress) {
        this.showProgress = showProgress;
        return this;
    }

    public ValidatorConfigBuilder nonPDFExtension(boolean nonPDFExtension) {
        this.nonPDFExtension = nonPDFExtension;
        return this;
    }

    public ValidatorConfigBuilder enabledExtensions(EnumSet<ExtensionObjectType> enabledExtensions) {
        this.enabledExtensions = enabledExtensions;
        return this;
    }

    public static ValidatorConfigBuilder defaultBuilder() {
        return new ValidatorConfigBuilder();
    }

    public ValidatorConfig build() {
        return ValidatorConfigImpl.fromValues(this.flavour, this.defaultFlavour, this.recordPasses, this.maxFails, this.debug, this.isLogsEnabled, this.loggingLevel, this.maxNumberOfDisplayedFailedChecks, this.showErrorMessages, this.password, this.showProgress, this.nonPDFExtension, this.enabledExtensions);
    }
}

