/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Arrays;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.trans.rules.RuleTarget;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.Whitespace;

public class Stripper
extends ProxyReceiver {
    public static final StripRuleTarget STRIP = new StripRuleTarget(){};
    public static final StripRuleTarget PRESERVE = new StripRuleTarget(){};
    protected SpaceStrippingRule rule;
    private int[] stripStack = new int[100];
    private int top = 0;
    public static final int ALWAYS_PRESERVE = 1;
    public static final int ALWAYS_STRIP = 2;
    public static final int STRIP_DEFAULT = 0;
    public static final int PRESERVE_PARENT = 4;
    public static final int SIMPLE_CONTENT = 8;
    public static final int ASSERTIONS_EXIST = 16;

    public Stripper(SpaceStrippingRule rule, Receiver next) {
        super(next);
        assert (rule != null);
        this.rule = rule;
    }

    private int isSpacePreserving(NodeName name, SchemaType type) throws XPathException {
        return this.rule.isSpacePreserving(name, type);
    }

    @Override
    public void open() throws XPathException {
        this.top = 0;
        this.stripStack[this.top] = 1;
        super.open();
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.nextReceiver.startElement(elemName, type, attributes, namespaces, location, properties);
        int preserveParent = this.stripStack[this.top];
        int preserve = preserveParent & 0x14;
        int elementStrip = this.isSpacePreserving(elemName, type);
        if (elementStrip == 1) {
            preserve |= 1;
        } else if (elementStrip == 2) {
            preserve |= 2;
        }
        if (type != Untyped.getInstance()) {
            if (preserve == 0 && (type.isSimpleType() || ((ComplexType)type).isSimpleContent())) {
                preserve |= 8;
            }
            if (type instanceof ComplexType && ((ComplexType)type).hasAssertions()) {
                preserve |= 0x10;
            }
        }
        ++this.top;
        if (this.top >= this.stripStack.length) {
            this.stripStack = Arrays.copyOf(this.stripStack, this.top * 2);
        }
        this.stripStack[this.top] = preserve;
        String xmlSpace = attributes.getValue(NamespaceUri.XML, "space");
        if (xmlSpace != null) {
            if (Whitespace.trim(xmlSpace).equals("preserve")) {
                int n = this.top;
                this.stripStack[n] = this.stripStack[n] | 4;
            } else {
                int n = this.top;
                this.stripStack[n] = this.stripStack[n] & 0xFFFFFFFB;
            }
        }
    }

    @Override
    public void endElement() throws XPathException {
        this.nextReceiver.endElement();
        --this.top;
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (((this.stripStack[this.top] & 0x1D) != 0 && (this.stripStack[this.top] & 2) == 0 || !Whitespace.isAllWhite(chars)) && !chars.isEmpty()) {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    public static class StripRuleTarget
    implements RuleTarget {
        @Override
        public void export(ExpressionPresenter presenter) throws XPathException {
        }

        @Override
        public void registerRule(Rule rule) {
        }
    }
}

