/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.font;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.external.GFFontProgram;
import org.verapdf.gf.model.impl.external.GFTrueTypeFontProgram;
import org.verapdf.gf.model.impl.pd.GFPDResource;
import org.verapdf.gf.model.impl.pd.font.GFPDType0Font;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.pd.font.Encoding;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDFontDescriptor;

public class GFPDFont
extends GFPDResource
implements org.verapdf.model.pdlayer.PDFont {
    public static final String FONT_FILE = "fontFile";
    public static final String BASE_FONT = "BaseFont";
    private static final String TYPE0_STRING = "Type0";
    protected boolean fontProgramParsed;
    protected final RenderingMode renderingMode;

    protected GFPDFont(PDFont font, RenderingMode renderingMode, String type) {
        super(font, type);
        this.renderingMode = renderingMode;
    }

    @Override
    public String getType() {
        return this.pdFont.getType();
    }

    @Override
    public String getSubtype() {
        ASAtom result = this.pdFont.getSubtype();
        return result != null ? result.getValue() : null;
    }

    @Override
    public String getfontName() {
        return this.pdFont.getName();
    }

    @Override
    public Boolean getisSymbolic() {
        return this.pdFont.isSymbolic();
    }

    @Override
    public Long getrenderingMode() {
        return this.renderingMode.getValue();
    }

    @Override
    public String getfontFileSubtype() {
        ASAtom subtype;
        if (this.pdFont != null && (subtype = this.pdFont.getProgramSubtype()) != null) {
            return subtype.getValue();
        }
        return null;
    }

    @Override
    public Boolean getisItalic() {
        PDFontDescriptor fontDescriptor = this.pdFont.getFontDescriptor();
        if (fontDescriptor != null) {
            return fontDescriptor.isItalic();
        }
        return null;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "fontFile": {
                return this.getFontProgram();
            }
            case "BaseFont": {
                return this.getBaseFont();
            }
        }
        return super.getLinkedObjects(link);
    }

    public boolean isFontProgramParsed() {
        return this.fontProgramParsed;
    }

    private List<org.verapdf.model.external.FontProgram> getFontProgram() {
        FontProgram fontProgram = this.pdFont.getFontProgram();
        if (fontProgram != null && this.fontProgramParsed) {
            ASAtom subType = this.pdFont.getSubtype();
            if (ASAtom.TRUE_TYPE == subType) {
                GFTrueTypeFontProgram font = new GFTrueTypeFontProgram(fontProgram);
                return GFPDFont.getFontProgramList(font);
            }
            if (TYPE0_STRING.equals(this.getSubtype())) {
                GFFontProgram font = new GFFontProgram(fontProgram, (GFPDFont)((Object)((GFPDType0Font)this).getDescendantFont()));
                return GFPDFont.getFontProgramList(font);
            }
            GFFontProgram font = new GFFontProgram(fontProgram, this);
            return GFPDFont.getFontProgramList(font);
        }
        return Collections.emptyList();
    }

    private static List<org.verapdf.model.external.FontProgram> getFontProgramList(org.verapdf.model.external.FontProgram fontProgram) {
        ArrayList<org.verapdf.model.external.FontProgram> list = new ArrayList<org.verapdf.model.external.FontProgram>(1);
        list.add(fontProgram);
        return Collections.unmodifiableList(list);
    }

    @Override
    public Boolean getcontainsFontFile() {
        return this.pdFont.getFontProgram() != null && this.fontProgramParsed;
    }

    private List<CosUnicodeName> getBaseFont() {
        String name = this.pdFont.getName();
        if (name != null) {
            ArrayList<GFCosUnicodeName> list = new ArrayList<GFCosUnicodeName>(1);
            list.add(new GFCosUnicodeName((COSName)COSName.construct(ASAtom.getASAtom(name)).get()));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Encoding getEncodingMapping() {
        return this.pdFont.getEncodingMapping();
    }
}

