/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.util.List;

public enum PDFFlavour {
    NO_FLAVOUR(Specification.NO_STANDARD),
    PDFA_1_A(Specification.ISO_19005_1),
    PDFA_1_B(Specification.ISO_19005_1),
    PDFA_2_A(Specification.ISO_19005_2),
    PDFA_2_B(Specification.ISO_19005_2),
    PDFA_2_U(Specification.ISO_19005_2),
    PDFA_3_A(Specification.ISO_19005_3),
    PDFA_3_B(Specification.ISO_19005_3),
    PDFA_3_U(Specification.ISO_19005_3),
    PDFA_4(Specification.ISO_19005_4),
    PDFA_4_F(Specification.ISO_19005_4),
    PDFA_4_E(Specification.ISO_19005_4),
    PDFUA_1(Specification.ISO_14289_1),
    PDFUA_2(Specification.ISO_14289_2),
    WTPDF_1_0_REUSE(Specification.WTPDF_1_0),
    WTPDF_1_0_ACCESSIBILITY(Specification.WTPDF_1_0),
    WCAG_2_1(Specification.WCAG_2_1),
    WCAG_2_2_MACHINE(Specification.WCAG_2_2),
    WCAG_2_2_HUMAN(Specification.WCAG_2_2),
    WCAG_2_2_PDF_2_0_MACHINE(Specification.WCAG_2_2_PDF_2_0),
    WCAG_2_2_PDF_2_0_HUMAN(Specification.WCAG_2_2_PDF_2_0),
    NO_ARLINGTON_FLAVOUR(Specification.NO_STANDARD),
    ARLINGTON1_0(Specification.PDF_1_0),
    ARLINGTON1_1(Specification.PDF_1_1),
    ARLINGTON1_2(Specification.PDF_1_2),
    ARLINGTON1_3(Specification.PDF_1_3),
    ARLINGTON1_4(Specification.PDF_1_4),
    ARLINGTON1_5(Specification.PDF_1_5),
    ARLINGTON1_6(Specification.PDF_1_6),
    ARLINGTON1_7(Specification.ISO_32000_1_7),
    ARLINGTON2_0(Specification.ISO_32000_2_0);

    private final Specification specification;

    private PDFFlavour(Specification specification) {
        this.specification = specification;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public static boolean isFlavourPDFSpecification(List<PDFFlavour> flavours, PDFSpecification pdfSpecification) {
        for (PDFFlavour flavour : flavours) {
            if (!PDFFlavour.isFlavourPDFSpecification(flavour, pdfSpecification)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFlavourPDFSpecification(PDFFlavour flavour, PDFSpecification pdfSpecification) {
        return flavour != null && flavour.getSpecification().getPdfSpecification() == pdfSpecification;
    }

    public static boolean isFlavourFamily(List<PDFFlavour> flavours, SpecificationFamily specificationFamily) {
        for (PDFFlavour flavour : flavours) {
            if (!PDFFlavour.isFlavourFamily(flavour, specificationFamily)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFlavourFamily(PDFFlavour flavour, SpecificationFamily specificationFamily) {
        return flavour != null && flavour.getSpecification().getFamily() == specificationFamily;
    }

    public static boolean isFlavour(PDFFlavour currentFlavour, PDFFlavour flavour) {
        return currentFlavour != null && currentFlavour == flavour;
    }

    public static boolean isFlavourPart(List<PDFFlavour> flavours, Specification specificationPart) {
        for (PDFFlavour flavour : flavours) {
            if (!PDFFlavour.isFlavourPart(flavour, specificationPart)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFlavourPart(PDFFlavour flavour, Specification specificationPart) {
        return flavour != null && flavour.getSpecification() == specificationPart;
    }

    public static boolean isPDFUA2RelatedFlavour(List<PDFFlavour> flavours) {
        for (PDFFlavour flavour : flavours) {
            if (!PDFFlavour.isPDFUA2RelatedFlavour(flavour)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPDFUA2RelatedFlavour(PDFFlavour flavour) {
        return PDFFlavour.isFlavour(flavour, PDFUA_2) || PDFFlavour.isFlavourPart(flavour, Specification.WTPDF_1_0);
    }

    public static enum Specification {
        NO_STANDARD(SpecificationFamily.NONE, PDFSpecification.NO_SPECIFICATION),
        ISO_14289_1(SpecificationFamily.PDF_UA, PDFSpecification.ISO_32000_1_7),
        ISO_14289_2(SpecificationFamily.PDF_UA, PDFSpecification.ISO_32000_2_0),
        ISO_19005_1(SpecificationFamily.PDF_A, PDFSpecification.PDF_REFERENCE_1_4),
        ISO_19005_2(SpecificationFamily.PDF_A, PDFSpecification.ISO_32000_1_7),
        ISO_19005_3(SpecificationFamily.PDF_A, PDFSpecification.ISO_32000_1_7),
        ISO_19005_4(SpecificationFamily.PDF_A, PDFSpecification.ISO_32000_2_0),
        WTPDF_1_0(SpecificationFamily.WTPDF, PDFSpecification.ISO_32000_2_0),
        WCAG_2_1(SpecificationFamily.WCAG, PDFSpecification.ISO_32000_2_0),
        WCAG_2_2(SpecificationFamily.WCAG, PDFSpecification.ISO_32000_1_7),
        WCAG_2_2_PDF_2_0(SpecificationFamily.WCAG, PDFSpecification.ISO_32000_2_0),
        PDF_1_0(SpecificationFamily.ARLINGTON, PDFSpecification.PDF_REFERENCE_1_0),
        PDF_1_1(SpecificationFamily.ARLINGTON, PDFSpecification.PDF_REFERENCE_1_1),
        PDF_1_2(SpecificationFamily.ARLINGTON, PDFSpecification.PDF_REFERENCE_1_2),
        PDF_1_3(SpecificationFamily.ARLINGTON, PDFSpecification.PDF_REFERENCE_1_3),
        PDF_1_4(SpecificationFamily.ARLINGTON, PDFSpecification.PDF_REFERENCE_1_4),
        PDF_1_5(SpecificationFamily.ARLINGTON, PDFSpecification.PDF_REFERENCE_1_5),
        PDF_1_6(SpecificationFamily.ARLINGTON, PDFSpecification.PDF_REFERENCE_1_6),
        ISO_32000_1_7(SpecificationFamily.ARLINGTON, PDFSpecification.ISO_32000_1_7),
        ISO_32000_2_0(SpecificationFamily.ARLINGTON, PDFSpecification.ISO_32000_2_0);

        private final SpecificationFamily family;
        private final PDFSpecification pdfSpecification;

        private Specification(SpecificationFamily family, PDFSpecification pdfSpecification) {
            this.family = family;
            this.pdfSpecification = pdfSpecification;
        }

        public SpecificationFamily getFamily() {
            return this.family;
        }

        public PDFSpecification getPdfSpecification() {
            return this.pdfSpecification;
        }
    }

    public static enum PDFSpecification {
        NO_SPECIFICATION,
        PDF_REFERENCE_1_0,
        PDF_REFERENCE_1_1,
        PDF_REFERENCE_1_2,
        PDF_REFERENCE_1_3,
        PDF_REFERENCE_1_4,
        PDF_REFERENCE_1_5,
        PDF_REFERENCE_1_6,
        ISO_32000_1_7,
        ISO_32000_2_0;

    }

    public static enum SpecificationFamily {
        NONE,
        PDF_A,
        PDF_UA,
        WCAG,
        WTPDF,
        ARLINGTON;

    }
}

