/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFACryptFilter;
import org.verapdf.gf.model.impl.arlington.GFACryptFilterMapEntry;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ACryptFilter;
import org.verapdf.model.alayer.ACryptFilterMap;
import org.verapdf.model.alayer.ACryptFilterMapEntry;
import org.verapdf.model.baselayer.Object;

public class GFACryptFilterMap
extends GFAObject
implements ACryptFilterMap {
    public GFACryptFilterMap(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ACryptFilterMap");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entries": {
                return this.getEntries();
            }
            case "Identity": {
                return this.getIdentity();
            }
            case "StdCF": {
                return this.getStdCF();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ACryptFilterMapEntry> getEntries() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntries1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ACryptFilterMapEntry> getEntries1_5() {
        LinkedList<GFACryptFilterMapEntry> list = new LinkedList<GFACryptFilterMapEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            if ("Identity".equals(key.getValue()) || "StdCF".equals(key.getValue())) continue;
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFACryptFilterMapEntry(object != null ? object.get() : null, this.baseObject, this.parentObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    private List<ACryptFilter> getIdentity() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getIdentity1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ACryptFilter> getIdentity1_5() {
        COSObject object = this.getIdentityValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACryptFilter> list = new ArrayList<GFACryptFilter>(1);
            list.add(new GFACryptFilter((COSDictionary)object.getDirectBase(), this.baseObject, "Identity"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ACryptFilter> getStdCF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getStdCF1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ACryptFilter> getStdCF1_5() {
        COSObject object = this.getStdCFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACryptFilter> list = new ArrayList<GFACryptFilter>(1);
            list.add(new GFACryptFilter((COSDictionary)object.getDirectBase(), this.baseObject, "StdCF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsIdentity() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Identity"));
    }

    public COSObject getIdentityValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Identity"));
        return object;
    }

    @Override
    public String getIdentityType() {
        COSObject Identity = this.getIdentityValue();
        return this.getObjectType(Identity);
    }

    @Override
    public Boolean getIdentityHasTypeDictionary() {
        COSObject Identity = this.getIdentityValue();
        return GFACryptFilterMap.getHasTypeDictionary(Identity);
    }

    @Override
    public Boolean getcontainsStdCF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("StdCF"));
    }

    public COSObject getStdCFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("StdCF"));
        return object;
    }

    @Override
    public String getStdCFType() {
        COSObject StdCF = this.getStdCFValue();
        return this.getObjectType(StdCF);
    }

    @Override
    public Boolean getStdCFHasTypeDictionary() {
        COSObject StdCF = this.getStdCFValue();
        return GFACryptFilterMap.getHasTypeDictionary(StdCF);
    }

    @Override
    public String getStdCFAuthEventNameValue() {
        COSObject StdCF = this.getStdCFValue();
        if (StdCF == null || !StdCF.getType().isDictionaryBased()) {
            return null;
        }
        return new GFACryptFilter(StdCF.getDirectBase(), null, null).getAuthEventNameValue();
    }
}

