/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfAFFileSpecifications;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfCompressionFilterNames;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfDecodeParams;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfNamesGeneral;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfTrapRegions;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAFilterCrypt;
import org.verapdf.gf.model.impl.arlington.GFAFilterFlateDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterLZWDecode;
import org.verapdf.gf.model.impl.arlington.GFAGroupAttributes;
import org.verapdf.gf.model.impl.arlington.GFAMeasureRL;
import org.verapdf.gf.model.impl.arlington.GFAMetadata;
import org.verapdf.gf.model.impl.arlington.GFAOPIVersion13;
import org.verapdf.gf.model.impl.arlington.GFAOPIVersion20;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAOptContentGroup;
import org.verapdf.gf.model.impl.arlington.GFAOptContentMembership;
import org.verapdf.gf.model.impl.arlington.GFAPagePiece;
import org.verapdf.gf.model.impl.arlington.GFAPointData;
import org.verapdf.gf.model.impl.arlington.GFAReference;
import org.verapdf.gf.model.impl.arlington.GFAResource;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfAFFileSpecifications;
import org.verapdf.model.alayer.AArrayOfCompressionFilterNames;
import org.verapdf.model.alayer.AArrayOfNamesGeneral;
import org.verapdf.model.alayer.AArrayOfTrapRegions;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.AGroupAttributes;
import org.verapdf.model.alayer.AMeasureRL;
import org.verapdf.model.alayer.AMetadata;
import org.verapdf.model.alayer.APagePiece;
import org.verapdf.model.alayer.APointData;
import org.verapdf.model.alayer.AReference;
import org.verapdf.model.alayer.AResource;
import org.verapdf.model.alayer.AXObjectFormTrapNet;

public class GFAXObjectFormTrapNet
extends GFAObject
implements AXObjectFormTrapNet {
    public GFAXObjectFormTrapNet(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AXObjectFormTrapNet");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AF": {
                return this.getAF();
            }
            case "DecodeParms": {
                return this.getDecodeParms();
            }
            case "F": {
                return this.getF();
            }
            case "FDecodeParms": {
                return this.getFDecodeParms();
            }
            case "FFilter": {
                return this.getFFilter();
            }
            case "Filter": {
                return this.getFilter();
            }
            case "Group": {
                return this.getGroup();
            }
            case "Measure": {
                return this.getMeasure();
            }
            case "Metadata": {
                return this.getMetadata();
            }
            case "OC": {
                return this.getOC();
            }
            case "OPI": {
                return this.getOPI();
            }
            case "PieceInfo": {
                return this.getPieceInfo();
            }
            case "PtData": {
                return this.getPtData();
            }
            case "Ref": {
                return this.getRef();
            }
            case "Resources": {
                return this.getResources();
            }
            case "SeparationColorNames": {
                return this.getSeparationColorNames();
            }
            case "TrapRegions": {
                return this.getTrapRegions();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfAFFileSpecifications> getAF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionISO_19005_3().booleanValue()) {
                    return this.getAF1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getAF1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfAFFileSpecifications> getAF1_7() {
        COSObject object = this.getAFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfAFFileSpecifications> list = new ArrayList<GFAArrayOfAFFileSpecifications>(1);
            list.add(new GFAArrayOfAFFileSpecifications((COSArray)object.getDirectBase(), this.baseObject, "AF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return this.getDecodeParms1_3();
            }
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_3() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_3(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_3(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_5() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_5(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AFileSpecification> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getF1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getF1_3() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSDictionary)object.getDirectBase(), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return this.getFDecodeParms1_3();
            }
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getFDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_3() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_3(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_3(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_5() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_5(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfCompressionFilterNames> getFFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getFFilter1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFFilter1_3() {
        COSObject object = this.getFFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSArray)object.getDirectBase(), this.baseObject, "FFilter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getFilter1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter1_3() {
        COSObject object = this.getFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSArray)object.getDirectBase(), this.baseObject, "Filter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AGroupAttributes> getGroup() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getGroup1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AGroupAttributes> getGroup1_4() {
        COSObject object = this.getGroupValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAGroupAttributes> list = new ArrayList<GFAGroupAttributes>(1);
            list.add(new GFAGroupAttributes((COSDictionary)object.getDirectBase(), this.baseObject, "Group"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AMeasureRL> getMeasure() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionADBE_Extn3().booleanValue()) {
                    return this.getMeasure1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getMeasure1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AMeasureRL> getMeasure1_7() {
        COSObject object = this.getMeasureValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAMeasureRL> list = new ArrayList<GFAMeasureRL>(1);
            list.add(new GFAMeasureRL((COSDictionary)object.getDirectBase(), this.baseObject, "Measure"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AMetadata> getMetadata() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getMetadata1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AMetadata> getMetadata1_4() {
        COSObject object = this.getMetadataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAMetadata> list = new ArrayList<GFAMetadata>(1);
            list.add(new GFAMetadata((COSStream)object.getDirectBase(), this.baseObject, "Metadata"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getOC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getOC1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getOC1_5() {
        COSObject object = this.getOCValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getOCDictionary1_5(object.getDirectBase(), "OC");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getOCDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom("Type"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "OCG": {
                return new GFAOptContentGroup(base, this.baseObject, keyName);
            }
            case "OCMD": {
                return new GFAOptContentMembership(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getOPI() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getOPI1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getOPI1_3() {
        COSObject object = this.getOPIValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getOPIDictionary1_3(object.getDirectBase(), "OPI");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getOPIDictionary1_3(COSBase base, String keyName) {
        if (base != null && base.knownKey(ASAtom.getASAtom("1.3")).booleanValue()) {
            return new GFAOPIVersion13(base, this.baseObject, keyName);
        }
        if (base != null && base.knownKey(ASAtom.getASAtom("2.0")).booleanValue()) {
            return new GFAOPIVersion20(base, this.baseObject, keyName);
        }
        return null;
    }

    private List<APagePiece> getPieceInfo() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getPieceInfo1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<APagePiece> getPieceInfo1_3() {
        COSObject object = this.getPieceInfoValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAPagePiece> list = new ArrayList<GFAPagePiece>(1);
            list.add(new GFAPagePiece((COSDictionary)object.getDirectBase(), this.baseObject, "PieceInfo"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<APointData> getPtData() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionADBE_Extn3().booleanValue()) {
                    return this.getPtData1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getPtData1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<APointData> getPtData1_7() {
        COSObject object = this.getPtDataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAPointData> list = new ArrayList<GFAPointData>(1);
            list.add(new GFAPointData((COSDictionary)object.getDirectBase(), this.baseObject, "PtData"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AReference> getRef() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getRef1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AReference> getRef1_4() {
        COSObject object = this.getRefValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAReference> list = new ArrayList<GFAReference>(1);
            list.add(new GFAReference((COSDictionary)object.getDirectBase(), this.baseObject, "Ref"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AResource> getResources() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getResources1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AResource> getResources1_3() {
        COSObject object = this.getResourcesValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAResource> list = new ArrayList<GFAResource>(1);
            list.add(new GFAResource((COSDictionary)object.getDirectBase(), this.baseObject, "Resources"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNamesGeneral> getSeparationColorNames() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getSeparationColorNames1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNamesGeneral> getSeparationColorNames1_3() {
        COSObject object = this.getSeparationColorNamesValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNamesGeneral> list = new ArrayList<GFAArrayOfNamesGeneral>(1);
            list.add(new GFAArrayOfNamesGeneral((COSArray)object.getDirectBase(), this.baseObject, "SeparationColorNames"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfTrapRegions> getTrapRegions() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getTrapRegions1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfTrapRegions> getTrapRegions1_3() {
        COSObject object = this.getTrapRegionsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfTrapRegions> list = new ArrayList<GFAArrayOfTrapRegions>(1);
            list.add(new GFAArrayOfTrapRegions((COSArray)object.getDirectBase(), this.baseObject, "TrapRegions"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsAF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("AF"));
    }

    public COSObject getAFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("AF"));
        return object;
    }

    @Override
    public String getAFType() {
        COSObject AF = this.getAFValue();
        return this.getObjectType(AF);
    }

    @Override
    public Boolean getAFHasTypeArray() {
        COSObject AF = this.getAFValue();
        return GFAXObjectFormTrapNet.getHasTypeArray(AF);
    }

    @Override
    public Boolean getcontainsBBox() {
        return this.baseObject.knownKey(ASAtom.getASAtom("BBox"));
    }

    public COSObject getBBoxValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("BBox"));
        return object;
    }

    @Override
    public String getBBoxType() {
        COSObject BBox = this.getBBoxValue();
        return this.getObjectType(BBox);
    }

    @Override
    public Boolean getBBoxHasTypeRectangle() {
        COSObject BBox = this.getBBoxValue();
        return GFAXObjectFormTrapNet.getHasTypeRectangle(BBox);
    }

    @Override
    public Boolean getcontainsDL() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DL"));
    }

    public COSObject getDLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DL"));
        return object;
    }

    @Override
    public String getDLType() {
        COSObject DL = this.getDLValue();
        return this.getObjectType(DL);
    }

    @Override
    public Boolean getDLHasTypeInteger() {
        COSObject DL = this.getDLValue();
        return GFAXObjectFormTrapNet.getHasTypeInteger(DL);
    }

    @Override
    public Long getDLIntegerValue() {
        COSObject DL = this.getDLValue();
        return GFAXObjectFormTrapNet.getIntegerValue(DL);
    }

    @Override
    public Boolean getcontainsDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DecodeParms"));
    }

    public COSObject getDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DecodeParms"));
        return object;
    }

    @Override
    public String getDecodeParmsType() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return this.getObjectType(DecodeParms);
    }

    @Override
    public Boolean getDecodeParmsHasTypeArray() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXObjectFormTrapNet.getHasTypeArray(DecodeParms);
    }

    @Override
    public Boolean getDecodeParmsHasTypeDictionary() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXObjectFormTrapNet.getHasTypeDictionary(DecodeParms);
    }

    @Override
    public Long getDecodeParmsArraySize() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXObjectFormTrapNet.getArraySize(DecodeParms);
    }

    @Override
    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("F"));
        return object;
    }

    @Override
    public String getFType() {
        COSObject F = this.getFValue();
        return this.getObjectType(F);
    }

    @Override
    public Boolean getFHasTypeDictionary() {
        COSObject F = this.getFValue();
        return GFAXObjectFormTrapNet.getHasTypeDictionary(F);
    }

    @Override
    public Boolean getFHasTypeString() {
        COSObject F = this.getFValue();
        return GFAXObjectFormTrapNet.getHasTypeString(F);
    }

    @Override
    public Boolean getcontainsFDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FDecodeParms"));
    }

    public COSObject getFDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FDecodeParms"));
        return object;
    }

    @Override
    public String getFDecodeParmsType() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return this.getObjectType(FDecodeParms);
    }

    @Override
    public Boolean getFDecodeParmsHasTypeArray() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXObjectFormTrapNet.getHasTypeArray(FDecodeParms);
    }

    @Override
    public Boolean getFDecodeParmsHasTypeDictionary() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXObjectFormTrapNet.getHasTypeDictionary(FDecodeParms);
    }

    @Override
    public Long getFDecodeParmsArraySize() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXObjectFormTrapNet.getArraySize(FDecodeParms);
    }

    @Override
    public Boolean getcontainsFFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FFilter"));
    }

    public COSObject getFFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FFilter"));
        return object;
    }

    @Override
    public String getFFilterType() {
        COSObject FFilter = this.getFFilterValue();
        return this.getObjectType(FFilter);
    }

    @Override
    public Boolean getFFilterHasTypeArray() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectFormTrapNet.getHasTypeArray(FFilter);
    }

    @Override
    public Boolean getFFilterHasTypeName() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectFormTrapNet.getHasTypeName(FFilter);
    }

    @Override
    public String getFFilterNameValue() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectFormTrapNet.getNameValue(FFilter);
    }

    @Override
    public Long getFFilterArraySize() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectFormTrapNet.getArraySize(FFilter);
    }

    @Override
    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        return object;
    }

    @Override
    public String getFilterType() {
        COSObject Filter2 = this.getFilterValue();
        return this.getObjectType(Filter2);
    }

    @Override
    public Boolean getFilterHasTypeArray() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectFormTrapNet.getHasTypeArray(Filter2);
    }

    @Override
    public Boolean getFilterHasTypeName() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectFormTrapNet.getHasTypeName(Filter2);
    }

    @Override
    public String getFilterNameValue() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectFormTrapNet.getNameValue(Filter2);
    }

    @Override
    public Long getFilterArraySize() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectFormTrapNet.getArraySize(Filter2);
    }

    @Override
    public Boolean getcontainsFormType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FormType"));
    }

    public COSObject getFormTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FormType"));
        return object;
    }

    @Override
    public String getFormTypeType() {
        COSObject FormType = this.getFormTypeValue();
        return this.getObjectType(FormType);
    }

    @Override
    public Boolean getFormTypeHasTypeInteger() {
        COSObject FormType = this.getFormTypeValue();
        return GFAXObjectFormTrapNet.getHasTypeInteger(FormType);
    }

    @Override
    public Long getFormTypeIntegerValue() {
        COSObject FormType = this.getFormTypeValue();
        return GFAXObjectFormTrapNet.getIntegerValue(FormType);
    }

    @Override
    public Boolean getcontainsGroup() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Group"));
    }

    public COSObject getGroupValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Group"));
        return object;
    }

    @Override
    public String getGroupType() {
        COSObject Group2 = this.getGroupValue();
        return this.getObjectType(Group2);
    }

    @Override
    public Boolean getGroupHasTypeDictionary() {
        COSObject Group2 = this.getGroupValue();
        return GFAXObjectFormTrapNet.getHasTypeDictionary(Group2);
    }

    @Override
    public Boolean getcontainsLastModified() {
        return this.baseObject.knownKey(ASAtom.getASAtom("LastModified"));
    }

    public COSObject getLastModifiedValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("LastModified"));
        return object;
    }

    @Override
    public String getLastModifiedType() {
        COSObject LastModified = this.getLastModifiedValue();
        return this.getObjectType(LastModified);
    }

    @Override
    public Boolean getLastModifiedHasTypeDate() {
        COSObject LastModified = this.getLastModifiedValue();
        return GFAXObjectFormTrapNet.getHasTypeDate(LastModified);
    }

    @Override
    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Length"));
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Length"));
        return object;
    }

    @Override
    public String getLengthType() {
        COSObject Length = this.getLengthValue();
        return this.getObjectType(Length);
    }

    @Override
    public Boolean getLengthHasTypeInteger() {
        COSObject Length = this.getLengthValue();
        return GFAXObjectFormTrapNet.getHasTypeInteger(Length);
    }

    @Override
    public Boolean getcontainsMatrix() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Matrix"));
    }

    public COSObject getMatrixDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return COSArray.construct(6, new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0});
            }
        }
        return null;
    }

    public COSObject getMatrixValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Matrix"));
        if (object == null || object.empty()) {
            object = this.getMatrixDefaultValue();
        }
        return object;
    }

    @Override
    public String getMatrixType() {
        COSObject Matrix = this.getMatrixValue();
        return this.getObjectType(Matrix);
    }

    @Override
    public Boolean getMatrixHasTypeMatrix() {
        COSObject Matrix = this.getMatrixValue();
        return GFAXObjectFormTrapNet.getHasTypeMatrix(Matrix);
    }

    @Override
    public Boolean getcontainsMeasure() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Measure"));
    }

    public COSObject getMeasureValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Measure"));
        return object;
    }

    @Override
    public String getMeasureType() {
        COSObject Measure = this.getMeasureValue();
        return this.getObjectType(Measure);
    }

    @Override
    public Boolean getMeasureHasTypeDictionary() {
        COSObject Measure = this.getMeasureValue();
        return GFAXObjectFormTrapNet.getHasTypeDictionary(Measure);
    }

    @Override
    public Boolean getcontainsMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Metadata"));
    }

    public COSObject getMetadataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Metadata"));
        return object;
    }

    @Override
    public Boolean getisMetadataIndirect() {
        COSObject Metadata2 = this.getMetadataValue();
        return GFAXObjectFormTrapNet.getisIndirect(Metadata2);
    }

    @Override
    public String getMetadataType() {
        COSObject Metadata2 = this.getMetadataValue();
        return this.getObjectType(Metadata2);
    }

    @Override
    public Boolean getMetadataHasTypeStream() {
        COSObject Metadata2 = this.getMetadataValue();
        return GFAXObjectFormTrapNet.getHasTypeStream(Metadata2);
    }

    @Override
    public Boolean getcontainsName() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Name"));
    }

    public COSObject getNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Name"));
        return object;
    }

    @Override
    public String getNameType() {
        COSObject Name4 = this.getNameValue();
        return this.getObjectType(Name4);
    }

    @Override
    public Boolean getNameHasTypeName() {
        COSObject Name4 = this.getNameValue();
        return GFAXObjectFormTrapNet.getHasTypeName(Name4);
    }

    @Override
    public Boolean getcontainsOC() {
        return this.baseObject.knownKey(ASAtom.getASAtom("OC"));
    }

    public COSObject getOCValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OC"));
        return object;
    }

    @Override
    public String getOCType() {
        COSObject OC = this.getOCValue();
        return this.getObjectType(OC);
    }

    @Override
    public Boolean getOCHasTypeDictionary() {
        COSObject OC = this.getOCValue();
        return GFAXObjectFormTrapNet.getHasTypeDictionary(OC);
    }

    @Override
    public Boolean getcontainsOPI() {
        return this.baseObject.knownKey(ASAtom.getASAtom("OPI"));
    }

    public COSObject getOPIValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OPI"));
        return object;
    }

    @Override
    public String getOPIType() {
        COSObject OPI = this.getOPIValue();
        return this.getObjectType(OPI);
    }

    @Override
    public Boolean getOPIHasTypeDictionary() {
        COSObject OPI = this.getOPIValue();
        return GFAXObjectFormTrapNet.getHasTypeDictionary(OPI);
    }

    @Override
    public Boolean getcontainsPCM() {
        return this.baseObject.knownKey(ASAtom.getASAtom("PCM"));
    }

    public COSObject getPCMValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("PCM"));
        return object;
    }

    @Override
    public String getPCMType() {
        COSObject PCM = this.getPCMValue();
        return this.getObjectType(PCM);
    }

    @Override
    public Boolean getPCMHasTypeName() {
        COSObject PCM = this.getPCMValue();
        return GFAXObjectFormTrapNet.getHasTypeName(PCM);
    }

    @Override
    public String getPCMNameValue() {
        COSObject PCM = this.getPCMValue();
        return GFAXObjectFormTrapNet.getNameValue(PCM);
    }

    @Override
    public Boolean getcontainsPieceInfo() {
        return this.baseObject.knownKey(ASAtom.getASAtom("PieceInfo"));
    }

    public COSObject getPieceInfoValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("PieceInfo"));
        return object;
    }

    @Override
    public String getPieceInfoType() {
        COSObject PieceInfo = this.getPieceInfoValue();
        return this.getObjectType(PieceInfo);
    }

    @Override
    public Boolean getPieceInfoHasTypeDictionary() {
        COSObject PieceInfo = this.getPieceInfoValue();
        return GFAXObjectFormTrapNet.getHasTypeDictionary(PieceInfo);
    }

    @Override
    public Boolean getcontainsPtData() {
        return this.baseObject.knownKey(ASAtom.getASAtom("PtData"));
    }

    public COSObject getPtDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("PtData"));
        return object;
    }

    @Override
    public String getPtDataType() {
        COSObject PtData = this.getPtDataValue();
        return this.getObjectType(PtData);
    }

    @Override
    public Boolean getPtDataHasTypeDictionary() {
        COSObject PtData = this.getPtDataValue();
        return GFAXObjectFormTrapNet.getHasTypeDictionary(PtData);
    }

    @Override
    public Boolean getcontainsRef() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Ref"));
    }

    public COSObject getRefValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Ref"));
        return object;
    }

    @Override
    public String getRefType() {
        COSObject Ref2 = this.getRefValue();
        return this.getObjectType(Ref2);
    }

    @Override
    public Boolean getRefHasTypeDictionary() {
        COSObject Ref2 = this.getRefValue();
        return GFAXObjectFormTrapNet.getHasTypeDictionary(Ref2);
    }

    @Override
    public Boolean getcontainsResources() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Resources"));
    }

    public COSObject getResourcesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Resources"));
        return object;
    }

    @Override
    public String getResourcesType() {
        COSObject Resources = this.getResourcesValue();
        return this.getObjectType(Resources);
    }

    @Override
    public Boolean getResourcesHasTypeDictionary() {
        COSObject Resources = this.getResourcesValue();
        return GFAXObjectFormTrapNet.getHasTypeDictionary(Resources);
    }

    @Override
    public Boolean getcontainsSeparationColorNames() {
        return this.baseObject.knownKey(ASAtom.getASAtom("SeparationColorNames"));
    }

    public COSObject getSeparationColorNamesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("SeparationColorNames"));
        return object;
    }

    @Override
    public String getSeparationColorNamesType() {
        COSObject SeparationColorNames = this.getSeparationColorNamesValue();
        return this.getObjectType(SeparationColorNames);
    }

    @Override
    public Boolean getSeparationColorNamesHasTypeArray() {
        COSObject SeparationColorNames = this.getSeparationColorNamesValue();
        return GFAXObjectFormTrapNet.getHasTypeArray(SeparationColorNames);
    }

    @Override
    public Boolean getcontainsStructParent() {
        return this.baseObject.knownKey(ASAtom.getASAtom("StructParent"));
    }

    public COSObject getStructParentValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("StructParent"));
        return object;
    }

    @Override
    public String getStructParentType() {
        COSObject StructParent = this.getStructParentValue();
        return this.getObjectType(StructParent);
    }

    @Override
    public Boolean getStructParentHasTypeInteger() {
        COSObject StructParent = this.getStructParentValue();
        return GFAXObjectFormTrapNet.getHasTypeInteger(StructParent);
    }

    @Override
    public Boolean getcontainsStructParents() {
        return this.baseObject.knownKey(ASAtom.getASAtom("StructParents"));
    }

    public COSObject getStructParentsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("StructParents"));
        return object;
    }

    @Override
    public String getStructParentsType() {
        COSObject StructParents = this.getStructParentsValue();
        return this.getObjectType(StructParents);
    }

    @Override
    public Boolean getStructParentsHasTypeInteger() {
        COSObject StructParents = this.getStructParentsValue();
        return GFAXObjectFormTrapNet.getHasTypeInteger(StructParents);
    }

    @Override
    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Subtype"));
        return object;
    }

    @Override
    public String getSubtypeType() {
        COSObject Subtype = this.getSubtypeValue();
        return this.getObjectType(Subtype);
    }

    @Override
    public Boolean getSubtypeHasTypeName() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAXObjectFormTrapNet.getHasTypeName(Subtype);
    }

    @Override
    public String getSubtypeNameValue() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAXObjectFormTrapNet.getNameValue(Subtype);
    }

    @Override
    public Boolean getcontainsTrapRegions() {
        return this.baseObject.knownKey(ASAtom.getASAtom("TrapRegions"));
    }

    public COSObject getTrapRegionsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("TrapRegions"));
        return object;
    }

    @Override
    public String getTrapRegionsType() {
        COSObject TrapRegions = this.getTrapRegionsValue();
        return this.getObjectType(TrapRegions);
    }

    @Override
    public Boolean getTrapRegionsHasTypeArray() {
        COSObject TrapRegions = this.getTrapRegionsValue();
        return GFAXObjectFormTrapNet.getHasTypeArray(TrapRegions);
    }

    @Override
    public Boolean getcontainsTrapStyles() {
        return this.baseObject.knownKey(ASAtom.getASAtom("TrapStyles"));
    }

    public COSObject getTrapStylesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("TrapStyles"));
        return object;
    }

    @Override
    public String getTrapStylesType() {
        COSObject TrapStyles = this.getTrapStylesValue();
        return this.getObjectType(TrapStyles);
    }

    @Override
    public Boolean getTrapStylesHasTypeStringText() {
        COSObject TrapStyles = this.getTrapStylesValue();
        return GFAXObjectFormTrapNet.getHasTypeStringText(TrapStyles);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAXObjectFormTrapNet.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAXObjectFormTrapNet.getNameValue(Type2);
    }
}

