/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.version;

import org.verapdf.version.SemanticVersionNumber;
import org.verapdf.version.VersionNumberImpl;

public final class Versions {
    private static final String snapshotBuildInfo = "-SNAPSHOT";
    private static final String versionPrefix = "v";

    private Versions() {
        throw new AssertionError((Object)"Should never be here");
    }

    public static SemanticVersionNumber fromString(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("Argument versionString can not be null");
        }
        if (versionString.isEmpty()) {
            throw new IllegalArgumentException("Argument versionString can not be empty");
        }
        String strippedVersion = versionString;
        strippedVersion = strippedVersion.endsWith(snapshotBuildInfo) ? strippedVersion.replace(snapshotBuildInfo, "") : strippedVersion;
        strippedVersion = strippedVersion.startsWith(versionPrefix) ? strippedVersion.replaceFirst(versionPrefix, "") : strippedVersion;
        return VersionNumberImpl.fromString(strippedVersion);
    }

    public static SemanticVersionNumber fromStrings(String[] parts) {
        return VersionNumberImpl.fromStrings(parts);
    }

    public static SemanticVersionNumber fromInts(int[] parts) {
        return VersionNumberImpl.fromInts(parts);
    }

    public static SemanticVersionNumber fromInts(int major, int minor, int revision) {
        return VersionNumberImpl.fromInts(major, minor, revision);
    }
}

