/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.util.HashMap;
import java.util.Map;

public class Token {
    public Type type;
    public Keyword keyword;
    public long integer;
    public double real;
    private StringBuilder token = new StringBuilder();
    private boolean containsOnlyHex = true;
    private long hexCount = 0L;
    private static final Map<String, Keyword> KEYWORDS = new HashMap<String, Keyword>();

    public void toKeyword() {
        this.type = Type.TT_KEYWORD;
        this.keyword = Token.getKeyword(this.token.toString());
    }

    public void append(char c) {
        this.token.append(c);
    }

    public String getValue() {
        return new String(this.getByteValue());
    }

    public byte[] getByteValue() {
        byte[] res = new byte[this.token.length()];
        for (int i = 0; i < this.token.length(); ++i) {
            res[i] = (byte)this.token.charAt(i);
        }
        return res;
    }

    public void clearValue() {
        this.token.setLength(0);
    }

    public static Keyword getKeyword(String keyword) {
        return KEYWORDS.get(keyword);
    }

    public boolean isContainsOnlyHex() {
        return this.containsOnlyHex;
    }

    public void setContainsOnlyHex(boolean containsOnlyHex) {
        this.containsOnlyHex = containsOnlyHex;
    }

    public Long getHexCount() {
        return this.hexCount;
    }

    public void setHexCount(Long hexCount) {
        this.hexCount = hexCount;
    }

    public void setByteValue(byte[] array) {
        this.clearValue();
        for (byte b : array) {
            this.token.append((char)b);
        }
    }

    static {
        KEYWORDS.put("null", Keyword.KW_NULL);
        KEYWORDS.put("true", Keyword.KW_TRUE);
        KEYWORDS.put("false", Keyword.KW_FALSE);
        KEYWORDS.put("stream", Keyword.KW_STREAM);
        KEYWORDS.put("endstream", Keyword.KW_ENDSTREAM);
        KEYWORDS.put("obj", Keyword.KW_OBJ);
        KEYWORDS.put("endobj", Keyword.KW_ENDOBJ);
        KEYWORDS.put("R", Keyword.KW_R);
        KEYWORDS.put("n", Keyword.KW_N);
        KEYWORDS.put("f", Keyword.KW_F);
        KEYWORDS.put("xref", Keyword.KW_XREF);
        KEYWORDS.put("startxref", Keyword.KW_STARTXREF);
        KEYWORDS.put("trailer", Keyword.KW_TRAILER);
        KEYWORDS.put(null, Keyword.KW_NONE);
    }

    public static enum Keyword {
        KW_NONE,
        KW_NULL,
        KW_TRUE,
        KW_FALSE,
        KW_STREAM,
        KW_ENDSTREAM,
        KW_OBJ,
        KW_ENDOBJ,
        KW_R,
        KW_N,
        KW_F,
        KW_XREF,
        KW_STARTXREF,
        KW_TRAILER;

    }

    public static enum Type {
        TT_NONE,
        TT_KEYWORD,
        TT_INTEGER,
        TT_REAL,
        TT_LITSTRING,
        TT_HEXSTRING,
        TT_NAME,
        TT_OPENARRAY,
        TT_CLOSEARRAY,
        TT_OPENDICT,
        TT_CLOSEDICT,
        TT_EOF,
        TT_STARTPROC,
        TT_ENDPROC;

    }
}

